/*
 * Copyright 2009-2010 Nanjing RedOrange ltd (http://www.red-orange.cn)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package redora.generator;

import org.apache.commons.io.IOUtils;
import redora.generator.FileLocations;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * Occurs when it generates.
 * Has a simple util to print the model.
 *
 * @author Nanjing RedOrange (http://www.red-orange.cn)
*/
public class ModelGenerationException extends Exception {

    private static final long serialVersionUID = 1L;

    /**
     * Return a string with the contents of the model's XML.
     *
     * @param where (Mandatory)
     * @param modelFileName (Mandatory) Filename including .xml suffix but without the path.
     * @return Always something, the file as string or an error message.
     */
    public static String printModel(FileLocations where, String modelFileName) {
        try {
            return IOUtils.toString(new FileInputStream(new File(where.modelDir, modelFileName)));
        } catch (IOException e) {}

        return "Failed to retrieve the model file (" + modelFileName
                + ").";
    }

    /**
     * Similar to the printModel, but then it takes the include file.
     * @param where (Mandatory)
     * @param includeFileName (Mandatory) Filename including .xml suffix but without the path.
     * @return Always something, the file as string or an error message.
     */
    public static String printInclude(FileLocations where, String includeFileName) {
        try {
            return IOUtils.toString(new FileInputStream(new File(where.includeDir, includeFileName)));
        } catch (IOException e) {}

        return "Failed to retrieve the include file (" + includeFileName
                + ").";
    }

    public ModelGenerationException(String s, Exception e) {
        super(s, e);
    }

    public ModelGenerationException(String s) {
        super(s);
    }
}
