/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import redora.generator.ModelGenerationException;

public class FileLocations {
    public final String buildDir;
    public final String sourceDir;
    public final String resourceDir;
    public final String applicationFile;
    public final String modelDir;
    public final String includeDir;
    public final String upgradeDir;
    public final String redoraDir;
    public final String templatesDir;

    public FileLocations(String buildDir, String artifactId) throws ModelGenerationException {
        this.buildDir = buildDir;
        this.templatesDir = buildDir + File.separatorChar + "generated-resources";
        String src = "src";
        String md = src + File.separatorChar + "main" + File.separatorChar + "resources" + File.separatorChar + "model";
        if (!new File(md).exists() || new File(md).list((FilenameFilter)new SuffixFileFilter(".xml")).length == 0) {
            src = artifactId + File.separatorChar + src;
            md = artifactId + File.separatorChar + md;
            if (!new File(md).exists() || new File(md).list((FilenameFilter)new SuffixFileFilter(".xml")).length == 0) {
                throw new ModelGenerationException("Can't find project root: " + new File(md).getAbsolutePath());
            }
        }
        this.modelDir = md;
        this.resourceDir = src + File.separatorChar + "main" + File.separatorChar + "resources";
        this.applicationFile = this.resourceDir + File.separatorChar + "application.xml";
        this.sourceDir = src + File.separatorChar + "main" + File.separatorChar + "java";
        this.includeDir = this.modelDir + File.separatorChar + "includes";
        this.upgradeDir = this.resourceDir + File.separatorChar + "upgrade";
        this.redoraDir = System.getProperty("user.home") + File.separatorChar + ".redora";
    }

    public String toString() {
        return "modelDir: " + this.modelDir + ", applicationDir: " + this.applicationFile + ", sourceDir: " + this.sourceDir + ", redoraDir: " + this.redoraDir;
    }
}

