/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import redora.generator.FileLocations;
import redora.generator.ModelGenerationException;
import redora.generator.ModelProcessor;

public class GenerateMojo
extends AbstractMojo {
    private static final String PACKAGE_SUFFIX = "rdo";
    public static final String GENERATION_TARGET = "redora-target";
    private File buildDir;
    private String basePackage;
    private String artifactId;
    private String defaultLanguage;

    public void execute() throws MojoExecutionException {
        FileLocations where;
        File generateDirectory = new File(this.buildDir + File.separator + "generated-sources" + File.separator + GENERATION_TARGET);
        try {
            where = new FileLocations(this.buildDir.getAbsolutePath(), this.artifactId);
        }
        catch (ModelGenerationException e) {
            throw new MojoExecutionException("File error", (Exception)e);
        }
        this.getLog().info((CharSequence)"Generating source for you. I will use the following directories and settings");
        this.getLog().info((CharSequence)("- Java source: " + where.sourceDir));
        this.getLog().info((CharSequence)("- Generated java source " + generateDirectory.getPath()));
        this.getLog().info((CharSequence)("- Base package " + this.basePackage + "(." + PACKAGE_SUFFIX + ')'));
        ModelProcessor p = null;
        try {
            p = new ModelProcessor(where, this.basePackage + '.' + PACKAGE_SUFFIX, this.artifactId, this.defaultLanguage);
            p.generate();
            this.getLog().info((CharSequence)"All model sources are generated");
        }
        catch (ModelGenerationException e) {
            if (p == null) {
                throw new MojoExecutionException("Could not initialize the ModelProcessor", (Exception)e);
            }
            throw new MojoExecutionException("Something went wrong generating your source, sorry.\r\n" + p.dump(), (Exception)e);
        }
    }
}

