/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import redora.generator.ModelGenerationException;
import redora.generator.Template;

public class GeneratorTemplate {
    final Document doc;
    final String templatesDir;

    public GeneratorTemplate(@NotNull String templateDir) throws ModelGenerationException {
        this.templatesDir = templateDir;
        File templates = new File(templateDir + File.separatorChar + "templates.xml");
        FileInputStream in = null;
        try {
            in = new FileInputStream(templates);
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            try {
                if (in == null) {
                    throw new ModelGenerationException("Failed to initialize templates.xml, i could not get the file " + templates.getAbsolutePath() + " (" + templates.exists() + ")", e);
                }
                throw new ModelGenerationException("Failed to initialize templates.xml. If you use a custom templates.xml make sure it is valid.", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    @NotNull
    public List<Template> byInput(@NotNull Template.Input input) throws ModelGenerationException {
        NodeList templateNodes;
        LinkedList<Template> retVal = new LinkedList<Template>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            templateNodes = (NodeList)xpath.evaluate("//template[@input='" + (Object)((Object)input) + "']", this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ModelGenerationException("Filter on " + (Object)((Object)input) + " failed", e);
        }
        for (int i = 0; i < templateNodes.getLength(); ++i) {
            retVal.add(this.from(templateNodes.item(i)));
        }
        return retVal;
    }

    @NotNull
    public Template from(@NotNull Node node) {
        Template retVal = new Template(node.getAttributes().getNamedItem("name").getNodeValue(), Template.Type.valueOf(node.getAttributes().getNamedItem("type").getNodeValue()), Template.Destination.valueOf(node.getAttributes().getNamedItem("destination").getNodeValue()), this.templatesDir);
        if (node.getAttributes().getNamedItem("templateFileName") != null) {
            retVal.setTemplateFileName(node.getAttributes().getNamedItem("templateFileName").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("ignoreProjects") != null) {
            retVal.setIgnoreProjects(node.getAttributes().getNamedItem("ignoreProjects").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("destinationType") != null) {
            retVal.setDestinationType(Template.DestinationType.valueOf(node.getAttributes().getNamedItem("destinationType").getNodeValue()));
        }
        if (node.getAttributes().getNamedItem("input") != null) {
            retVal.setInput(Template.Input.valueOf(node.getAttributes().getNamedItem("input").getNodeValue()));
        }
        if (node.getAttributes().getNamedItem("package") != null) {
            retVal.setPackageSuffix(node.getAttributes().getNamedItem("package").getNodeValue());
        }
        if (node.getAttributes().getNamedItem("path") != null) {
            retVal.setPath(node.getAttributes().getNamedItem("path").getNodeValue());
        }
        return retVal;
    }
}

