/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import redora.generator.ModelGenerationException;
import redora.generator.XMLUtil;
import redora.util.DocPrint;

public class Internationalizer {
    final String defaultLanguage;
    Document doc;

    public Internationalizer(@NotNull String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public void internationalize(@NotNull Document doc, @NotNull String modelName) throws ModelGenerationException {
        this.doc = doc;
        this.i18nObject(modelName);
        this.i18nAttributes();
        this.i18nEnum();
    }

    private void normalizeCaption(@NotNull Node caption) {
        XMLUtil.attribute(caption, "table", caption.getAttributes().getNamedItem("form").getNodeValue());
    }

    private void addCaption(Element parent, String captionSource) {
        Element tagElement = this.doc.createElement("caption");
        parent.appendChild(tagElement);
        XMLUtil.attribute(tagElement, "language", this.defaultLanguage);
        String captionName = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)StringUtils.capitalize((String)captionSource)), (char)' ');
        XMLUtil.attribute(tagElement, "form", captionName);
        XMLUtil.attribute(tagElement, "table", captionName);
    }

    private void doElement(Element element, String nodeName) {
        boolean hasCaption = false;
        NodeList captions = element.getChildNodes();
        for (int i = 0; i < captions.getLength(); ++i) {
            if (!"caption".equals(captions.item(i).getNodeName())) continue;
            if (this.defaultLanguage.equals(captions.item(i).getAttributes().getNamedItem("language").getNodeValue())) {
                hasCaption = true;
            }
            this.normalizeCaption(captions.item(i));
        }
        if (!hasCaption) {
            this.addCaption(element, nodeName);
        }
    }

    private void i18nObject(String modelName) {
        this.doElement(this.doc.getDocumentElement(), modelName);
    }

    private void i18nAttributes() throws ModelGenerationException {
        NodeList attributes;
        try {
            attributes = XMLUtil.attributes(this.doc, null);
        }
        catch (XPathExpressionException e) {
            DocPrint.print((Node)this.doc);
            throw new ModelGenerationException("Failed to parse the attributes in this model", e);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            this.doElement((Element)attribute, attribute.getAttributes().getNamedItem("fieldName").getNodeValue());
        }
    }

    private void i18nEnum() throws ModelGenerationException {
        NodeList enums;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            enums = (NodeList)xpath.evaluate("//enum", this.doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            DocPrint.print((Node)this.doc);
            throw new ModelGenerationException("Failed to parse the attributes in this model", e);
        }
        for (int i = 0; i < enums.getLength(); ++i) {
            NodeList enumElements = enums.item(i).getChildNodes();
            for (int j = 0; j < enumElements.getLength(); ++j) {
                Node element = enumElements.item(j);
                if (!"element".equals(element.getNodeName())) continue;
                this.doElement((Element)element, element.getAttributes().getNamedItem("name").getNodeValue());
            }
        }
    }
}

