/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.jetbrains.annotations.NotNull;
import redora.generator.FileLocations;

public class ModelFileFinder {
    private final FileLocations where;
    private final String artifactId;

    public ModelFileFinder(@NotNull FileLocations where, @NotNull String artifactId) {
        this.where = where;
        this.artifactId = artifactId;
    }

    @NotNull
    public Set<String> findModelFiles() {
        HashSet<String> retVal = new HashSet<String>();
        String[] model = new File(this.where.modelDir).list((FilenameFilter)new SuffixFileFilter(".xml"));
        if (model != null && model.length > 0) {
            Collections.addAll(retVal, model);
        }
        return retVal;
    }

    @NotNull
    public Set<String> findIncludeFiles() {
        HashSet<String> retVal = new HashSet<String>();
        String[] model = new File(this.where.includeDir).list((FilenameFilter)new SuffixFileFilter(".xml"));
        if (model != null && model.length > 0) {
            Collections.addAll(retVal, model);
        }
        return retVal;
    }

    @NotNull
    public SortedSet<String> upgradeFiles() {
        TreeSet<String> retVal = new TreeSet<String>();
        String[] upgrades = new File(this.where.upgradeDir).list((FilenameFilter)new SuffixFileFilter(".sql"));
        if (upgrades != null && upgrades.length > 0) {
            Collections.addAll(retVal, upgrades);
        }
        return retVal;
    }

    @NotNull
    public File normalizedModelFile(@NotNull String modelName) {
        File retVal = new File(this.where.redoraDir + File.separatorChar + this.artifactId, modelName + ".xml");
        if (!retVal.exists()) {
            retVal.mkdirs();
        }
        return retVal;
    }

    @NotNull
    public File allModelFiles() {
        File retVal = new File(this.where.redoraDir + File.separatorChar + this.artifactId, "allModels.xml");
        if (!retVal.exists()) {
            retVal.mkdirs();
        }
        return retVal;
    }
}

