/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import redora.generator.FileLocations;
import redora.generator.GeneratorTemplate;
import redora.generator.Internationalizer;
import redora.generator.ModelFileFinder;
import redora.generator.ModelGenerationException;
import redora.generator.Normalizer;
import redora.generator.Template;
import redora.generator.TemplateProcessor;
import redora.generator.XMLUtil;
import redora.util.DefaultErrorHandler;
import redora.util.SchemaValidator;

public class ModelProcessor {
    public static final String MODEL_SCHEMA = "/model.xsd";
    public static final String APPLICATION_SCHEMA = "/application.xsd";
    public static final String INCLUDE_SCHEMA = "/include.xsd";
    final FileLocations where;
    final GeneratorTemplate templateTemplate;
    final TemplateProcessor templateProcessor;
    final ModelFileFinder finder;
    final String basePackage;
    final String defaultLanguage;
    final String artifactId;
    final Document allModels;
    Document model;
    final Normalizer normalizer;
    final Internationalizer internationalizer;
    final Set<String> sortedModels = new HashSet<String>();
    final Map<String, Document> models = new HashMap<String, Document>();

    public ModelProcessor(@NotNull FileLocations where, @NotNull String basePackage, @NotNull String artifactId, @NotNull String defaultLanguage) throws ModelGenerationException {
        this.where = where;
        this.basePackage = basePackage;
        this.defaultLanguage = defaultLanguage;
        this.artifactId = artifactId;
        this.allModels = XMLUtil.newDocument(basePackage, "all");
        this.finder = new ModelFileFinder(where, artifactId);
        this.templateTemplate = new GeneratorTemplate(where.templatesDir);
        this.normalizer = new Normalizer(basePackage);
        this.internationalizer = new Internationalizer(defaultLanguage);
        this.templateProcessor = new TemplateProcessor(where);
    }

    public void generate() throws ModelGenerationException {
        this.validateAndLoadModels();
        this.sortedModels();
        int sequence = 0;
        for (Map.Entry<String, Document> entry : this.models.entrySet()) {
            this.model = entry.getValue();
            this.normalizer.normalize(this.model, entry.getKey(), this.sortedModels, sequence++);
            this.internationalizer.internationalize(this.model, entry.getKey());
            this.allModels.getFirstChild().appendChild(this.allModels.importNode(this.model.getFirstChild(), true));
        }
        this.model = null;
        this.upgradeFiles();
        this.loadApplication();
        this.loadLanguages();
        this.loadSchemas();
        this.globalEnums();
        this.dumpModelToLocalFile();
        this.dumpAllModelsToLocalFile();
        for (Map.Entry<String, Document> entry : this.models.entrySet()) {
            this.model = entry.getValue();
            for (Template tpl : this.templateTemplate.byInput(Template.Input.Model)) {
                if (tpl.ignoreProjects == null || !tpl.ignoreProjects.contains(this.artifactId)) {
                    this.templateProcessor.process(tpl, this.model, this.basePackage + "." + tpl.packageSuffix, tpl.getDestinationFileName(entry.getKey(), null, null), null, this.artifactId);
                    continue;
                }
                System.out.println("Ignoring " + tpl.name + " for " + this.artifactId);
            }
            this.model = null;
        }
        for (Template template : this.templateTemplate.byInput(Template.Input.AllModels)) {
            if (template.ignoreProjects == null || !template.ignoreProjects.contains(this.artifactId)) {
                this.templateProcessor.process(template, this.allModels, this.basePackage + "." + template.packageSuffix, template.getDestinationFileName(null, null, null), null, this.artifactId);
                continue;
            }
            System.out.println("Ignoring " + template.name + " for " + this.artifactId);
        }
        for (Map.Entry entry : XMLUtil.enumerations(this.allModels, this.basePackage).entrySet()) {
            System.out.println("Processing enum " + (String)entry.getKey());
            for (Template tpl : this.templateTemplate.byInput(Template.Input.Enum)) {
                if (tpl.ignoreProjects == null || !tpl.ignoreProjects.contains(this.artifactId)) {
                    this.templateProcessor.process(tpl, (Document)entry.getValue(), this.basePackage + "." + tpl.packageSuffix, tpl.getDestinationFileName(null, null, (String)entry.getKey()), null, this.artifactId);
                    continue;
                }
                System.out.println("Ignoring " + tpl.name + " for " + this.artifactId);
            }
        }
        for (String string : XMLUtil.definedLanguages(this.allModels)) {
            HashMap<String, String> langParam = new HashMap<String, String>();
            langParam.put("language", string);
            System.out.println("Processing language " + string);
            for (Template tpl : this.templateTemplate.byInput(Template.Input.Language)) {
                if (tpl.ignoreProjects == null || !tpl.ignoreProjects.contains(this.artifactId)) {
                    this.templateProcessor.process(tpl, this.allModels, this.basePackage + "." + tpl.packageSuffix, tpl.getDestinationFileName(null, string, null), langParam, this.artifactId);
                    continue;
                }
                System.out.println("Ignoring " + tpl.name + " for " + this.artifactId);
            }
        }
    }

    private void loadApplication() throws ModelGenerationException {
        File application = new File(this.where.applicationFile);
        if (application.exists()) {
            Document doc;
            try {
                doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(application);
            }
            catch (Exception e) {
                throw new ModelGenerationException("The application file is not parseable, probably not valid XML.", e);
            }
            this.allModels.getFirstChild().appendChild(this.allModels.importNode(doc.getFirstChild(), true));
        }
    }

    @NotNull
    private void loadModel(@NotNull String modelFile) throws ModelGenerationException {
        try {
            this.model = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new File(this.where.modelDir, modelFile));
        }
        catch (Exception e) {
            throw new ModelGenerationException("The model " + modelFile + " is not parseable, probably not valid XML.", e);
        }
        this.loadIncludes();
    }

    void validateAndLoadModels() throws ModelGenerationException {
        File applicationFile = new File(this.where.applicationFile);
        if (applicationFile.exists() && this.schemaValidation(APPLICATION_SCHEMA, applicationFile)) {
            throw new ModelGenerationException("Model file " + applicationFile + " failed the schema validation, i will stop now." + ModelGenerationException.printModel(this.where, applicationFile.getName()));
        }
        for (String modelFile : this.finder.findModelFiles()) {
            if (this.schemaValidation(MODEL_SCHEMA, new File(this.where.modelDir, modelFile))) {
                throw new ModelGenerationException("Model file " + modelFile + " failed the schema validation, i will stop now." + ModelGenerationException.printModel(this.where, modelFile));
            }
            this.loadModel(modelFile);
            this.models.put(modelFile.replace(".xml", ""), this.model);
        }
        System.out.println("All model files were checked as valid against model.xsd");
        for (String includeFile : this.finder.findIncludeFiles()) {
            if (!this.schemaValidation(INCLUDE_SCHEMA, new File(this.where.includeDir, includeFile))) continue;
            throw new ModelGenerationException("Include file " + includeFile + " failed the schema validation, i will stop now." + ModelGenerationException.printInclude(this.where, includeFile));
        }
        if (!this.finder.findIncludeFiles().isEmpty()) {
            System.out.println("All include files were checked as valid against include.xsd");
        }
    }

    public boolean schemaValidation(@NotNull String schema, @NotNull File testFile) throws ModelGenerationException {
        SchemaValidator validator;
        DefaultErrorHandler errorHandler = new DefaultErrorHandler();
        try {
            if (schema.equalsIgnoreCase(INCLUDE_SCHEMA)) {
                String include = IOUtils.toString((InputStream)ModelProcessor.class.getResourceAsStream(INCLUDE_SCHEMA));
                String model = IOUtils.toString((InputStream)ModelProcessor.class.getResourceAsStream(MODEL_SCHEMA));
                InputStream includeStream = IOUtils.toInputStream((String)include.replace("<xs:include schemaLocation=\"model.xsd\" />", model.substring(model.indexOf("<xs:complexType name=\"attributesType\">"), model.lastIndexOf("</xs:schema>"))));
                validator = new SchemaValidator(includeStream);
            } else {
                validator = new SchemaValidator(ModelProcessor.class.getResourceAsStream(MODEL_SCHEMA));
            }
        }
        catch (SAXException e) {
            throw new ModelGenerationException("Failed to prepare validating file " + testFile.getAbsolutePath(), e);
        }
        catch (IOException e) {
            throw new ModelGenerationException("Failed to prepare validating file " + testFile.getAbsolutePath(), e);
        }
        try {
            validator.validate(testFile, (ErrorHandler)errorHandler);
        }
        catch (SAXException e) {
            throw new ModelGenerationException("Model file " + testFile.getName() + " did not test nice. " + ModelGenerationException.printModel(this.where, testFile.getName()), e);
        }
        catch (IOException ex) {
            Logger.getLogger(ModelProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (errorHandler.getErrors().hasContent()) {
            System.out.println("XML file:" + testFile.getAbsolutePath() + " failed to do checking according to XSD file:");
            Iterator ei = errorHandler.getErrors().elementIterator();
            while (ei.hasNext()) {
                org.dom4j.Element el = (org.dom4j.Element)ei.next();
                System.out.println(el.getStringValue());
            }
            return true;
        }
        return false;
    }

    void loadIncludes() throws ModelGenerationException {
        NodeList includes;
        try {
            includes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//include", this.model, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ModelGenerationException("Failed in searching include", e);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        for (int i = 0; i < includes.getLength(); ++i) {
            Document includeDoc;
            Node includeTag = includes.item(i);
            String includeFileName = this.where.includeDir + File.separator + includeTag.getAttributes().getNamedItem("name").getNodeValue() + ".xml";
            System.out.println("Including " + includeFileName);
            try {
                includeDoc = factory.newDocumentBuilder().parse(new File(includeFileName));
            }
            catch (SAXException e) {
                throw new ModelGenerationException("I failed to create a DOM of this include " + includeFileName, e);
            }
            catch (IOException e) {
                throw new ModelGenerationException("I failed to find this include file: " + includeFileName, e);
            }
            catch (ParserConfigurationException e) {
                throw new ModelGenerationException("I failed to create a DOM of this include " + includeFileName, e);
            }
            for (int j = 0; j < includeDoc.getDocumentElement().getChildNodes().getLength(); ++j) {
                Node insert = includeDoc.getFirstChild().getChildNodes().item(j);
                if (insert.getNodeType() != 1) continue;
                for (int h = 0; h < includeTag.getChildNodes().getLength(); ++h) {
                    Node attributeNode = includeTag.getChildNodes().item(h);
                    if ("attribute".equals(attributeNode.getNodeName())) {
                        XMLUtil.attribute(insert, attributeNode.getAttributes().getNamedItem("name").getNodeValue(), attributeNode.getAttributes().getNamedItem("value").getNodeValue());
                        continue;
                    }
                    if (!"caption".equals(attributeNode.getNodeName())) continue;
                    insert.appendChild(includeDoc.importNode(attributeNode, true));
                }
                this.model.getElementsByTagName("attributes").item(0).insertBefore(this.model.importNode(insert, true), includes.item(i));
                this.model.normalizeDocument();
            }
            this.model.getElementsByTagName("attributes").item(0).removeChild(includes.item(i));
        }
        this.model.normalize();
    }

    void loadLanguages() throws ModelGenerationException {
        this.allModels.getFirstChild().appendChild(this.allModels.importNode(XMLUtil.newDocument(null, "languages").getFirstChild(), true));
        Node upgradeDoc = this.allModels.getElementsByTagName("languages").item(0);
        XMLUtil.attribute(upgradeDoc, "defaultLanguage", this.defaultLanguage);
        for (String language : XMLUtil.definedLanguages(this.allModels)) {
            Element tagNode = upgradeDoc.getOwnerDocument().createElement("language");
            tagNode.setTextContent(language);
            upgradeDoc.appendChild(tagNode);
        }
        this.allModels.normalize();
    }

    void loadSchemas() throws ModelGenerationException {
        NodeList schemaNodes;
        this.allModels.getFirstChild().appendChild(this.allModels.importNode(XMLUtil.newDocument(null, "schemas").getFirstChild(), true));
        HashSet<String> schemas = new HashSet<String>();
        Node upgradeDoc = this.allModels.getElementsByTagName("languages").item(0);
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            schemaNodes = (NodeList)xpath.evaluate("//schema", this.allModels, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ModelGenerationException("Filter on schema failed", e);
        }
        if (schemaNodes != null) {
            for (int i = 0; i < schemaNodes.getLength(); ++i) {
                schemas.add(schemaNodes.item(i).getNodeValue());
            }
        }
        for (String schema : schemas) {
            Element tagNode = upgradeDoc.getOwnerDocument().createElement("schema");
            tagNode.setTextContent(schema);
            upgradeDoc.appendChild(tagNode);
        }
        this.allModels.normalize();
    }

    void sortedModels() throws ModelGenerationException {
        for (Map.Entry<String, Document> entry : this.models.entrySet()) {
            this.model = entry.getValue();
            try {
                if (!XMLUtil.isSortable(this.model)) continue;
                this.sortedModels.add(entry.getKey());
            }
            catch (XPathExpressionException e) {
                throw new ModelGenerationException("Can't define sorted for " + entry.getKey(), e);
            }
        }
        this.model = null;
    }

    private void globalEnums() throws ModelGenerationException {
        NodeList globals;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            globals = (NodeList)xpath.evaluate("//attributes/enum[@scope='global']", this.allModels, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ModelGenerationException("It seems to be a problem to create the globals list", e);
        }
        HashSet<String> unique = new HashSet<String>();
        Document globalDoc = XMLUtil.newDocument(null, "globals");
        for (int i = 0; i < globals.getLength(); ++i) {
            if (!unique.add(globals.item(i).getAttributes().getNamedItem("class").getNodeValue())) continue;
            globalDoc.getFirstChild().appendChild(globalDoc.importNode(globals.item(i), true));
        }
        this.allModels.getFirstChild().appendChild(this.allModels.importNode(globalDoc.getFirstChild(), true));
    }

    private void upgradeFiles() throws ModelGenerationException {
        Document upgradeDoc = XMLUtil.newDocument(null, "upgrades");
        for (String file : this.finder.upgradeFiles()) {
            Element tagNode = upgradeDoc.createElement("upgrade");
            tagNode.setTextContent(file);
            upgradeDoc.getFirstChild().appendChild(tagNode);
        }
        this.allModels.getFirstChild().appendChild(this.allModels.importNode(upgradeDoc.getFirstChild(), true));
    }

    @NotNull
    public String dump() {
        String retVal = "Dumping model contents.\r\n";
        if (this.model != null) {
            retVal = retVal + "Model:\r\n" + XMLUtil.asString(this.model) + "\r\n";
        }
        retVal = retVal + "Model:\r\n" + XMLUtil.asString(this.allModels) + "\r\n";
        return retVal;
    }

    public void dumpModelToLocalFile() throws ModelGenerationException {
        for (Map.Entry<String, Document> entry : this.models.entrySet()) {
            try {
                TransformerFactory tFactory = TransformerFactory.newInstance();
                Transformer transformer = tFactory.newTransformer();
                transformer.setOutputProperty("encoding", "utf-8");
                DOMSource source = new DOMSource(entry.getValue());
                File modelFile = this.finder.normalizedModelFile(entry.getKey());
                StreamResult result = new StreamResult(modelFile);
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new ModelGenerationException("Can't dumping model for " + entry.getKey(), e);
            }
        }
    }

    public void dumpAllModelsToLocalFile() throws ModelGenerationException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("encoding", "utf-8");
            DOMSource source = new DOMSource(this.allModels);
            File allModelFile = this.finder.allModelFiles();
            StreamResult result = new StreamResult(allModelFile);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new ModelGenerationException("Can't dump allmodels", e);
        }
    }
}

