/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import java.util.ArrayList;
import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.modeshape.common.text.Inflector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import redora.generator.ModelGenerationException;
import redora.generator.XMLUtil;
import redora.util.BusinessRuleMessageUtils;
import redora.util.DocPrint;

public class Normalizer {
    String modelName;
    final String packageName;
    Document doc;

    public Normalizer(@NotNull String packageName) {
        this.packageName = packageName;
    }

    public void normalize(@NotNull Document doc, @NotNull String modelName, @NotNull Set<String> sortedModels, int sequence) throws ModelGenerationException {
        this.doc = doc;
        this.modelName = modelName;
        XMLUtil.attribute(doc.getFirstChild(), "name", modelName);
        XMLUtil.addChildElement(doc, "plural", new Inflector().pluralize((Object)modelName));
        XMLUtil.addChildElement(doc, "onlyServerSide", "false");
        XMLUtil.attribute(doc.getFirstChild(), "package", this.packageName);
        XMLUtil.attribute(doc.getFirstChild(), "sequence", String.valueOf(sequence));
        this.normalizeObject(sortedModels);
        this.normalizeAttributes(sortedModels);
        this.normalizeQueries();
        this.addScope();
        this.addLazy();
        doc.normalize();
    }

    void normalizeObject(@NotNull Set<String> sortedModels) throws ModelGenerationException {
        XMLUtil.addChildElement(this.doc, "sorted", "false");
        XMLUtil.addChildElement(this.doc, "trashcan", "false");
        this.extractMessageParameters("/object/businessRules/businessRule/message");
        this.extractMessageParameters("/object/i18n/messageBundle/message");
        if (sortedModels.contains(this.modelName)) {
            Node first;
            Element sortNode = this.doc.createElement("integer");
            XMLUtil.attribute(sortNode, "name", "sortOrder");
            XMLUtil.attribute(sortNode, "sort", "asc");
            try {
                NodeList attributes = XMLUtil.attributes(this.doc, null);
                first = attributes.item(0);
            }
            catch (XPathExpressionException e) {
                throw new ModelGenerationException("Can't set the object/attributes/sorted node", e);
            }
            this.doc.getElementsByTagName("attributes").item(0).insertBefore(sortNode, first);
        }
        Node idFinder = XMLUtil.addFinder(this.doc, this.doc.getFirstChild(), "findById", "false");
        XMLUtil.attribute(idFinder, "listName", "FIND_BY_ID_LIST");
        XMLUtil.attribute(idFinder, "tableName", "FIND_BY_ID_TABLE");
        Node allFinder = XMLUtil.addFinder(this.doc, this.doc.getFirstChild(), "findAll", "false");
        XMLUtil.attribute(allFinder, "listName", "FIND_ALL_LIST");
        XMLUtil.attribute(allFinder, "tableName", "FIND_ALL_TABLE");
    }

    private void extractMessageParameters(@NotNull String query) throws ModelGenerationException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList messages = (NodeList)xpath.evaluate(query, this.doc, XPathConstants.NODESET);
            for (int i = 0; i < messages.getLength(); ++i) {
                Node message = messages.item(i);
                if (!message.getNodeName().equals("message") || message.getAttributes().getNamedItem("language") == null || !message.getAttributes().getNamedItem("language").getNodeValue().equals("en")) continue;
                String defMesg = message.getTextContent();
                ArrayList params = new ArrayList();
                BusinessRuleMessageUtils.getBusinessRuleMessageParams((String)defMesg, params);
                if (params.size() <= 0) continue;
                Element paramsNode = this.doc.createElement("params");
                message.getParentNode().appendChild(paramsNode);
                for (String param : params) {
                    Element paramNode = this.doc.createElement("param");
                    paramNode.setTextContent(param);
                    paramsNode.appendChild(paramNode);
                }
            }
        }
        catch (XPathExpressionException e) {
            DocPrint.print((Node)this.doc);
            throw new ModelGenerationException("Failed to parse this query " + query, e);
        }
    }

    void normalizeAttributes(@NotNull Set<String> sortedModels) throws ModelGenerationException {
        NodeList attributes;
        try {
            attributes = XMLUtil.attributes(this.doc, null);
        }
        catch (XPathExpressionException e) {
            DocPrint.print((Node)this.doc);
            throw new ModelGenerationException("Failed to parse the attributes in this model", e);
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeName().equals("datetime")) {
                XMLUtil.attribute(attribute, "className", "Date");
            } else if (attribute.getNodeName().equals("enum")) {
                XMLUtil.attribute(attribute, "className", attribute.getAttributes().getNamedItem("class").getNodeValue());
                if (attribute.getAttributes().getNamedItem("name") != null) {
                    XMLUtil.attribute(attribute, "fieldName", attribute.getAttributes().getNamedItem("name").getNodeValue());
                } else {
                    XMLUtil.attribute(attribute, "fieldName", StringUtils.uncapitalize((String)attribute.getAttributes().getNamedItem("class").getNodeValue()));
                }
                XMLUtil.attribute(attribute, "scope", "local");
                Node finder = XMLUtil.addFinder(this.doc, attribute, "false", false);
                XMLUtil.attribute(finder, "name", "findBy" + StringUtils.capitalize((String)attribute.getAttributes().getNamedItem("fieldName").getNodeValue()));
                String staticName = "FIND_BY_";
                for (String part : StringUtils.splitByCharacterTypeCamelCase((String)attribute.getAttributes().getNamedItem("fieldName").getNodeValue())) {
                    staticName = staticName + "_" + part.toUpperCase();
                }
                XMLUtil.attribute(finder, "listName", staticName + "_LIST");
                XMLUtil.attribute(finder, "tableName", staticName + "_TABLE");
            } else if (attribute.getNodeName().equals("html")) {
                XMLUtil.attribute(attribute, "className", "String");
                XMLUtil.attribute(attribute, "lazy", "true");
            } else if (attribute.getNodeName().equals("object")) {
                String className = attribute.getAttributes().getNamedItem("class").getNodeValue();
                String fieldName = StringUtils.uncapitalize((String)className);
                if (attribute.getAttributes().getNamedItem("name") != null) {
                    fieldName = attribute.getAttributes().getNamedItem("name").getNodeValue();
                }
                XMLUtil.attribute(attribute, "className", className);
                XMLUtil.attribute(attribute, "fieldName", fieldName);
                XMLUtil.attribute(attribute, "lazy", "true");
                XMLUtil.attribute(attribute, "list", "false");
                XMLUtil.attribute(attribute, "notnull", "false");
                XMLUtil.attribute(attribute, "cascade", "true");
                if (className.equals(this.modelName)) {
                    XMLUtil.attribute(attribute, "pigsear", "true");
                } else {
                    XMLUtil.attribute(attribute, "pigsear", "false");
                }
                if (this.doc.getElementsByTagName(fieldName + "Id").getLength() == 0) {
                    Element longNode = this.doc.createElement("long");
                    XMLUtil.attribute(longNode, "name", fieldName + "Id");
                    XMLUtil.attribute(longNode, "lazy", "false");
                    XMLUtil.attribute(longNode, "className", "Long");
                    XMLUtil.attribute(longNode, "fieldName", fieldName + "Id");
                    XMLUtil.attribute(longNode, "notnull", attribute.getAttributes().getNamedItem("notnull").getNodeValue());
                    XMLUtil.attribute(longNode, "list", attribute.getAttributes().getNamedItem("list").getNodeValue());
                    XMLUtil.attribute(longNode, "parentClass", className);
                    if (className.equals(this.modelName)) {
                        XMLUtil.attribute(longNode, "pigsear", "true");
                    } else {
                        XMLUtil.attribute(longNode, "pigsear", "false");
                    }
                    this.doc.getElementsByTagName("attributes").item(0).insertBefore(longNode, attribute);
                }
                Node finder = XMLUtil.addFinder(this.doc, attribute, "false", false);
                XMLUtil.attribute(finder, "name", "findBy" + StringUtils.capitalize((String)fieldName) + "Id");
                String staticName = "FIND_BY";
                for (String part : StringUtils.splitByCharacterTypeCamelCase((String)(fieldName + "Id"))) {
                    staticName = staticName + "_" + part.toUpperCase();
                }
                XMLUtil.attribute(finder, "listName", staticName + "_LIST");
                XMLUtil.attribute(finder, "tableName", staticName + "_TABLE");
            } else if (attribute.getNodeName().equals("set")) {
                String relatedObjectName = attribute.getAttributes().getNamedItem("class").getNodeValue();
                XMLUtil.attribute(attribute, "multiplicity", "1-to-n");
                if (relatedObjectName.equals(this.modelName)) {
                    XMLUtil.attribute(attribute, "pigsear", "true");
                } else {
                    XMLUtil.attribute(attribute, "pigsear", "false");
                }
                String multiplicity = attribute.getAttributes().getNamedItem("multiplicity").getNodeValue();
                if ("1-to-n".equals(multiplicity)) {
                    XMLUtil.attribute(attribute, "cascade", "true");
                    if (sortedModels.contains(relatedObjectName)) {
                        XMLUtil.attribute(attribute, "sorted", "true");
                        XMLUtil.attribute(attribute, "className", "PersistableSortedList<" + relatedObjectName + ">");
                    } else {
                        XMLUtil.attribute(attribute, "className", "PersistableList<" + relatedObjectName + ">");
                    }
                } else {
                    String position;
                    XMLUtil.attribute(attribute, "cascade", "false");
                    if (this.modelName.compareTo(relatedObjectName) < 0) {
                        XMLUtil.attribute(attribute, "relationTableName", this.modelName + "_" + relatedObjectName);
                        position = "left";
                    } else {
                        XMLUtil.attribute(attribute, "relationTableName", relatedObjectName + "_" + this.modelName);
                        position = "right";
                    }
                    XMLUtil.attribute(attribute, "position", position);
                    if (sortedModels.contains(relatedObjectName) && sortedModels.contains(this.modelName)) {
                        XMLUtil.attribute(attribute, "sorted", "both");
                    } else if (sortedModels.contains(this.modelName)) {
                        XMLUtil.attribute(attribute, "sorted", "me");
                    } else if (sortedModels.contains(relatedObjectName)) {
                        XMLUtil.attribute(attribute, "sorted", "them");
                    }
                    if (sortedModels.contains(relatedObjectName)) {
                        XMLUtil.attribute(attribute, "className", "PersistableSortedList<" + relatedObjectName + ">");
                    } else {
                        XMLUtil.attribute(attribute, "className", "PersistableList<" + relatedObjectName + ">");
                    }
                }
                XMLUtil.attribute(attribute, "sorted", "false");
                XMLUtil.attribute(attribute, "myName", StringUtils.uncapitalize((String)this.modelName));
                XMLUtil.attribute(attribute, "theirName", StringUtils.uncapitalize((String)relatedObjectName));
                XMLUtil.attribute(attribute, "plural", new Inflector().pluralize((Object)attribute.getAttributes().getNamedItem("theirName").getNodeValue()));
                XMLUtil.attribute(attribute, "fieldName", attribute.getAttributes().getNamedItem("plural").getNodeValue());
                XMLUtil.attribute(attribute, "lazy", "true");
                if ("n-to-m".equals(multiplicity)) {
                    String theirName = StringUtils.capitalize((String)attribute.getAttributes().getNamedItem("theirName").getNodeValue());
                    String myName = StringUtils.capitalize((String)attribute.getAttributes().getNamedItem("myName").getNodeValue());
                    if (relatedObjectName.equals(this.modelName)) {
                        Node finder = XMLUtil.addFinder(this.doc, attribute, "false", false);
                        XMLUtil.attribute(finder, "name", "findBy" + theirName + "Id");
                        String staticName = "FIND_BY";
                        for (String part : StringUtils.splitByCharacterTypeCamelCase((String)(myName + "By" + theirName + "Id"))) {
                            staticName = staticName + "_" + part.toUpperCase();
                        }
                        XMLUtil.attribute(finder, "listName", staticName + "_LIST");
                        XMLUtil.attribute(finder, "tableName", staticName + "_TABLE");
                        finder = XMLUtil.addFinder(this.doc, attribute, "false", true);
                        XMLUtil.attribute(finder, "name", "findBy" + myName + "Id");
                        staticName = "FIND_BY";
                        for (String part : StringUtils.splitByCharacterTypeCamelCase((String)(myName + "By" + myName + "Id"))) {
                            staticName = staticName + "_" + part.toUpperCase();
                        }
                        XMLUtil.attribute(finder, "listName", staticName + "_LIST");
                        XMLUtil.attribute(finder, "tableName", staticName + "_TABLE");
                    } else {
                        Node finder = XMLUtil.addFinder(this.doc, attribute, "false", false);
                        XMLUtil.attribute(finder, "name", "findBy" + theirName + "Id");
                        String staticName = "FIND_BY";
                        for (String part : StringUtils.splitByCharacterTypeCamelCase((String)(myName + "By" + theirName + "Id"))) {
                            staticName = staticName + "_" + part.toUpperCase();
                        }
                        XMLUtil.attribute(finder, "listName", staticName + "_LIST");
                        XMLUtil.attribute(finder, "tableName", staticName + "_TABLE");
                    }
                }
            } else if (attribute.getNodeName().equals("string") && Integer.valueOf(attribute.getAttributes().getNamedItem("maxlength").getNodeValue()) >= 65000) {
                XMLUtil.attribute(attribute, "lazy", "true");
            }
            if (attribute.getAttributes().getNamedItem("name") != null) {
                XMLUtil.attribute(attribute, "fieldName", attribute.getAttributes().getNamedItem("name").getNodeValue());
            }
            XMLUtil.attribute(attribute, "className", StringUtils.capitalize((String)attribute.getNodeName()));
            XMLUtil.attribute(attribute, "list", "false");
            XMLUtil.attribute(attribute, "notnull", "false");
            XMLUtil.attribute(attribute, "lazy", "false");
            String camelCase = "";
            for (String part : StringUtils.splitByCharacterTypeCamelCase((String)attribute.getAttributes().getNamedItem("fieldName").getNodeValue())) {
                camelCase = camelCase + (camelCase.length() == 0 ? "" : "_") + part.toUpperCase();
            }
            XMLUtil.attribute(attribute, "camelCase", camelCase);
            Node finder = XMLUtil.finder(attribute, null);
            if (finder == null) continue;
            XMLUtil.attribute(finder, "name", "findBy" + StringUtils.capitalize((String)attribute.getAttributes().getNamedItem("fieldName").getNodeValue()));
            XMLUtil.attribute(finder, "json", "false");
            String staticName = "FIND_BY";
            for (String part : StringUtils.splitByCharacterTypeCamelCase((String)(attribute.getAttributes().getNamedItem("fieldName").getNodeValue() + "Id"))) {
                staticName = staticName + "_" + part.toUpperCase();
            }
            XMLUtil.attribute(finder, "listName", staticName + "_LIST");
            XMLUtil.attribute(finder, "tableName", staticName + "_TABLE");
        }
    }

    void normalizeQueries() throws ModelGenerationException {
        NodeList queries;
        try {
            queries = XMLUtil.queries(this.doc);
        }
        catch (XPathExpressionException e) {
            DocPrint.print((Node)this.doc);
            throw new ModelGenerationException("Could not get the queries", e);
        }
        block2: for (int i = 0; i < queries.getLength(); ++i) {
            Node query = queries.item(i);
            String staticName = "QUERY_BY";
            for (String part : StringUtils.splitByCharacterTypeCamelCase((String)query.getAttributes().getNamedItem("name").getNodeValue())) {
                staticName = staticName + "_" + part.toUpperCase();
            }
            Node finder = XMLUtil.finder(query, null);
            if (finder != null) {
                XMLUtil.attribute(finder, "name", "QueryBy" + StringUtils.capitalize((String)query.getAttributes().getNamedItem("name").getNodeValue()));
                XMLUtil.attribute(finder, "json", "false");
                XMLUtil.attribute(finder, "listName", staticName + "_LIST");
                XMLUtil.attribute(finder, "tableName", staticName + "_TABLE");
            } else {
                XMLUtil.attribute(query, "sqlName", staticName.toString());
            }
            for (int j = 0; j < query.getChildNodes().getLength(); ++j) {
                Node defaultNode = query.getChildNodes().item(j);
                if (!"default".equals(defaultNode.getNodeName())) continue;
                Element listNode = this.doc.createElement("list");
                listNode.setTextContent(defaultNode.getTextContent());
                query.appendChild(listNode);
                Element tableNode = this.doc.createElement("table");
                tableNode.setTextContent(defaultNode.getTextContent());
                query.appendChild(tableNode);
                continue block2;
            }
        }
    }

    public void addScope() throws ModelGenerationException {
        XMLUtil.addChildElement(this.doc, "listScope", null);
        XMLUtil.addChildElement(this.doc, "tableScope", null);
        XMLUtil.addChildElement(this.doc, "lazyScope", null);
        XMLUtil.addChildElement(this.doc, "formScope", null);
        try {
            Node insert;
            int i;
            NodeList attributes = XMLUtil.attributes(this.doc, "*[@list='true']");
            boolean empty = true;
            for (i = 0; i < attributes.getLength(); ++i) {
                insert = attributes.item(i);
                if (insert.getNodeName().equals("html") || insert.getNodeName().equals("xml")) {
                    System.out.println("html and xml attribute types are not available for the Scope 'list'");
                    continue;
                }
                if (insert.getNodeName().equals("object")) continue;
                if (insert.getNodeName().equals("string") && Integer.parseInt(insert.getAttributes().getNamedItem("maxlength").getNodeValue()) > 255) {
                    System.out.println("Larger string attributes (maxlength > 255) are not available for the Scope 'list");
                    continue;
                }
                this.doc.getElementsByTagName("listScope").item(0).appendChild(this.doc.importNode(insert, true));
                empty = false;
            }
            if (empty) {
                attributes = XMLUtil.attributes(this.doc, "*[@notnull='true']");
                for (i = 0; i < attributes.getLength(); ++i) {
                    insert = attributes.item(i);
                    if (insert.getNodeName().equals("html") || insert.getNodeName().equals("xml")) {
                        System.out.println("html and xml attribute types are not available for the Scope 'list'");
                        continue;
                    }
                    if (insert.getNodeName().equals("string") && Integer.parseInt(insert.getAttributes().getNamedItem("maxlength").getNodeValue()) > 100) {
                        System.out.println("Larger string attibutes (maxlength > 100) are not available for the Scope 'list");
                        continue;
                    }
                    this.doc.getElementsByTagName("listScope").item(0).appendChild(this.doc.importNode(insert, true));
                }
            }
            attributes = XMLUtil.attributes(this.doc, null);
            for (i = 0; i < attributes.getLength(); ++i) {
                insert = attributes.item(i);
                if (insert.getNodeName().equals("set")) continue;
                if ("true".equals(insert.getAttributes().getNamedItem("lazy").getNodeValue()) && !insert.getNodeName().equals("object")) {
                    this.doc.getElementsByTagName("lazyScope").item(0).appendChild(this.doc.importNode(insert, true));
                    this.doc.getElementsByTagName("formScope").item(0).appendChild(this.doc.importNode(insert, true));
                    continue;
                }
                this.doc.getElementsByTagName("tableScope").item(0).appendChild(this.doc.importNode(insert, true));
                this.doc.getElementsByTagName("formScope").item(0).appendChild(this.doc.importNode(insert, true));
            }
            if (!this.doc.getElementsByTagName("lazyScope").item(0).hasChildNodes()) {
                System.out.println("There is no lazy field, remove the lazyScope node");
                this.doc.getFirstChild().removeChild(this.doc.getElementsByTagName("lazyScope").item(0));
            }
            if (!this.doc.getElementsByTagName("listScope").item(0).hasChildNodes()) {
                System.out.println("There is no list field for dropdown list, i removed the listScope node");
                this.doc.getFirstChild().removeChild(this.doc.getElementsByTagName("listScope").item(0));
            }
        }
        catch (XPathExpressionException e) {
            DocPrint.print((Node)this.doc);
            throw new ModelGenerationException("Failed to parse the attributes in this model", e);
        }
        this.doc.normalize();
    }

    private void addLazy() throws ModelGenerationException {
        try {
            int lazy = XMLUtil.attributes(this.doc, "*[@lazy='true']").getLength() - XMLUtil.attributes(this.doc, "set[@lazy='true']").getLength();
            XMLUtil.addChildElement(this.doc, "hasLazy", lazy > 0 ? "true" : "false");
            System.out.println(this.modelName + " has " + lazy + " lazy attributes");
        }
        catch (XPathExpressionException e) {
            throw new ModelGenerationException("Can't evaluate lazy='true' xpath", e);
        }
    }
}

