/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import java.io.File;
import org.jetbrains.annotations.NotNull;

public class Template {
    public final String name;
    public final Type type;
    public final Destination destination;
    public String packageSuffix;
    public String path;
    public DestinationType destinationType;
    public Input input;
    public String ignoreProjects;
    String destinationFileName;
    String templateFileName;
    final String templatesDir;

    public Template(@NotNull String name, @NotNull Type type, @NotNull Destination destination, @NotNull String templatesDir) {
        this.name = name;
        this.type = type;
        this.destination = destination;
        this.templatesDir = templatesDir;
    }

    public void setPackageSuffix(String packageSuffix) {
        this.packageSuffix = packageSuffix;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setIgnoreProjects(String ignoreProjects) {
        this.ignoreProjects = ignoreProjects;
    }

    public void setDestinationType(DestinationType destinationType) {
        this.destinationType = destinationType;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public String getDestinationFileName(String objectName, String language, String classAttribute) {
        if (this.destinationFileName == null) {
            this.destinationFileName = this.name;
            if (objectName != null) {
                this.destinationFileName = this.destinationFileName.replace("${objectName}", objectName);
            }
            if (language != null) {
                this.destinationFileName = this.destinationFileName.replace("${language}", language);
            }
            if (classAttribute != null) {
                this.destinationFileName = this.destinationFileName.replace("${classAttribute}", classAttribute);
            }
            if (this.destinationType != null) {
                this.destinationFileName = this.destinationFileName + '.' + (Object)((Object)this.destinationType);
            }
        }
        return this.destinationFileName;
    }

    public String getAbsolutePath() {
        return this.templatesDir + File.separatorChar + this.getTemplateFileName();
    }

    @NotNull
    public String getTemplateFileName() {
        if (this.templateFileName == null) {
            this.templateFileName = this.name.replace("${objectName}", "Pojo");
            if (this.type == Type.freemarker) {
                this.templateFileName = this.templateFileName + ".ftl";
            } else if (this.type == Type.xslt) {
                this.templateFileName = this.templateFileName + ".xsl";
            }
        }
        return this.templateFileName;
    }

    public String toString() {
        return this.getTemplateFileName();
    }

    public static enum Input {
        Model,
        AllModels,
        Language,
        Enum;

    }

    public static enum DestinationType {
        css,
        html,
        java,
        properties,
        sql,
        xml;

    }

    public static enum Destination {
        source,
        target,
        redora;

    }

    public static enum Type {
        freemarker,
        xslt,
        copy;

    }
}

