/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.ParseException;
import freemarker.ext.dom.NodeModel;
import freemarker.template.Configuration;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import redora.generator.FileLocations;
import redora.generator.ModelGenerationException;
import redora.generator.Template;
import redora.generator.XMLUtil;

class TemplateProcessor {
    final Configuration freemarkerConf = new Configuration();
    final FileLocations where;

    public TemplateProcessor(@NotNull FileLocations where) throws ModelGenerationException {
        this.where = where;
        this.prepareFreemarker();
    }

    void prepareFreemarker() throws ModelGenerationException {
        File tplDir = new File(this.where.templatesDir);
        try {
            this.freemarkerConf.setTemplateLoader((TemplateLoader)new FileTemplateLoader(tplDir));
        }
        catch (IOException e) {
            throw new ModelGenerationException("Can't load template from " + tplDir.getAbsolutePath() + ", it exists " + tplDir.exists() + ". Make sure you have set the Maven Dependency plugin correctly for Redora Templates", e);
        }
        this.freemarkerConf.setTemplateUpdateDelay(9000);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(@NotNull Template tpl, @NotNull Document model, @NotNull String packageName, @NotNull String outFileName, Map<String, String> xsltParam, String artifact) throws ModelGenerationException {
        FileWriter out;
        String destinationPath;
        System.out.print("Processing with " + tpl);
        switch (tpl.destination) {
            case target: {
                if (tpl.path == null) {
                    destinationPath = this.where.buildDir + File.separatorChar + "generated-sources" + File.separatorChar + "redora-target";
                    break;
                }
                destinationPath = this.where.buildDir;
                break;
            }
            case source: {
                if (tpl.path == null) {
                    destinationPath = this.where.sourceDir;
                    break;
                }
                destinationPath = "src";
                break;
            }
            case redora: {
                destinationPath = this.where.redoraDir;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unused destination " + (Object)((Object)tpl.destination));
            }
        }
        destinationPath = tpl.path == null ? (tpl.destination == Template.Destination.redora ? destinationPath + File.separator + artifact : destinationPath + File.separator + packageName.replace('.', File.separatorChar)) : destinationPath + File.separator + tpl.path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        System.out.println(" to " + destinationPath + "..." + outFileName);
        if (tpl.destination == Template.Destination.source && new File(destinationPath, outFileName).exists()) {
            System.out.println("Stub " + outFileName + " already exists.");
            return;
        }
        new File(destinationPath).mkdirs();
        FileInputStream in = null;
        try {
            out = new FileWriter(new File(destinationPath, outFileName));
        }
        catch (IOException e) {
            throw new ModelGenerationException("Can't find: " + destinationPath + File.separatorChar + outFileName, e);
        }
        switch (tpl.type) {
            case freemarker: {
                HashMap<String, NodeModel> root = new HashMap<String, NodeModel>();
                root.put("doc", NodeModel.wrap((Node)model));
                try {
                    freemarker.template.Template template = this.freemarkerConf.getTemplate(tpl.getTemplateFileName());
                    template.process(root, (Writer)out);
                    break;
                }
                catch (ParseException e) {
                    throw new ModelGenerationException("There is an error in template: " + tpl + ". I found it when generating " + outFileName, (Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new ModelGenerationException("Can't find '" + tpl + "' when generating " + outFileName, e);
                }
                catch (TemplateException e) {
                    throw new ModelGenerationException("There is an error in template: " + tpl + ". I found it when generating " + outFileName, (Exception)((Object)e));
                }
                catch (RuntimeException e) {
                    throw new ModelGenerationException("There is another error while trying this template: " + tpl + ". I found it when generating " + outFileName, e);
                }
            }
            case xslt: {
                try {
                    in = new FileInputStream(tpl.getAbsolutePath());
                    XMLUtil.xsltTransform(model.getFirstChild(), in, out, xsltParam);
                }
                catch (FileNotFoundException e) {
                    try {
                        throw new ModelGenerationException("Can't find " + tpl, e);
                        catch (TransformerException e2) {
                            throw new ModelGenerationException("Sorry, i failed to use this template: " + tpl + ". It broke when generating " + outFileName, e2);
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
                break;
            }
            case copy: {
                try {
                    in = new FileInputStream(tpl.getAbsolutePath());
                    IOUtils.copy((InputStream)in, (Writer)out);
                }
                catch (IOException e) {
                    try {
                        throw new ModelGenerationException("File copy failed " + tpl.getTemplateFileName(), e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
                break;
            }
        }
        IOUtils.closeQuietly((Writer)out);
    }
}

