/*
 * Decompiled with CFR 0.152.
 */
package redora.generator;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import redora.generator.ModelGenerationException;

public class XMLUtil {
    public static void xsltTransform(@NotNull Node xml, @NotNull InputStream xslt, @NotNull Writer out, @NotNull Map<String, String> param) throws TransformerException {
        DOMSource xmlSource = new DOMSource(xml);
        StreamSource xsltSource = new StreamSource(xslt);
        Transformer transformer = TransformerFactory.newInstance().newTransformer(xsltSource);
        for (String key : param.keySet()) {
            transformer.setParameter(key, param.get(key));
        }
        transformer.transform(xmlSource, new StreamResult(out));
    }

    @NotNull
    public static Set<String> definedLanguages(@NotNull Document doc) throws ModelGenerationException {
        NodeList langNodes;
        HashSet<String> retVal = new HashSet<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            langNodes = (NodeList)xpath.evaluate("//@language", doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ModelGenerationException("Filter on language failed", e);
        }
        if (langNodes != null) {
            for (int i = 0; i < langNodes.getLength(); ++i) {
                retVal.add(langNodes.item(i).getNodeValue());
            }
            System.out.println("Found " + retVal.size() + " different languages.");
        } else {
            System.out.println("No captions found, the client will be using the model attribute names for caption.");
        }
        return retVal;
    }

    public static boolean isSortable(@NotNull Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        NodeList sorted = (NodeList)xpath.evaluate("/object/sorted", doc, XPathConstants.NODESET);
        return sorted.getLength() == 1 && sorted.item(0).getFirstChild().getNodeValue().equals("true");
    }

    @NotNull
    public static NodeList attributes(@NotNull Document doc, @Nullable String filter) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        if (filter == null) {
            filter = "*";
        }
        return (NodeList)xpath.evaluate("/object/attributes/" + filter, doc, XPathConstants.NODESET);
    }

    public static NodeList queries(@NotNull Document doc) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (NodeList)xpath.evaluate("/object/queries/query", doc, XPathConstants.NODESET);
    }

    public static void attribute(@NotNull Node node, @NotNull String name, @NotNull String value) {
        if (node.getAttributes().getNamedItem(name) == null) {
            Attr att = node.getOwnerDocument().createAttribute(name);
            att.setNodeValue(value);
            node.getAttributes().setNamedItem(att);
        }
    }

    @Nullable
    public static Node finder(@NotNull Node parent, @Nullable String name) {
        NodeList finders = parent.getChildNodes();
        for (int f = 0; f < finders.getLength(); ++f) {
            if (!"finder".equals(finders.item(f).getNodeName()) || name != null && !name.equals(finders.item(f).getAttributes().getNamedItem("name").getNodeValue())) continue;
            return finders.item(f);
        }
        return null;
    }

    @NotNull
    public static Node addFinder(@NotNull Document doc, @NotNull Node parent, String jsonValue, boolean forceCreate) {
        Node retVal = XMLUtil.finder(parent, null);
        if (forceCreate || retVal == null) {
            retVal = doc.createElement("finder");
            parent.appendChild(retVal);
        }
        XMLUtil.attribute(retVal, "json", jsonValue);
        return retVal;
    }

    @NotNull
    public static Node addFinder(@NotNull Document doc, @NotNull Node parent, String name, String jsonValue) {
        Node retVal = XMLUtil.finder(parent, name);
        if (retVal == null) {
            retVal = doc.createElement("finder");
            parent.appendChild(retVal);
        }
        XMLUtil.attribute(retVal, "json", jsonValue);
        XMLUtil.attribute(retVal, "name", name);
        return retVal;
    }

    public static void addChildElement(@NotNull Document doc, @NotNull String tag, @Nullable String value) {
        if (doc.getElementsByTagName(tag).getLength() == 0) {
            Element tagNode = doc.createElement(tag);
            if (value != null) {
                tagNode.setTextContent(value);
            }
            doc.getFirstChild().appendChild(tagNode);
        }
    }

    @NotNull
    public static Map<String, Document> enumerations(@NotNull Document allModels, @NotNull String basePackage) throws ModelGenerationException {
        NodeList enumNodes;
        HashMap<String, Document> retVal = new HashMap<String, Document>();
        try {
            enumNodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//enum[@scope='global']", allModels, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new ModelGenerationException("The search on global scoped enums failed", e);
        }
        if (enumNodes != null) {
            for (int i = 0; i < enumNodes.getLength(); ++i) {
                String name = enumNodes.item(i).getAttributes().getNamedItem("class").getNodeValue();
                Document enumDoc = XMLUtil.newDocument(basePackage, "enums");
                XMLUtil.addChildElement(enumDoc, "name", name);
                XMLUtil.addChildElement(enumDoc, "fieldName", enumNodes.item(i).getAttributes().getNamedItem("fieldName").getNodeValue());
                enumDoc.getFirstChild().appendChild(enumDoc.importNode(enumNodes.item(i), true));
                retVal.put(name, enumDoc);
            }
        } else {
            System.out.println("No captions found, the client will be using the model attribute names for caption.");
        }
        return retVal;
    }

    @NotNull
    public static Document newDocument(@Nullable String basePackage, @NotNull String root) throws ModelGenerationException {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new ModelGenerationException("Strange, the DOM is not configured right, it worked before! Maybe you have some system properties set that interfere with me", e);
        }
        Element insertNode = doc.createElement(root);
        doc.appendChild(doc.importNode(insertNode, true));
        if (basePackage != null) {
            XMLUtil.addChildElement(doc, "package", basePackage);
        }
        return doc;
    }

    @NotNull
    public static String asString(@NotNull Document doc) {
        DOMSource source = new DOMSource(doc);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(out);
        try {
            TransformerFactory.newInstance().newTransformer().transform(source, result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return ((Object)out).toString();
    }
}

