/*
 * Decompiled with CFR 0.152.
 */
package net.reini.junit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepeatFailedTests {
    private static final Pattern testName = Pattern.compile("\\[junit\\] Running (.+)$");
    private static final Pattern testResult = Pattern.compile("\\[junit\\] Tests run: [0-9]+, Failures: ([0-9]+), Errors: ([0-9]+),");
    private static final Pattern gradleName = Pattern.compile("^\\[.+\\] (.+) > .*FAILED$");

    public static Test suite() {
        Logger logger = Logger.getLogger(RepeatFailedTests.class.getName());
        TestSuite suite = new TestSuite("Failed JUnit tests");
        HashSet<String> processedClasses = new HashSet<String>();
        for (String urlValue : System.getProperty("error.log.url", "").split(",")) {
            if (urlValue.isEmpty()) continue;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(urlValue).openStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    Matcher gradleNameMatcher;
                    Matcher resultMatcher;
                    Matcher nameMatcher = testName.matcher(line);
                    if (nameMatcher.find() && (line = reader.readLine()) != null && (resultMatcher = testResult.matcher(line)).find()) {
                        String failures = resultMatcher.group(1);
                        String errors = resultMatcher.group(2);
                        if (!"0".equals(errors) || !"0".equals(failures)) {
                            RepeatFailedTests.addNonJythonTest(processedClasses, logger, suite, nameMatcher.group(1));
                        }
                    }
                    if (!(gradleNameMatcher = gradleName.matcher(line)).matches()) continue;
                    RepeatFailedTests.addNonJythonTest(processedClasses, logger, suite, gradleNameMatcher.group(1));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e, () -> "Error getting data from URL ".concat(urlValue));
            }
        }
        for (String suiteFileName : System.getProperty("error.suite.files", "").split(",")) {
            try {
                Path suiteFile = Paths.get(suiteFileName, new String[0]);
                if (!Files.isRegularFile(suiteFile, new LinkOption[0])) continue;
                try (InputStream in = Files.newInputStream(suiteFile, new OpenOption[0]);){
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    parser.parse(new InputSource(in), (DefaultHandler)new TestReportFilter(processedClasses, logger, suite));
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.log(Level.SEVERE, e, () -> "Error getting data from suite file ".concat(suiteFileName));
            }
        }
        return suite;
    }

    static void addNonJythonTest(Set<String> processedClasses, Logger logger, TestSuite suite, String className) {
        if (!className.contains("/")) {
            RepeatFailedTests.addTest(processedClasses, logger, suite, className);
        } else {
            logger.warning(() -> "Skipped Jython test ".concat(className));
        }
    }

    static void addTest(Set<String> processedClasses, Logger logger, TestSuite suite, String className) {
        if (processedClasses.add(className)) {
            try {
                Class<?> failedClass = Class.forName(className);
                if (TestCase.class.isAssignableFrom(failedClass)) {
                    Class<?> testCase = failedClass;
                    suite.addTestSuite(testCase);
                } else {
                    suite.addTest((Test)new JUnit4TestAdapter(failedClass));
                }
            }
            catch (Exception e) {
                logger.severe(String.format("Unable to load class %s (%s)", className, e.getClass().getName()));
            }
        }
    }

    static final class TestReportFilter
    extends DefaultHandler {
        private final Set<String> processedClasses;
        private final Logger logger;
        private final TestSuite suite;

        TestReportFilter(Set<String> processedClasses, Logger logger, TestSuite suite) {
            this.processedClasses = processedClasses;
            this.logger = logger;
            this.suite = suite;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("testcase".equals(qName)) {
                RepeatFailedTests.addTest(this.processedClasses, this.logger, this.suite, atts.getValue("classname"));
            }
        }
    }
}

