/*
 * Decompiled with CFR 0.152.
 */
package org.wltea.analyzer.dic;

import java.util.HashMap;
import java.util.Map;
import org.wltea.analyzer.dic.Hit;

public class DictSegment {
    private static final Map<Character, Character> charMap = new HashMap<Character, Character>(16, 0.95f);
    private static final int ARRAY_LENGTH_LIMIT = 3;
    private Character nodeChar;
    private Map<Character, DictSegment> childrenMap;
    private DictSegment[] childrenArray;
    private int storeSize = 0;
    private int nodeState = 0;

    public DictSegment(Character nodeChar) {
        if (nodeChar == null) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e3a\u7a7a\u5f02\u5e38\uff0c\u5b57\u7b26\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.nodeChar = nodeChar;
    }

    public Character getNodeChar() {
        return this.nodeChar;
    }

    public boolean hasNextNode() {
        return this.storeSize > 0;
    }

    public Hit match(char[] charArray) {
        return this.match(charArray, 0, charArray.length, null);
    }

    public Hit match(char[] charArray, int begin, int length) {
        return this.match(charArray, begin, length, null);
    }

    public Hit match(char[] charArray, int begin, int length, Hit searchHit) {
        if (searchHit == null) {
            searchHit = new Hit();
            searchHit.setBegin(begin);
        } else {
            searchHit.setUnmatch();
        }
        searchHit.setEnd(begin);
        Character keyChar = new Character(charArray[begin]);
        DictSegment ds = null;
        DictSegment[] segmentArray = this.childrenArray;
        Map<Character, DictSegment> segmentMap = this.childrenMap;
        if (segmentArray != null) {
            for (DictSegment seg : segmentArray) {
                if (seg == null || !seg.nodeChar.equals(keyChar)) continue;
                ds = seg;
            }
        } else if (segmentMap != null) {
            ds = segmentMap.get(keyChar);
        }
        if (ds != null) {
            if (length > 1) {
                return ds.match(charArray, begin + 1, length - 1, searchHit);
            }
            if (length == 1) {
                if (ds.nodeState == 1) {
                    searchHit.setMatch();
                }
                if (ds.hasNextNode()) {
                    searchHit.setPrefix();
                    searchHit.setMatchedDictSegment(ds);
                }
                return searchHit;
            }
        }
        return searchHit;
    }

    public void fillSegment(char[] charArray) {
        this.fillSegment(charArray, 0, charArray.length);
    }

    public synchronized void fillSegment(char[] charArray, int begin, int length) {
        Character beginChar = new Character(charArray[begin]);
        Character keyChar = charMap.get(beginChar);
        if (keyChar == null) {
            charMap.put(beginChar, beginChar);
            keyChar = beginChar;
        }
        DictSegment ds = this.lookforSegment(keyChar);
        if (length > 1) {
            ds.fillSegment(charArray, begin + 1, length - 1);
        } else if (length == 1) {
            ds.nodeState = 1;
        }
    }

    private DictSegment lookforSegment(Character keyChar) {
        DictSegment ds = null;
        if (this.storeSize <= 3) {
            DictSegment[] segmentArray;
            for (DictSegment segment : segmentArray = this.getChildrenArray()) {
                if (segment == null || !segment.nodeChar.equals(keyChar)) continue;
                ds = segment;
                break;
            }
            if (ds == null) {
                ds = new DictSegment(keyChar);
                if (this.storeSize < 3) {
                    segmentArray[this.storeSize] = ds;
                    ++this.storeSize;
                } else {
                    Map<Character, DictSegment> segmentMap = this.getChildrenMap();
                    this.migrate(segmentArray, segmentMap);
                    segmentMap.put(keyChar, ds);
                    ++this.storeSize;
                    this.childrenArray = null;
                }
            }
        } else {
            Map<Character, DictSegment> segmentMap = this.getChildrenMap();
            ds = segmentMap.get(keyChar);
            if (ds == null) {
                ds = new DictSegment(keyChar);
                segmentMap.put(keyChar, ds);
                ++this.storeSize;
            }
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DictSegment[] getChildrenArray() {
        if (this.childrenArray == null) {
            DictSegment dictSegment = this;
            synchronized (dictSegment) {
                if (this.childrenArray == null) {
                    this.childrenArray = new DictSegment[3];
                }
            }
        }
        return this.childrenArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Character, DictSegment> getChildrenMap() {
        if (this.childrenMap == null) {
            DictSegment dictSegment = this;
            synchronized (dictSegment) {
                if (this.childrenMap == null) {
                    this.childrenMap = new HashMap<Character, DictSegment>(6, 0.8f);
                }
            }
        }
        return this.childrenMap;
    }

    private void migrate(DictSegment[] segmentArray, Map<Character, DictSegment> segmentMap) {
        for (DictSegment segment : segmentArray) {
            if (segment == null) continue;
            segmentMap.put(segment.nodeChar, segment);
        }
    }
}

