/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.ip2location;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class IPTools {
    private static final BigInteger MAX_IPV4_RANGE = new BigInteger("4294967295");
    private static final BigInteger MAX_IPV6_RANGE = new BigInteger("340282366920938463463374607431768211455");
    private static final Pattern PATTERN = Pattern.compile("^(0:){2,}");
    private static final Pattern PATTERN2 = Pattern.compile(":(0:){2,}");
    private static final Pattern PATTERN3 = Pattern.compile("(:0){2,}$");
    private static final Pattern BIN_PATTERN_FULL = Pattern.compile("^([01]{8}){16}$");
    private static final Pattern BIN_PATTERN = Pattern.compile("([01]{8})");
    private static final Pattern PREFIX_PATTERN = Pattern.compile("^[0-9]{1,2}$");
    private static final Pattern PREFIX_PATTERN2 = Pattern.compile("^[0-9]{1,3}$");

    public boolean IsIPv4(String IPAddress) {
        boolean result;
        try {
            InetAddress ia = InetAddress.getByName(IPAddress);
            result = ia instanceof Inet4Address;
        }
        catch (UnknownHostException ex) {
            result = false;
        }
        return result;
    }

    public boolean IsIPv6(String IPAddress) {
        boolean result;
        try {
            InetAddress ia = InetAddress.getByName(IPAddress);
            result = ia instanceof Inet6Address;
        }
        catch (UnknownHostException ex) {
            result = false;
        }
        return result;
    }

    public BigInteger IPv4ToDecimal(String IPAddress) {
        BigInteger result;
        if (!this.IsIPv4(IPAddress)) {
            return null;
        }
        try {
            InetAddress ia = InetAddress.getByName(IPAddress);
            byte[] byteArr = ia.getAddress();
            result = new BigInteger(1, byteArr);
        }
        catch (UnknownHostException ex) {
            result = null;
        }
        return result;
    }

    public BigInteger IPv6ToDecimal(String IPAddress) {
        BigInteger result;
        if (!this.IsIPv6(IPAddress)) {
            return null;
        }
        try {
            InetAddress ia = InetAddress.getByName(IPAddress);
            byte[] byteArr = ia.getAddress();
            result = new BigInteger(1, byteArr);
        }
        catch (UnknownHostException ex) {
            result = null;
        }
        return result;
    }

    public String DecimalToIPv4(BigInteger IPNum) throws UnknownHostException {
        if (IPNum.compareTo(BigInteger.ZERO) < 0 || IPNum.compareTo(MAX_IPV4_RANGE) > 0) {
            return null;
        }
        byte[] byteArr = IPNum.toByteArray();
        if (byteArr.length > 4) {
            byteArr = Arrays.copyOfRange(byteArr, byteArr.length - 4, byteArr.length);
        } else if (byteArr.length < 4) {
            byte[] pad = new byte[4 - byteArr.length];
            byte[] tmp = Arrays.copyOf(pad, pad.length + byteArr.length);
            System.arraycopy(byteArr, 0, tmp, pad.length, byteArr.length);
            byteArr = tmp;
        }
        InetAddress ia = InetAddress.getByAddress(byteArr);
        return ia.getHostAddress();
    }

    public String DecimalToIPv6(BigInteger IPNum) throws UnknownHostException {
        if (IPNum.compareTo(BigInteger.ZERO) < 0 || IPNum.compareTo(MAX_IPV6_RANGE) > 0) {
            return null;
        }
        byte[] byteArr = IPNum.toByteArray();
        if (byteArr.length > 16) {
            byteArr = Arrays.copyOfRange(byteArr, byteArr.length - 16, byteArr.length);
        } else if (byteArr.length < 16) {
            byte[] pad = new byte[16 - byteArr.length];
            byte[] tmp = Arrays.copyOf(pad, pad.length + byteArr.length);
            System.arraycopy(byteArr, 0, tmp, pad.length, byteArr.length);
            byteArr = tmp;
        }
        InetAddress ia = InetAddress.getByAddress(byteArr);
        return ia.getHostAddress();
    }

    public String CompressIPv6(String IPAddress) {
        String result;
        if (!this.IsIPv6(IPAddress)) {
            return null;
        }
        try {
            InetAddress ia = InetAddress.getByName(IPAddress);
            result = ia.getHostAddress();
            if (PATTERN.matcher(result).find()) {
                result = result.replaceFirst(PATTERN.toString(), "::");
            } else if (PATTERN2.matcher(result).find()) {
                result = result.replaceFirst(PATTERN2.toString(), "::");
            } else if (PATTERN3.matcher(result).find()) {
                result = result.replaceFirst(PATTERN3.toString(), "::");
            }
            result = result.replaceFirst("::0$", "::");
        }
        catch (UnknownHostException ex) {
            result = null;
        }
        return result;
    }

    public String ExpandIPv6(String IPAddress) {
        String result;
        if (!this.IsIPv6(IPAddress)) {
            return null;
        }
        try {
            InetAddress ia = InetAddress.getByName(IPAddress);
            byte[] byteArr = ia.getAddress();
            CharSequence[] strArr = new String[byteArr.length];
            for (int x = 0; x < byteArr.length; ++x) {
                strArr[x] = String.format("%02x", byteArr[x]);
            }
            result = String.join((CharSequence)"", strArr);
            result = result.replaceAll("(.{4})", "$1:");
            result = result.substring(0, result.length() - 1);
        }
        catch (UnknownHostException ex) {
            result = null;
        }
        return result;
    }

    public List<String> IPv4ToCIDR(String IPFrom, String IPTo) throws UnknownHostException {
        if (!this.IsIPv4(IPFrom) || !this.IsIPv4(IPTo)) {
            return null;
        }
        long startIP = this.IPv4ToDecimal(IPFrom).longValueExact();
        long endIP = this.IPv4ToDecimal(IPTo).longValueExact();
        ArrayList<String> result = new ArrayList<String>();
        while (endIP >= startIP) {
            long mask;
            long maskBase;
            long maxSize;
            for (maxSize = 32L; maxSize > 0L && (maskBase = startIP & (mask = (long)Math.pow(2.0, 32.0) - (long)Math.pow(2.0, 32L - (maxSize - 1L)))) == startIP; --maxSize) {
            }
            double x = Math.log(endIP - startIP + 1L) / Math.log(2.0);
            long maxDiff = 32L - (long)Math.floor(x);
            if (maxSize < maxDiff) {
                maxSize = maxDiff;
            }
            String ip = this.DecimalToIPv4(new BigInteger(String.valueOf(startIP)));
            result.add(ip + "/" + maxSize);
            startIP = (long)((double)startIP + Math.pow(2.0, 32L - maxSize));
        }
        return result;
    }

    private String IPToBinary(String IPAddress) {
        String result;
        if (!this.IsIPv6(IPAddress)) {
            return null;
        }
        try {
            InetAddress ia = InetAddress.getByName(IPAddress);
            byte[] byteArr = ia.getAddress();
            CharSequence[] strArr = new String[byteArr.length];
            for (int x = 0; x < byteArr.length; ++x) {
                strArr[x] = String.format("%8s", Integer.toBinaryString(byteArr[x] & 0xFF)).replace(' ', '0');
            }
            result = String.join((CharSequence)"", strArr);
        }
        catch (UnknownHostException ex) {
            result = null;
        }
        return result;
    }

    private String BinaryToIP(String Binary) throws UnknownHostException {
        if (!BIN_PATTERN_FULL.matcher(Binary).matches()) {
            return null;
        }
        Matcher m = BIN_PATTERN.matcher(Binary);
        byte[] byteArr = new byte[16];
        int x = 0;
        while (m.find()) {
            String part = m.group(1);
            byteArr[x] = (byte)Integer.parseInt(part, 2);
            ++x;
        }
        InetAddress ia = InetAddress.getByAddress(byteArr);
        return ia.getHostAddress();
    }

    public List<String> IPv6ToCIDR(String IPFrom, String IPTo) throws UnknownHostException {
        if (!this.IsIPv6(IPFrom) || !this.IsIPv6(IPTo)) {
            return null;
        }
        String ipFromBin = this.IPToBinary(IPFrom);
        String ipToBin = this.IPToBinary(IPTo);
        if (ipFromBin == null || ipToBin == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        int networkSize = 0;
        int shift = 0;
        TreeMap<String, Integer> networks = new TreeMap<String, Integer>();
        if (ipFromBin.compareTo(ipToBin) == 0) {
            result.add(IPFrom + "/128");
            return result;
        }
        if (ipFromBin.compareTo(ipToBin) > 0) {
            String tmp = ipFromBin;
            ipFromBin = ipToBin;
            ipToBin = tmp;
        }
        do {
            int n;
            String padded;
            String unpadded;
            if (ipFromBin.charAt(ipFromBin.length() - 1) == '1') {
                unpadded = ipFromBin.substring(networkSize, 128);
                padded = String.format("%-128s", unpadded).replace(' ', '0');
                networks.put(padded, 128 - networkSize);
                n = ipFromBin.lastIndexOf(48);
                ipFromBin = (n == 0 ? "" : ipFromBin.substring(0, n)) + "1";
                ipFromBin = String.format("%-128s", ipFromBin).replace(' ', '0');
            }
            if (ipToBin.charAt(ipToBin.length() - 1) == '0') {
                unpadded = ipToBin.substring(networkSize, 128);
                padded = String.format("%-128s", unpadded).replace(' ', '0');
                networks.put(padded, 128 - networkSize);
                n = ipToBin.lastIndexOf(49);
                ipToBin = (n == 0 ? "" : ipToBin.substring(0, n)) + "0";
                ipToBin = String.format("%-128s", ipToBin).replace(' ', '1');
            }
            if (ipToBin.compareTo(ipFromBin) < 0) continue;
            List<Integer> values = Arrays.asList(ipFromBin.lastIndexOf(48), ipToBin.lastIndexOf(49));
            shift = 128 - Collections.max(values);
            unpadded = ipFromBin.substring(0, 128 - shift);
            ipFromBin = String.format("%128s", unpadded).replace(' ', '0');
            unpadded = ipToBin.substring(0, 128 - shift);
            ipToBin = String.format("%128s", unpadded).replace(' ', '0');
            networkSize += shift;
            if (ipFromBin.compareTo(ipToBin) != 0) continue;
            unpadded = ipFromBin.substring(networkSize, 128);
            padded = String.format("%-128s", unpadded).replace(' ', '0');
            networks.put(padded, 128 - networkSize);
        } while (ipFromBin.compareTo(ipToBin) < 0);
        for (Map.Entry entry : networks.entrySet()) {
            result.add(this.CompressIPv6(this.BinaryToIP((String)entry.getKey())) + "/" + entry.getValue());
        }
        return result;
    }

    public String[] CIDRToIPv4(String CIDR) throws UnknownHostException {
        if (!CIDR.contains("/")) {
            return null;
        }
        String[] arr = CIDR.split("/");
        if (arr.length != 2 || !this.IsIPv4(arr[0]) || !PREFIX_PATTERN.matcher(arr[1]).matches() || Integer.parseInt(arr[1]) > 32) {
            return null;
        }
        String ip = arr[0];
        int prefix = Integer.parseInt(arr[1]);
        long ipStartLong = this.IPv4ToDecimal(ip).longValueExact();
        String ipStart = this.DecimalToIPv4(new BigInteger(String.valueOf(ipStartLong &= -1L << 32 - prefix)));
        long total = 1L << 32 - prefix;
        long ipEndLong = ipStartLong + total - 1L;
        if (ipEndLong > 0xFFFFFFFFL) {
            ipEndLong = 0xFFFFFFFFL;
        }
        String ipEnd = this.DecimalToIPv4(new BigInteger(String.valueOf(ipEndLong)));
        return new String[]{ipStart, ipEnd};
    }

    public String[] CIDRToIPv6(String CIDR) throws UnknownHostException {
        if (!CIDR.contains("/")) {
            return null;
        }
        String[] arr = CIDR.split("/");
        if (arr.length != 2 || !this.IsIPv6(arr[0]) || !PREFIX_PATTERN2.matcher(arr[1]).matches() || Integer.parseInt(arr[1]) > 128) {
            return null;
        }
        String ip = arr[0];
        int prefix = Integer.parseInt(arr[1]);
        String[] parts = this.ExpandIPv6(ip).split("\\:");
        String bitStart = StringUtils.repeat((char)'1', (int)prefix) + StringUtils.repeat((char)'0', (int)(128 - prefix));
        String bitEnd = StringUtils.repeat((char)'0', (int)prefix) + StringUtils.repeat((char)'1', (int)(128 - prefix));
        int chunkSize = 16;
        String[] floors = bitStart.split("(?<=\\G.{" + chunkSize + "})");
        String[] ceilings = bitEnd.split("(?<=\\G.{" + chunkSize + "})");
        ArrayList<String> startIP = new ArrayList<String>(8);
        ArrayList<String> endIP = new ArrayList<String>(8);
        for (int x = 0; x < 8; ++x) {
            startIP.add(Integer.toHexString(Integer.parseInt(parts[x], 16) & Integer.parseInt(floors[x], 2)));
            endIP.add(Integer.toHexString(Integer.parseInt(parts[x], 16) | Integer.parseInt(ceilings[x], 2)));
        }
        String hexStartAddress = this.ExpandIPv6(StringUtils.join(startIP, (String)":"));
        String hexEndAddress = this.ExpandIPv6(StringUtils.join(endIP, (String)":"));
        return new String[]{hexStartAddress, hexEndAddress};
    }
}

