/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.mascloud.sdkclient;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.renfei.mascloud.model.LoginReq;
import net.renfei.mascloud.model.MgcLoginRsp;
import net.renfei.mascloud.model.SubmitReportModel;
import net.renfei.mascloud.model.SubmitReq;
import net.renfei.mascloud.model.SubmitRsp;
import net.renfei.mascloud.util.DateTimeUtil;
import net.renfei.mascloud.util.HttpUtil;
import net.renfei.mascloud.util.JsonUtil;
import net.renfei.mascloud.util.MD5Util;
import net.renfei.mascloud.util.McMgwError;
import net.renfei.mascloud.util.McRptStatus;
import net.renfei.mascloud.util.MixUtil;
import net.renfei.mascloud.util.NamedThreadFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.entity.ContentType;

public class Client {
    private final AtomicBoolean logined = new AtomicBoolean(false);
    private String sendUrl;
    int num = 0;
    private String apId;
    private String apSecretKey;
    private String ecName;
    private int poolSize = 16;
    private int maxJobs = 8192;
    private final ThreadPoolExecutor nThreadPool = new ThreadPoolExecutor(this.poolSize, this.poolSize, 0L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.maxJobs), new NamedThreadFactory("thread-sendDsms"));

    private Client() {
    }

    public static Client getInstance() {
        return InstanceHolder.instance;
    }

    public String getSendUrl() {
        return this.sendUrl;
    }

    public void setSendUrl(String sendUrl) {
        this.sendUrl = sendUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(String url, String userAccount, String password, String ecname) {
        Client client = this;
        synchronized (client) {
            if (this.logined.get()) {
                System.err.println("user lgoined already");
                return true;
            }
        }
        LoginReq req = new LoginReq();
        req.setApId(userAccount);
        req.setSecretKey("");
        req.setEcName(ecname);
        try {
            MgcLoginRsp rsp = this.doLogin(url, req);
            if (rsp.isSuccess()) {
                this.sendUrl = rsp.getUrl();
                this.apId = userAccount;
                this.apSecretKey = password;
                this.ecName = ecname;
                this.logined.set(true);
            } else {
                System.out.println("\u767b\u5f55\u5931\u8d25\uff1a" + JsonUtil.toJsonString(rsp));
            }
        }
        catch (Exception var7) {
            System.out.println("\u767b\u5f55\u5f02\u5e38:" + var7);
            var7.printStackTrace();
        }
        return this.logined.get();
    }

    private MgcLoginRsp doLogin(String baseUrl, LoginReq req) throws Exception {
        MgcLoginRsp var8;
        String url = MixUtil.mergeUrl(baseUrl, "/sms/login");
        CloseableHttpResponse resp = null;
        try {
            String reqText = JsonUtil.toJsonString(req);
            String encode = Base64.encodeBase64String((byte[])reqText.getBytes(StandardCharsets.UTF_8));
            System.out.println("loginreq\t" + reqText);
            resp = HttpUtil.post(url, encode, ContentType.APPLICATION_JSON);
            if (resp.getStatusLine().getStatusCode() != 200) {
                System.err.println("login to " + url + " exception, code = " + resp.getStatusLine().getStatusCode());
                throw new RuntimeException("login exception");
            }
            String respText = HttpUtil.readHttpResponse((HttpResponse)resp);
            if (StringUtils.isBlank((CharSequence)respText)) {
                System.err.println("not found loginrsp data");
                throw new RuntimeException("login exception: not found loginrsp data");
            }
            System.out.println("loginrsp\t" + respText);
            var8 = JsonUtil.fromJsonString(respText, MgcLoginRsp.class);
        }
        catch (Exception var12) {
            try {
                System.err.println("login to " + url + " exception, error = " + var12);
                throw var12;
            }
            catch (Throwable throwable) {
                HttpUtil.safeClose(resp);
                throw throwable;
            }
        }
        HttpUtil.safeClose(resp);
        return var8;
    }

    public int sendDSMS(String[] mobiles, String smsContent, String addSerial, int smsPriority, String sign, String msgGroup, boolean isMo) {
        if (!this.logined.get()) {
            return 105;
        }
        if (mobiles == null) {
            return 102;
        }
        if (mobiles.length == 0) {
            return 103;
        }
        if (mobiles.length > 5000) {
            return 110;
        }
        int var10 = mobiles.length;
        HashSet<String> mbSet = new HashSet<String>(Arrays.asList(mobiles).subList(0, var10));
        if (mbSet.size() != mobiles.length) {
            return 109;
        }
        if (StringUtils.isBlank((CharSequence)smsContent)) {
            return 101;
        }
        if (StringUtils.isBlank((CharSequence)sign)) {
            return 106;
        }
        SubmitReq submit = new SubmitReq();
        submit.setApId(this.apId);
        submit.setApReqId(msgGroup != null ? msgGroup : MixUtil.uuid());
        if (StringUtils.isBlank((CharSequence)addSerial)) {
            addSerial = "";
        }
        if (StringUtils.isBlank((CharSequence)this.apSecretKey)) {
            this.apSecretKey = "";
        }
        submit.setMac(MD5Util.md5Encode(this.apId + this.apSecretKey + this.ecName + smsContent + sign + addSerial));
        submit.setContent(smsContent);
        submit.setMobiles(new ArrayList<String>(mbSet));
        submit.setSrcId(addSerial);
        submit.setServiceId(sign);
        submit.setRegReport(isMo);
        submit.setEcName(this.ecName);
        Runnable task = null;
        try {
            new SubmitTask(submit, mobiles, this.sendUrl);
            this.nThreadPool.execute(new SubmitTask(submit, mobiles, this.sendUrl));
            return 1;
        }
        catch (RejectedExecutionException var13) {
            task.run();
            return 112;
        }
    }

    public int sendTSMS(String[] mobiles, String tempID, String[] params, String addSerial, int smsPriority, String sign, String msgGroup) {
        if (!this.logined.get()) {
            return 105;
        }
        if (mobiles == null) {
            return 102;
        }
        if (mobiles.length == 0) {
            return 103;
        }
        if (mobiles.length > 5000) {
            return 110;
        }
        int var10 = mobiles.length;
        HashSet<String> mbSet = new HashSet<String>(Arrays.asList(mobiles).subList(0, var10));
        if (mbSet.size() != mobiles.length) {
            return 109;
        }
        if (params != null && params.length != 0) {
            if (StringUtils.isBlank((CharSequence)sign)) {
                return 106;
            }
            if (StringUtils.isBlank((CharSequence)tempID)) {
                return 111;
            }
            SubmitReq submit = new SubmitReq();
            submit.setApId(this.apId);
            submit.setApReqId(msgGroup != null ? msgGroup : MixUtil.uuid());
            submit.setMac(MD5Util.md5Encode(this.apId + this.apSecretKey + this.ecName + tempID + sign + addSerial));
            submit.setContent(JsonUtil.toJsonString(params));
            submit.setMobiles(new ArrayList<String>(mbSet));
            submit.setSrcId(addSerial);
            submit.setServiceId(sign);
            submit.setRegReport(true);
            submit.setTemplateId(tempID);
            submit.setEcName(this.ecName);
            Runnable task = null;
            try {
                new SubmitTask(submit, mobiles, this.sendUrl);
                this.nThreadPool.execute(new SubmitTask(submit, mobiles, this.sendUrl));
                return 1;
            }
            catch (RejectedExecutionException var13) {
                task.run();
                return 112;
            }
        }
        return 101;
    }

    private SubmitRsp doSubmit(String baseUrl, SubmitReq req) throws Exception {
        SubmitRsp var8;
        String url = MixUtil.mergeUrl(baseUrl, "/sms/submit");
        CloseableHttpResponse resp = null;
        try {
            String reqText = JsonUtil.toJsonString(req);
            System.out.println("submitreq\t" + reqText);
            String encode = Base64.encodeBase64String((byte[])reqText.getBytes(StandardCharsets.UTF_8));
            resp = HttpUtil.post(url, encode, ContentType.APPLICATION_JSON);
            if (resp.getStatusLine().getStatusCode() != 200) {
                System.err.println("submit to " + url + " exception, code = " + resp.getStatusLine().getStatusCode());
                throw new RuntimeException("submit exception");
            }
            String respText = HttpUtil.readHttpResponse((HttpResponse)resp);
            if (StringUtils.isBlank((CharSequence)respText)) {
                System.err.println("not found submitrsp data");
                throw new RuntimeException("submit exception:not found submitrsp data");
            }
            System.out.println("submitrsp\t" + respText);
            var8 = JsonUtil.fromJsonString(respText, SubmitRsp.class);
        }
        catch (Exception var12) {
            try {
                System.err.println("submit to " + url + " exception, error = " + var12.getMessage());
                throw var12;
            }
            catch (Throwable throwable) {
                HttpUtil.safeClose(resp);
                throw throwable;
            }
        }
        HttpUtil.safeClose(resp);
        return var8;
    }

    private String parseSubmitStatus(String rspcod) {
        if (McMgwError.InvalidUsrOrPwd.becauseOf(rspcod)) {
            return McRptStatus.INVALID_USR_OR_PWD.getStatus();
        }
        if (McMgwError.InvalidMessage.becauseOf(rspcod)) {
            return McRptStatus.INVALID_MESSAGE.getStatus();
        }
        if (McMgwError.NO_SIGN_ID.becauseOf(rspcod)) {
            return McRptStatus.NO_SIGN_ID.getStatus();
        }
        if (McMgwError.TOO_MANY_MOBILES.becauseOf(rspcod)) {
            return McRptStatus.TOO_MANY_MOBILES.getStatus();
        }
        return McMgwError.ILLEGAL_SIGN_ID.becauseOf(rspcod) ? McRptStatus.ILLEGAL_SIGN_ID.getStatus() : "CM:9999";
    }

    private static final class InstanceHolder {
        public static final Client instance = new Client();

        private InstanceHolder() {
        }
    }

    public final class SubmitTask
    implements Runnable {
        private final SubmitReq submit;
        private final String[] mobiles;
        private final String sendUrl;

        public SubmitTask(SubmitReq submit, String[] mobiles, String sendUrl) {
            this.submit = submit;
            this.mobiles = mobiles;
            this.sendUrl = sendUrl;
        }

        @Override
        public void run() {
            SubmitReportModel model = null;
            SubmitReportModel model2 = null;
            try {
                SubmitRsp rsp = Client.this.doSubmit(this.sendUrl, this.submit);
                model = new SubmitReportModel();
                model.setMobiles(this.mobiles);
                model.setMsgGroup(this.submit.getApReqId());
                model.setReportStatus(rsp.isSuccess() ? "CM:0000" : Client.this.parseSubmitStatus(rsp.getRspcod()));
                model.setSubmitDate(DateTimeUtil.getDate());
                model.setReceiveDate(DateTimeUtil.getDate());
                model.setErrorCode(rsp.getRspcod());
                if (rsp.isSuccess()) {
                    model2 = new SubmitReportModel();
                    model2.setMobiles(this.mobiles);
                    model2.setMsgGroup(this.submit.getApReqId());
                    model2.setReportStatus("CM:3000");
                    model2.setSubmitDate(DateTimeUtil.getDate());
                    model2.setReceiveDate(DateTimeUtil.getDate());
                    model2.setErrorCode(rsp.getRspcod());
                }
            }
            catch (Exception var4) {
                model = new SubmitReportModel();
                model.setMobiles(this.mobiles);
                model.setMsgGroup(this.submit.getApReqId());
                model.setReportStatus("\u53d1\u9001\u9519\u8bef");
                model.setSubmitDate(DateTimeUtil.getDate());
                model.setReceiveDate(DateTimeUtil.getDate());
                model.setErrorCode("CM:9999");
            }
        }
    }
}

