/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.mascloud.util;

import java.io.IOException;
import java.nio.charset.Charset;
import net.renfei.mascloud.util.HttpClientHolder;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    public static CloseableHttpResponse post(String url, String dat, ContentType type) throws Exception {
        HttpPost post = new HttpPost(url);
        HttpEntity entity = EntityBuilder.create().setText(dat).setContentType(type).build();
        post.setEntity(entity);
        CloseableHttpClient client = HttpClientHolder.getInstance().getClient();
        CloseableHttpResponse resp = client.execute((HttpUriRequest)post);
        return resp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readHttpResponse(HttpResponse response) throws IOException {
        String var5;
        HttpEntity resEntity = response.getEntity();
        if (resEntity == null) {
            return null;
        }
        try {
            Charset charset = ContentType.getOrDefault((HttpEntity)resEntity).getCharset();
            String contentCharset = charset == null ? HTTP.DEF_CONTENT_CHARSET.name() : charset.name();
            byte[] data = EntityUtils.toByteArray((HttpEntity)resEntity);
            var5 = new String(data, contentCharset);
        }
        finally {
            EntityUtils.consume((HttpEntity)resEntity);
        }
        return var5;
    }

    public static void safeClose(CloseableHttpResponse o) {
        if (o != null) {
            if (o.getEntity() != null) {
                try {
                    EntityUtils.consume((HttpEntity)o.getEntity());
                }
                catch (IOException var3) {
                    var3.printStackTrace();
                }
            }
            try {
                o.close();
            }
            catch (Throwable var2) {
                var2.printStackTrace();
            }
        }
    }
}

