/*
 * Decompiled with CFR 0.152.
 */
package net.renfei.validator.verifier.preset;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.renfei.validator.annotation.preset.ChinaIdCardCheck;
import net.renfei.validator.entity.VerifiedReportDetail;
import net.renfei.validator.verifier.Verifier;

public class ChinaIdCardVerifierImpl
implements Verifier {
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final String[] CITY_CODE = new String[]{"11", "12", "13", "14", "15", "21", "22", "23", "31", "32", "33", "34", "35", "36", "37", "41", "42", "43", "44", "45", "46", "50", "51", "52", "53", "54", "61", "62", "63", "64", "65", "71", "81", "82", "91"};
    private static final int[] POWER = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final String[] VERIFY_CODE = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static final int MIN = 1930;
    private static final Map<String, String> CITY_CODES = new ConcurrentHashMap<String, String>();
    private static final Map<String, Integer> TW_FIRST_CODE = new ConcurrentHashMap<String, Integer>();
    private static final Map<String, Integer> HK_FIRST_CODE = new ConcurrentHashMap<String, Integer>();

    @Override
    public VerifiedReportDetail verification(Annotation annotation, Object object, Field field) {
        VerifiedReportDetail report = new VerifiedReportDetail();
        field.setAccessible(true);
        try {
            report.setPassed(field.get(object) != null && this.validateCard(field.get(object).toString().toUpperCase()));
            report.setFieldValue(field.get(object) == null ? null : field.get(object).toString());
            report.setFieldType(field.getType().getName());
        }
        catch (IllegalAccessException e) {
            report.setPassed(false);
            e.printStackTrace();
        }
        report.setFieldName(field.getName());
        report.setVerificationTime(new Date());
        report.setVerifierName(this.getClass().getName());
        report.setValidatorName(annotation.toString());
        report.setBusinessName(((ChinaIdCardCheck)annotation).businessName());
        return report;
    }

    private String convert15CardTo18(String idCard) {
        String sVal;
        String idCard18;
        if (idCard.length() != 15) {
            return null;
        }
        if (this.isNum(idCard)) {
            String birthday = idCard.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yyMMdd").parse(birthday);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar cal = Calendar.getInstance();
            if (birthDate != null) {
                cal.setTime(birthDate);
            }
            String sYear = String.valueOf(cal.get(1));
            idCard18 = idCard.substring(0, 6) + sYear + idCard.substring(8);
            char[] cArr = idCard18.toCharArray();
            int[] iCard = this.converCharToInt(cArr);
            int iSum17 = this.getPowerSum(iCard);
            sVal = this.getCheckCode18(iSum17);
            if (sVal.length() <= 0) {
                return null;
            }
        } else {
            return null;
        }
        idCard18 = idCard18 + sVal;
        return idCard18;
    }

    private boolean validateCard(String idCard) {
        String card = idCard.trim();
        if (this.validateIdCard18(card)) {
            return true;
        }
        if (this.validateIdCard15(card)) {
            return true;
        }
        String[] cardval = this.validateIdCard10(card);
        if (cardval != null) {
            return "true".equals(cardval[2]);
        }
        return false;
    }

    private boolean validateIdCard18(String idCard) {
        boolean bTrue = false;
        if (idCard.length() == 18) {
            char[] cArr;
            int[] iCard;
            int iSum17;
            String val;
            String code17 = idCard.substring(0, 17);
            String code18 = idCard.substring(17, 18);
            if (this.isNum(code17) && (val = this.getCheckCode18(iSum17 = this.getPowerSum(iCard = this.converCharToInt(cArr = code17.toCharArray())))).length() > 0 && val.equalsIgnoreCase(code18)) {
                bTrue = true;
            }
        }
        return bTrue;
    }

    private boolean validateIdCard15(String idCard) {
        if (idCard.length() != 15) {
            return false;
        }
        if (this.isNum(idCard)) {
            String proCode = idCard.substring(0, 2);
            if (CITY_CODES.get(proCode) == null) {
                return false;
            }
            String birthCode = idCard.substring(6, 12);
            Date birthDate = null;
            try {
                birthDate = new SimpleDateFormat("yy").parse(birthCode.substring(0, 2));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            Calendar cal = Calendar.getInstance();
            if (birthDate != null) {
                cal.setTime(birthDate);
            }
            return this.valiDate(cal.get(1), Integer.parseInt(birthCode.substring(2, 4)), Integer.parseInt(birthCode.substring(4, 6)));
        }
        return false;
    }

    private String[] validateIdCard10(String idCard) {
        String[] info = new String[3];
        String card = idCard.replaceAll("[\\(|\\)]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return null;
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            System.out.println("11111");
            String char2 = idCard.substring(1, 2);
            if ("1".equals(char2)) {
                info[1] = "M";
                System.out.println("MMMMMMM");
            } else if ("2".equals(char2)) {
                info[1] = "F";
                System.out.println("FFFFFFF");
            } else {
                info[1] = "N";
                info[2] = "false";
                System.out.println("NNNN");
                return info;
            }
            info[2] = this.validateTWCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
        } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = this.validateHKCard(idCard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    private boolean validateTWCard(String idCard) {
        String start = idCard.substring(0, 1);
        String mid = idCard.substring(1, 9);
        String end = idCard.substring(9, 10);
        Integer iStart = TW_FIRST_CODE.get(start);
        int sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        int iflag = 8;
        for (char c : chars) {
            sum += Integer.parseInt(c + "") * iflag;
            --iflag;
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.parseInt(end);
    }

    private boolean validateHKCard(String idCard) {
        String card = idCard.replaceAll("[\\(|\\)]", "");
        int sum = 0;
        int i = card.substring(0, 1).toUpperCase().toCharArray()[0] - 55;
        if (card.length() == 9) {
            sum = i * 9 + (card.substring(1, 2).toUpperCase().toCharArray()[0] - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + i * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        int iflag = 7;
        for (char c : chars) {
            sum += Integer.parseInt(c + "") * iflag;
            --iflag;
        }
        sum = "A".equalsIgnoreCase(end) ? (sum += 10) : (sum += Integer.parseInt(end));
        return sum % 11 == 0;
    }

    private int[] converCharToInt(char[] ca) {
        int len = ca.length;
        int[] iArr = new int[len];
        try {
            for (int i = 0; i < len; ++i) {
                iArr[i] = Integer.parseInt(String.valueOf(ca[i]));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return iArr;
    }

    private int getPowerSum(int[] iArr) {
        int iSum = 0;
        if (POWER.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                for (int j = 0; j < POWER.length; ++j) {
                    if (i != j) continue;
                    iSum += iArr[i] * POWER[j];
                }
            }
        }
        return iSum;
    }

    private String getCheckCode18(int iSum) {
        String sCode = "";
        switch (iSum % 11) {
            case 10: {
                sCode = "2";
                break;
            }
            case 9: {
                sCode = "3";
                break;
            }
            case 8: {
                sCode = "4";
                break;
            }
            case 7: {
                sCode = "5";
                break;
            }
            case 6: {
                sCode = "6";
                break;
            }
            case 5: {
                sCode = "7";
                break;
            }
            case 4: {
                sCode = "8";
                break;
            }
            case 3: {
                sCode = "9";
                break;
            }
            case 2: {
                sCode = "x";
                break;
            }
            case 1: {
                sCode = "0";
                break;
            }
            case 0: {
                sCode = "1";
                break;
            }
        }
        return sCode;
    }

    private boolean isNum(String val) {
        return val != null && !"".equals(val) && val.matches("^[0-9]*$");
    }

    private boolean valiDate(int iYear, int iMonth, int iDate) {
        int datePerMonth;
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (iYear < 1930 || iYear >= year) {
            return false;
        }
        if (iMonth < 1 || iMonth > 12) {
            return false;
        }
        switch (iMonth) {
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                datePerMonth = 30;
                break;
            }
            case 2: {
                boolean dm = (iYear % 4 == 0 && iYear % 100 != 0 || iYear % 400 == 0) && iYear > 1930;
                datePerMonth = dm ? 29 : 28;
                break;
            }
            default: {
                datePerMonth = 31;
            }
        }
        return iDate >= 1 && iDate <= datePerMonth;
    }

    static {
        CITY_CODES.put("11", "\u5317\u4eac");
        CITY_CODES.put("12", "\u5929\u6d25");
        CITY_CODES.put("13", "\u6cb3\u5317");
        CITY_CODES.put("14", "\u5c71\u897f");
        CITY_CODES.put("15", "\u5185\u8499\u53e4");
        CITY_CODES.put("21", "\u8fbd\u5b81");
        CITY_CODES.put("22", "\u5409\u6797");
        CITY_CODES.put("23", "\u9ed1\u9f99\u6c5f");
        CITY_CODES.put("31", "\u4e0a\u6d77");
        CITY_CODES.put("32", "\u6c5f\u82cf");
        CITY_CODES.put("33", "\u6d59\u6c5f");
        CITY_CODES.put("34", "\u5b89\u5fbd");
        CITY_CODES.put("35", "\u798f\u5efa");
        CITY_CODES.put("36", "\u6c5f\u897f");
        CITY_CODES.put("37", "\u5c71\u4e1c");
        CITY_CODES.put("41", "\u6cb3\u5357");
        CITY_CODES.put("42", "\u6e56\u5317");
        CITY_CODES.put("43", "\u6e56\u5357");
        CITY_CODES.put("44", "\u5e7f\u4e1c");
        CITY_CODES.put("45", "\u5e7f\u897f");
        CITY_CODES.put("46", "\u6d77\u5357");
        CITY_CODES.put("50", "\u91cd\u5e86");
        CITY_CODES.put("51", "\u56db\u5ddd");
        CITY_CODES.put("52", "\u8d35\u5dde");
        CITY_CODES.put("53", "\u4e91\u5357");
        CITY_CODES.put("54", "\u897f\u85cf");
        CITY_CODES.put("61", "\u9655\u897f");
        CITY_CODES.put("62", "\u7518\u8083");
        CITY_CODES.put("63", "\u9752\u6d77");
        CITY_CODES.put("64", "\u5b81\u590f");
        CITY_CODES.put("65", "\u65b0\u7586");
        CITY_CODES.put("71", "\u53f0\u6e7e");
        CITY_CODES.put("81", "\u9999\u6e2f");
        CITY_CODES.put("82", "\u6fb3\u95e8");
        CITY_CODES.put("91", "\u56fd\u5916");
        TW_FIRST_CODE.put("A", 10);
        TW_FIRST_CODE.put("B", 11);
        TW_FIRST_CODE.put("C", 12);
        TW_FIRST_CODE.put("D", 13);
        TW_FIRST_CODE.put("E", 14);
        TW_FIRST_CODE.put("F", 15);
        TW_FIRST_CODE.put("G", 16);
        TW_FIRST_CODE.put("H", 17);
        TW_FIRST_CODE.put("J", 18);
        TW_FIRST_CODE.put("K", 19);
        TW_FIRST_CODE.put("L", 20);
        TW_FIRST_CODE.put("M", 21);
        TW_FIRST_CODE.put("N", 22);
        TW_FIRST_CODE.put("P", 23);
        TW_FIRST_CODE.put("Q", 24);
        TW_FIRST_CODE.put("R", 25);
        TW_FIRST_CODE.put("S", 26);
        TW_FIRST_CODE.put("T", 27);
        TW_FIRST_CODE.put("U", 28);
        TW_FIRST_CODE.put("V", 29);
        TW_FIRST_CODE.put("X", 30);
        TW_FIRST_CODE.put("Y", 31);
        TW_FIRST_CODE.put("W", 32);
        TW_FIRST_CODE.put("Z", 33);
        TW_FIRST_CODE.put("I", 34);
        TW_FIRST_CODE.put("O", 35);
        HK_FIRST_CODE.put("A", 1);
        HK_FIRST_CODE.put("B", 2);
        HK_FIRST_CODE.put("C", 3);
        HK_FIRST_CODE.put("R", 18);
        HK_FIRST_CODE.put("U", 21);
        HK_FIRST_CODE.put("Z", 26);
        HK_FIRST_CODE.put("X", 24);
        HK_FIRST_CODE.put("W", 23);
        HK_FIRST_CODE.put("O", 15);
        HK_FIRST_CODE.put("N", 14);
    }
}

