package net.rgielen.com4j.office2010.excel  ;

import com4j.*;

@IID("{00024413-0001-0000-C000-000000000046}")
public interface IAppEvents extends Com4jObject {
  // Methods:
  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   */

  @VTID(7)
  void newWorkbook(
    net.rgielen.com4j.office2010.excel._Workbook wb);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   */

  @VTID(8)
  void sheetSelectionChange(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Range target);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(9)
  void sheetBeforeDoubleClick(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Range target,
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(10)
  void sheetBeforeRightClick(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Range target,
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   */

  @VTID(11)
  void sheetActivate(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   */

  @VTID(12)
  void sheetDeactivate(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   */

  @VTID(13)
  void sheetCalculate(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   */

  @VTID(14)
  void sheetChange(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Range target);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   */

  @VTID(15)
  void workbookOpen(
    net.rgielen.com4j.office2010.excel._Workbook wb);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   */

  @VTID(16)
  void workbookActivate(
    net.rgielen.com4j.office2010.excel._Workbook wb);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   */

  @VTID(17)
  void workbookDeactivate(
    net.rgielen.com4j.office2010.excel._Workbook wb);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(18)
  void workbookBeforeClose(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    Holder<Boolean> cancel);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param saveAsUI Mandatory boolean parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(19)
  void workbookBeforeSave(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    boolean saveAsUI,
    Holder<Boolean> cancel);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(20)
  void workbookBeforePrint(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    Holder<Boolean> cancel);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param sh Mandatory com4j.Com4jObject parameter.
   */

  @VTID(21)
  void workbookNewSheet(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   */

  @VTID(22)
  void workbookAddinInstall(
    net.rgielen.com4j.office2010.excel._Workbook wb);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   */

  @VTID(23)
  void workbookAddinUninstall(
    net.rgielen.com4j.office2010.excel._Workbook wb);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param wn Mandatory net.rgielen.com4j.office2010.excel.Window parameter.
   */

  @VTID(24)
  void windowResize(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.Window wn);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param wn Mandatory net.rgielen.com4j.office2010.excel.Window parameter.
   */

  @VTID(25)
  void windowActivate(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.Window wn);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param wn Mandatory net.rgielen.com4j.office2010.excel.Window parameter.
   */

  @VTID(26)
  void windowDeactivate(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.Window wn);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Hyperlink parameter.
   */

  @VTID(27)
  void sheetFollowHyperlink(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Hyperlink target);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   */

  @VTID(28)
  void sheetPivotTableUpdate(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable target);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   */

  @VTID(29)
  void workbookPivotTableCloseConnection(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.PivotTable target);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   */

  @VTID(30)
  void workbookPivotTableOpenConnection(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.PivotTable target);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param syncEventType Mandatory net.rgielen.com4j.office2010.office.MsoSyncEventType parameter.
   */

  @VTID(31)
  void workbookSync(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.office.MsoSyncEventType syncEventType);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param map Mandatory net.rgielen.com4j.office2010.excel.XmlMap parameter.
   * @param url Mandatory java.lang.String parameter.
   * @param isRefresh Mandatory boolean parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(32)
  void workbookBeforeXmlImport(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.XmlMap map,
    java.lang.String url,
    boolean isRefresh,
    Holder<Boolean> cancel);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param map Mandatory net.rgielen.com4j.office2010.excel.XmlMap parameter.
   * @param isRefresh Mandatory boolean parameter.
   * @param result Mandatory net.rgielen.com4j.office2010.excel.XlXmlImportResult parameter.
   */

  @VTID(33)
  void workbookAfterXmlImport(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.XmlMap map,
    boolean isRefresh,
    net.rgielen.com4j.office2010.excel.XlXmlImportResult result);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param map Mandatory net.rgielen.com4j.office2010.excel.XmlMap parameter.
   * @param url Mandatory java.lang.String parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(34)
  void workbookBeforeXmlExport(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.XmlMap map,
    java.lang.String url,
    Holder<Boolean> cancel);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param map Mandatory net.rgielen.com4j.office2010.excel.XmlMap parameter.
   * @param url Mandatory java.lang.String parameter.
   * @param result Mandatory net.rgielen.com4j.office2010.excel.XlXmlExportResult parameter.
   */

  @VTID(35)
  void workbookAfterXmlExport(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel.XmlMap map,
    java.lang.String url,
    net.rgielen.com4j.office2010.excel.XlXmlExportResult result);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param description Mandatory java.lang.String parameter.
   * @param sheet Mandatory java.lang.String parameter.
   * @param success Mandatory boolean parameter.
   */

  @VTID(36)
  void workbookRowsetComplete(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    java.lang.String description,
    java.lang.String sheet,
    boolean success);


  /**
   */

  @VTID(37)
  void afterCalculate();


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param targetPivotTable Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   * @param targetRange Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   */

  @VTID(38)
  void sheetPivotTableAfterValueChange(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable targetPivotTable,
    net.rgielen.com4j.office2010.excel.Range targetRange);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param targetPivotTable Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   * @param valueChangeStart Mandatory int parameter.
   * @param valueChangeEnd Mandatory int parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(39)
  void sheetPivotTableBeforeAllocateChanges(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable targetPivotTable,
    int valueChangeStart,
    int valueChangeEnd,
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param targetPivotTable Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   * @param valueChangeStart Mandatory int parameter.
   * @param valueChangeEnd Mandatory int parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(40)
  void sheetPivotTableBeforeCommitChanges(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable targetPivotTable,
    int valueChangeStart,
    int valueChangeEnd,
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param targetPivotTable Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   * @param valueChangeStart Mandatory int parameter.
   * @param valueChangeEnd Mandatory int parameter.
   */

  @VTID(41)
  void sheetPivotTableBeforeDiscardChanges(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable targetPivotTable,
    int valueChangeStart,
    int valueChangeEnd);


  /**
   * @param pvw Mandatory net.rgielen.com4j.office2010.excel.ProtectedViewWindow parameter.
   */

  @VTID(42)
  void protectedViewWindowOpen(
    net.rgielen.com4j.office2010.excel.ProtectedViewWindow pvw);


  /**
   * @param pvw Mandatory net.rgielen.com4j.office2010.excel.ProtectedViewWindow parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(43)
  void protectedViewWindowBeforeEdit(
    net.rgielen.com4j.office2010.excel.ProtectedViewWindow pvw,
    Holder<Boolean> cancel);


  /**
   * @param pvw Mandatory net.rgielen.com4j.office2010.excel.ProtectedViewWindow parameter.
   * @param reason Mandatory net.rgielen.com4j.office2010.excel.XlProtectedViewCloseReason parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(44)
  void protectedViewWindowBeforeClose(
    net.rgielen.com4j.office2010.excel.ProtectedViewWindow pvw,
    net.rgielen.com4j.office2010.excel.XlProtectedViewCloseReason reason,
    Holder<Boolean> cancel);


  /**
   * @param pvw Mandatory net.rgielen.com4j.office2010.excel.ProtectedViewWindow parameter.
   */

  @VTID(45)
  void protectedViewWindowResize(
    net.rgielen.com4j.office2010.excel.ProtectedViewWindow pvw);


  /**
   * @param pvw Mandatory net.rgielen.com4j.office2010.excel.ProtectedViewWindow parameter.
   */

  @VTID(46)
  void protectedViewWindowActivate(
    net.rgielen.com4j.office2010.excel.ProtectedViewWindow pvw);


  /**
   * @param pvw Mandatory net.rgielen.com4j.office2010.excel.ProtectedViewWindow parameter.
   */

  @VTID(47)
  void protectedViewWindowDeactivate(
    net.rgielen.com4j.office2010.excel.ProtectedViewWindow pvw);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param success Mandatory boolean parameter.
   */

  @VTID(48)
  void workbookAfterSave(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    boolean success);


  /**
   * @param wb Mandatory net.rgielen.com4j.office2010.excel._Workbook parameter.
   * @param ch Mandatory net.rgielen.com4j.office2010.excel._Chart parameter.
   */

  @VTID(49)
  void workbookNewChart(
    net.rgielen.com4j.office2010.excel._Workbook wb,
    net.rgielen.com4j.office2010.excel._Chart ch);


  // Properties:
}
