package net.rgielen.com4j.office2010.excel  ;

import com4j.*;

@IID("{00024412-0001-0000-C000-000000000046}")
public interface IWorkbookEvents extends Com4jObject {
  // Methods:
  /**
   */

  @VTID(7)
  void open();


  /**
   */

  @VTID(8)
  void activate();


  /**
   */

  @VTID(9)
  void deactivate();


  /**
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(10)
  void beforeClose(
    Holder<Boolean> cancel);


  /**
   * @param saveAsUI Mandatory boolean parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(11)
  void beforeSave(
    boolean saveAsUI,
    Holder<Boolean> cancel);


  /**
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(12)
  void beforePrint(
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   */

  @VTID(13)
  void newSheet(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh);


  /**
   */

  @VTID(14)
  void addinInstall();


  /**
   */

  @VTID(15)
  void addinUninstall();


  /**
   * @param wn Mandatory net.rgielen.com4j.office2010.excel.Window parameter.
   */

  @VTID(16)
  void windowResize(
    net.rgielen.com4j.office2010.excel.Window wn);


  /**
   * @param wn Mandatory net.rgielen.com4j.office2010.excel.Window parameter.
   */

  @VTID(17)
  void windowActivate(
    net.rgielen.com4j.office2010.excel.Window wn);


  /**
   * @param wn Mandatory net.rgielen.com4j.office2010.excel.Window parameter.
   */

  @VTID(18)
  void windowDeactivate(
    net.rgielen.com4j.office2010.excel.Window wn);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   */

  @VTID(19)
  void sheetSelectionChange(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Range target);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(20)
  void sheetBeforeDoubleClick(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Range target,
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(21)
  void sheetBeforeRightClick(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Range target,
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   */

  @VTID(22)
  void sheetActivate(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   */

  @VTID(23)
  void sheetDeactivate(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   */

  @VTID(24)
  void sheetCalculate(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   */

  @VTID(25)
  void sheetChange(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Range target);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.Hyperlink parameter.
   */

  @VTID(26)
  void sheetFollowHyperlink(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.Hyperlink target);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   */

  @VTID(27)
  void sheetPivotTableUpdate(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable target);


  /**
   * @param target Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   */

  @VTID(28)
  void pivotTableCloseConnection(
    net.rgielen.com4j.office2010.excel.PivotTable target);


  /**
   * @param target Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   */

  @VTID(29)
  void pivotTableOpenConnection(
    net.rgielen.com4j.office2010.excel.PivotTable target);


  /**
   * @param syncEventType Mandatory net.rgielen.com4j.office2010.office.MsoSyncEventType parameter.
   */

  @VTID(30)
  void sync(
    net.rgielen.com4j.office2010.office.MsoSyncEventType syncEventType);


  /**
   * @param map Mandatory net.rgielen.com4j.office2010.excel.XmlMap parameter.
   * @param url Mandatory java.lang.String parameter.
   * @param isRefresh Mandatory boolean parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(31)
  void beforeXmlImport(
    net.rgielen.com4j.office2010.excel.XmlMap map,
    java.lang.String url,
    boolean isRefresh,
    Holder<Boolean> cancel);


  /**
   * @param map Mandatory net.rgielen.com4j.office2010.excel.XmlMap parameter.
   * @param isRefresh Mandatory boolean parameter.
   * @param result Mandatory net.rgielen.com4j.office2010.excel.XlXmlImportResult parameter.
   */

  @VTID(32)
  void afterXmlImport(
    net.rgielen.com4j.office2010.excel.XmlMap map,
    boolean isRefresh,
    net.rgielen.com4j.office2010.excel.XlXmlImportResult result);


  /**
   * @param map Mandatory net.rgielen.com4j.office2010.excel.XmlMap parameter.
   * @param url Mandatory java.lang.String parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(33)
  void beforeXmlExport(
    net.rgielen.com4j.office2010.excel.XmlMap map,
    java.lang.String url,
    Holder<Boolean> cancel);


  /**
   * @param map Mandatory net.rgielen.com4j.office2010.excel.XmlMap parameter.
   * @param url Mandatory java.lang.String parameter.
   * @param result Mandatory net.rgielen.com4j.office2010.excel.XlXmlExportResult parameter.
   */

  @VTID(34)
  void afterXmlExport(
    net.rgielen.com4j.office2010.excel.XmlMap map,
    java.lang.String url,
    net.rgielen.com4j.office2010.excel.XlXmlExportResult result);


  /**
   * @param description Mandatory java.lang.String parameter.
   * @param sheet Mandatory java.lang.String parameter.
   * @param success Mandatory boolean parameter.
   */

  @VTID(35)
  void rowsetComplete(
    java.lang.String description,
    java.lang.String sheet,
    boolean success);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param targetPivotTable Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   * @param targetRange Mandatory net.rgielen.com4j.office2010.excel.Range parameter.
   */

  @VTID(36)
  void sheetPivotTableAfterValueChange(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable targetPivotTable,
    net.rgielen.com4j.office2010.excel.Range targetRange);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param targetPivotTable Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   * @param valueChangeStart Mandatory int parameter.
   * @param valueChangeEnd Mandatory int parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(37)
  void sheetPivotTableBeforeAllocateChanges(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable targetPivotTable,
    int valueChangeStart,
    int valueChangeEnd,
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param targetPivotTable Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   * @param valueChangeStart Mandatory int parameter.
   * @param valueChangeEnd Mandatory int parameter.
   * @param cancel Mandatory Holder<Boolean> parameter.
   */

  @VTID(38)
  void sheetPivotTableBeforeCommitChanges(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable targetPivotTable,
    int valueChangeStart,
    int valueChangeEnd,
    Holder<Boolean> cancel);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param targetPivotTable Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   * @param valueChangeStart Mandatory int parameter.
   * @param valueChangeEnd Mandatory int parameter.
   */

  @VTID(39)
  void sheetPivotTableBeforeDiscardChanges(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable targetPivotTable,
    int valueChangeStart,
    int valueChangeEnd);


  /**
   * @param sh Mandatory com4j.Com4jObject parameter.
   * @param target Mandatory net.rgielen.com4j.office2010.excel.PivotTable parameter.
   */

  @VTID(40)
  void sheetPivotTableChangeSync(
    @MarshalAs(NativeType.Dispatch) com4j.Com4jObject sh,
    net.rgielen.com4j.office2010.excel.PivotTable target);


  /**
   * @param success Mandatory boolean parameter.
   */

  @VTID(41)
  void afterSave(
    boolean success);


  /**
   * @param ch Mandatory net.rgielen.com4j.office2010.excel._Chart parameter.
   */

  @VTID(42)
  void newChart(
    net.rgielen.com4j.office2010.excel._Chart ch);


  // Properties:
}
