/*
 * Decompiled with CFR 0.152.
 */
package net.rgielen.fxweaver.spring.boot.autoconfigure;

import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import net.rgielen.fxweaver.core.FxControllerAndView;
import net.rgielen.fxweaver.core.FxWeaver;
import net.rgielen.fxweaver.spring.InjectionPointLazyFxControllerAndViewResolver;
import net.rgielen.fxweaver.spring.SpringFxWeaver;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@ConditionalOnClass(value={Node.class, FXMLLoader.class, SpringFxWeaver.class})
public class FxWeaverAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={FxWeaver.class})
    public FxWeaver fxWeaver(ConfigurableApplicationContext applicationContext) {
        return new SpringFxWeaver(applicationContext);
    }

    @Bean
    @ConditionalOnMissingBean(value={InjectionPointLazyFxControllerAndViewResolver.class})
    public InjectionPointLazyFxControllerAndViewResolver injectionPointLazyFxControllerAndViewResolver(FxWeaver fxWeaver) {
        return new InjectionPointLazyFxControllerAndViewResolver(fxWeaver);
    }

    @Bean
    @ConditionalOnMissingBean(value={FxControllerAndView.class})
    @Scope(value="prototype")
    public <C, V extends Node> FxControllerAndView<C, V> fxControllerAndView(InjectionPointLazyFxControllerAndViewResolver injectionPointLazyFxControllerAndViewResolver, InjectionPoint injectionPoint) {
        return injectionPointLazyFxControllerAndViewResolver.resolve(injectionPoint);
    }
}

