/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.commons.ip;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import net.ripe.commons.ip.AbstractIp;
import net.ripe.commons.ip.AbstractRange;
import net.ripe.commons.ip.InternetResourceRange;
import net.ripe.commons.ip.PrefixUtils;

public abstract class AbstractIpRange<C extends AbstractIp<C, R>, R extends AbstractIpRange<C, R>>
extends AbstractRange<C, R>
implements InternetResourceRange<C, R> {
    protected static final String SLASH = "/";
    protected static final String DASH = "-";
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    protected AbstractIpRange(C start, C end) {
        super(start, end);
    }

    @Override
    protected abstract R newInstance(BigInteger var1, BigInteger var2);

    @Override
    public String toString() {
        if (PrefixUtils.isLegalPrefix(this)) {
            return this.toStringInCidrNotation();
        }
        return this.toStringInRangeNotation();
    }

    public String toStringInRangeNotation() {
        return this.start() + DASH + this.end();
    }

    public String toStringInCidrNotation() {
        return this.start() + SLASH + PrefixUtils.getPrefixLength(this);
    }

    public String toStringInDecimalNotation() {
        return ((AbstractIp)this.start()).asBigInteger() + DASH + ((AbstractIp)this.end()).asBigInteger();
    }

    public List<R> splitToPrefixes() {
        BigInteger rangeEnd = ((AbstractIp)this.end()).asBigInteger();
        BigInteger currentRangeStart = ((AbstractIp)this.start()).asBigInteger();
        int startingPrefixLength = ((AbstractIp)this.start()).bitSize();
        LinkedList<R> prefixes = new LinkedList<R>();
        while (currentRangeStart.compareTo(rangeEnd) <= 0) {
            int maximumPrefixLength = this.getMaximumPrefixLengthStartingAtIpAddressValue(currentRangeStart, startingPrefixLength);
            BigInteger maximumSizeOfPrefix = rangeEnd.subtract(currentRangeStart).add(BigInteger.ONE);
            BigInteger currentSizeOfPrefix = TWO.pow(maximumPrefixLength);
            while (currentSizeOfPrefix.compareTo(maximumSizeOfPrefix) > 0 && maximumPrefixLength > 0) {
                currentSizeOfPrefix = TWO.pow(--maximumPrefixLength);
            }
            BigInteger currentRangeEnd = currentRangeStart.add(TWO.pow(maximumPrefixLength).subtract(BigInteger.ONE));
            prefixes.add(this.newInstance(currentRangeStart, currentRangeEnd));
            currentRangeStart = currentRangeEnd.add(BigInteger.ONE);
        }
        return prefixes;
    }

    private int getMaximumPrefixLengthStartingAtIpAddressValue(BigInteger ipAddressValue, int startingPrefixLength) {
        int prefixLength;
        for (prefixLength = startingPrefixLength; prefixLength >= 0 && !this.canBeDividedByThePowerOfTwo(ipAddressValue, prefixLength); --prefixLength) {
        }
        return prefixLength;
    }

    private boolean canBeDividedByThePowerOfTwo(BigInteger number, int power) {
        return number.remainder(TWO.pow(power)).equals(BigInteger.ZERO);
    }
}

