/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.commons.ip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.ripe.commons.ip.Range;
import net.ripe.commons.ip.Rangeable;
import net.ripe.commons.ip.Validate;

public abstract class AbstractRange<C extends Rangeable<C, R>, R extends Range<C, R>>
implements Range<C, R> {
    private final C start;
    private final C end;

    protected AbstractRange(C start, C end) {
        this.start = (Rangeable)Validate.notNull(start, "start of range must not be null");
        this.end = (Rangeable)Validate.notNull(end, "end of range must not be null");
        Validate.isTrue(this.start.compareTo(this.end) <= 0, "Invalid range [" + start + ".." + end + "]");
    }

    protected abstract R newInstance(C var1, C var2);

    @Override
    public C start() {
        return this.start;
    }

    @Override
    public C end() {
        return this.end;
    }

    @Override
    public boolean contains(R other) {
        return other != null && this.start.compareTo(other.start()) <= 0 && this.end.compareTo(other.end()) >= 0;
    }

    @Override
    public boolean contains(C value) {
        Validate.notNull(value, "A value is required");
        return this.start.compareTo(value) <= 0 && this.end.compareTo(value) >= 0;
    }

    @Override
    public boolean overlaps(R other) {
        return other != null && (other.contains(this.start) || other.contains(this.end) || this.contains((C)other));
    }

    @Override
    public boolean isConsecutive(R other) {
        if (other == null) {
            return false;
        }
        return this.end.hasNext() && this.end.next().equals(other.start()) || other.end().hasNext() && other.end().next().equals(this.start);
    }

    @Override
    public boolean isEmpty() {
        return this.end.equals(this.start);
    }

    @Override
    public R merge(R other) {
        Validate.isTrue(this.overlaps(other) || this.isConsecutive(other), "Merge is only possible for overlapping or consecutive ranges");
        C min = this.min(this.start, other.start());
        C max = this.max(this.end, other.end());
        return this.newInstance(min, max);
    }

    @Override
    public R intersection(R other) {
        C max = this.max(this.start, other.start());
        C min = this.min(this.end, other.end());
        return this.newInstance(max, min);
    }

    private C max(C a, C b) {
        return a.compareTo(b) >= 0 ? a : b;
    }

    private C min(C a, C b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    @Override
    public List<R> exclude(R other) {
        if (!this.overlaps(other)) {
            return Collections.singletonList(this);
        }
        if (other.contains((AbstractRange)this)) {
            return Collections.emptyList();
        }
        if (!this.contains((C)other.start()) && this.contains((C)other.end())) {
            return Collections.singletonList(this.newInstance(other.end().next(), this.end));
        }
        if (this.contains((C)other.start()) && !this.contains((C)other.end())) {
            return Collections.singletonList(this.newInstance(this.start, other.start().previous()));
        }
        if (this.hasSameStart(other)) {
            return Collections.singletonList(this.newInstance(other.end().next(), this.end));
        }
        if (this.hasSameEnd(other)) {
            return Collections.singletonList(this.newInstance(this.start, other.start().previous()));
        }
        ArrayList<R> rs = new ArrayList<R>(2);
        rs.add(this.newInstance(this.start, other.start().previous()));
        rs.add(this.newInstance(other.end().next(), this.end));
        return rs;
    }

    @Override
    public boolean isSameRange(R other) {
        return this.hasSameStart(other) && this.hasSameEnd(other);
    }

    private boolean hasSameStart(R other) {
        return this.start.equals(other.start());
    }

    private boolean hasSameEnd(R other) {
        return this.end.equals(other.end());
    }

    public String toString() {
        return "[" + this.start.toString() + ".." + this.end.toString() + "]";
    }

    @Override
    public Iterator<C> iterator() {
        return new RangeIterator();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRange)) {
            return false;
        }
        AbstractRange that = (AbstractRange)o;
        if (!this.start.equals(that.start)) {
            return false;
        }
        return this.end.equals(that.end);
    }

    public final int hashCode() {
        int result = this.start.hashCode();
        result = 31 * result + this.end.hashCode();
        return result;
    }

    protected static abstract class AbstractRangeBuilder<C extends Rangeable<C, R>, R extends AbstractRange<C, R>> {
        protected AbstractRangeBuilder() {
        }

        public abstract R to(C var1);
    }

    private class RangeIterator
    implements Iterator<C> {
        private C nextValue;

        private RangeIterator() {
            this.nextValue = AbstractRange.this.start;
        }

        @Override
        public boolean hasNext() {
            return this.nextValue.compareTo((Rangeable)AbstractRange.this.end) <= 0;
        }

        @Override
        public C next() {
            Object valueToReturn = this.nextValue;
            this.nextValue = valueToReturn.next();
            return valueToReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

