/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.ContentInfo;

public class RPKIContentInfo
extends ContentInfo {
    private ASN1ObjectIdentifier contentType;
    private ASN1Encodable content;

    public static RPKIContentInfo getInstance(Object obj) {
        if (obj instanceof RPKIContentInfo) {
            return (RPKIContentInfo)((Object)obj);
        }
        if (obj != null) {
            return RPKIContentInfo.getInstance(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public static RPKIContentInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return RPKIContentInfo.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public RPKIContentInfo(ASN1ObjectIdentifier contentType, ASN1Encodable content) {
        super(contentType, content);
        this.contentType = contentType;
        this.content = content;
    }

    public ASN1ObjectIdentifier getContentType() {
        return this.contentType;
    }

    public ASN1Encodable getContent() {
        return this.content;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.contentType);
        if (this.content != null) {
            v.add((ASN1Encodable)new DERTaggedObject(0, this.content));
        }
        return new DERSequence(v);
    }
}

