/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.ripe.rpki.commons.crypto.cms.CMSUtils;
import net.ripe.rpki.commons.crypto.cms.RPKIContentInfo;
import net.ripe.rpki.commons.crypto.cms.RPKISignedData;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;

public class RPKISignedDataGenerator
extends CMSSignedDataGenerator {
    public CMSSignedData generate(CMSTypedData content, boolean encapsulate) throws CMSException {
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        this.digests.clear();
        for (Object o : this._signers) {
            SignerInformation signer = (SignerInformation)o;
            digestAlgs.add((ASN1Encodable)CMSUtils.fixAlgID(signer.getDigestAlgorithmID()));
            if (!signer.getContentType().equals((ASN1Primitive)content.getContentType())) {
                throw new IllegalArgumentException("Precalculated signer info must match content type");
            }
            signerInfos.add((ASN1Encodable)signer.toASN1Structure());
        }
        ASN1ObjectIdentifier contentTypeOID = content.getContentType();
        DEROctetString octs = null;
        if (content.getContent() != null) {
            Object bOut = null;
            if (encapsulate) {
                bOut = new ByteArrayOutputStream();
            }
            OutputStream cOut = CMSUtils.attachSignersToOutputStream(this.signerGens, bOut);
            cOut = CMSUtils.getSafeOutputStream(cOut);
            try {
                content.write(cOut);
                cOut.close();
            }
            catch (IOException e) {
                throw new CMSException("data processing exception: " + e.getMessage(), (Exception)e);
            }
            if (encapsulate) {
                octs = new DEROctetString(((ByteArrayOutputStream)bOut).toByteArray());
            }
        }
        for (Object signerGen : this.signerGens) {
            SignerInfoGenerator sGen = (SignerInfoGenerator)signerGen;
            SignerInfo inf = sGen.generate(contentTypeOID);
            digestAlgs.add((ASN1Encodable)inf.getDigestAlgorithm());
            signerInfos.add((ASN1Encodable)inf);
            byte[] calcDigest = sGen.getCalculatedDigest();
            if (calcDigest == null) continue;
            this.digests.put(inf.getDigestAlgorithm().getAlgorithm().getId(), calcDigest);
        }
        ASN1Set certificates = null;
        if (!this.certs.isEmpty()) {
            certificates = CMSUtils.createDerSetFromList(this.certs);
        }
        ASN1Set certrevlist = null;
        if (!this.crls.isEmpty()) {
            certrevlist = CMSUtils.createDerSetFromList(this.crls);
        }
        ContentInfo encInfo = new ContentInfo(contentTypeOID, octs);
        RPKISignedData sd = new RPKISignedData((ASN1Set)new DERSet(digestAlgs), encInfo, certificates, certrevlist, (ASN1Set)new DERSet(signerInfos));
        RPKIContentInfo contentInfo = new RPKIContentInfo(CMSObjectIdentifiers.signedData, (ASN1Encodable)sd);
        return new CMSSignedData((CMSProcessable)content, (ContentInfo)contentInfo);
    }
}

