/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms;

import java.util.Optional;
import java.util.function.Function;
import net.ripe.rpki.commons.util.UTC;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.cms.SignerInformation;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public class SigningInformationUtil {
    public static SigningTimeResult extractSigningTime(ValidationResult validationResult, SignerInformation signer) {
        boolean valid;
        ImmutablePair<DateTime, Boolean> signingTime = SigningInformationUtil.extractTime(validationResult, CMSAttributes.signingTime, "cms.only.one.signing.time.attr", signer, attrValue -> UTC.dateTime(Time.getInstance((Object)attrValue).getDate().getTime()));
        ImmutablePair<DateTime, Boolean> binarySigningTime = SigningInformationUtil.extractTime(validationResult, CMSAttributes.binarySigningTime, "cms.only.one.binary.signing.time.attr", signer, attrValue -> UTC.dateTime(Instant.ofEpochSecond((long)ASN1Integer.getInstance((Object)attrValue).getValue().longValueExact())));
        boolean bl = valid = (Boolean)signingTime.right != false && (Boolean)binarySigningTime.right != false;
        if (signingTime.left != null && binarySigningTime.left != null) {
            boolean bl2 = valid = validationResult.rejectIfFalse(((DateTime)signingTime.left).equals(binarySigningTime.left), "cms.signing.time.must.equal.binary.signing.time") && valid;
        }
        if (valid) {
            return new SigningTimeResult(signingTime.left != null ? (DateTime)signingTime.left : (DateTime)binarySigningTime.left);
        }
        return new SigningTimeResult(valid);
    }

    private static ImmutablePair<DateTime, Boolean> extractTime(ValidationResult validationResult, ASN1ObjectIdentifier identifier, String onlyOneValidationKey, SignerInformation signer, Function<ASN1Encodable, DateTime> timeExtractor) {
        ASN1EncodableVector signingTimeAttributes = signer.getSignedAttributes().getAll(identifier);
        if (signingTimeAttributes.size() == 0) {
            return ImmutablePair.of(null, (Object)true);
        }
        if (!validationResult.rejectIfFalse(signingTimeAttributes.size() == 1, onlyOneValidationKey)) {
            return ImmutablePair.of(null, (Object)false);
        }
        ASN1Encodable[] signingTimeValues = Attribute.getInstance((Object)signingTimeAttributes.get(0)).getAttributeValues();
        if (!validationResult.rejectIfFalse(signingTimeValues.length == 1, "cms.signing.time.attr.one.value")) {
            return ImmutablePair.of(null, (Object)false);
        }
        return ImmutablePair.of((Object)timeExtractor.apply(signingTimeValues[0]), (Object)true);
    }

    private SigningInformationUtil() {
    }

    public static class SigningTimeResult {
        public final Optional<DateTime> optionalSigningTime;
        public final boolean valid;

        public SigningTimeResult(boolean valid) {
            this.valid = valid;
            this.optionalSigningTime = Optional.empty();
        }

        public SigningTimeResult(DateTime signingTime) {
            this.optionalSigningTime = Optional.ofNullable(signingTime);
            this.valid = true;
        }

        public Optional<DateTime> getOptionalSigningTime() {
            return this.optionalSigningTime;
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SigningTimeResult)) {
                return false;
            }
            SigningTimeResult other = (SigningTimeResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isValid() != other.isValid()) {
                return false;
            }
            Optional<DateTime> this$optionalSigningTime = this.getOptionalSigningTime();
            Optional<DateTime> other$optionalSigningTime = other.getOptionalSigningTime();
            return !(this$optionalSigningTime == null ? other$optionalSigningTime != null : !((Object)this$optionalSigningTime).equals(other$optionalSigningTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SigningTimeResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValid() ? 79 : 97);
            Optional<DateTime> $optionalSigningTime = this.getOptionalSigningTime();
            result = result * 59 + ($optionalSigningTime == null ? 43 : ((Object)$optionalSigningTime).hashCode());
            return result;
        }

        public String toString() {
            return "SigningInformationUtil.SigningTimeResult(optionalSigningTime=" + this.getOptionalSigningTime() + ", valid=" + this.isValid() + ")";
        }
    }
}

