/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.cms.aspa;

import java.util.SortedSet;
import lombok.NonNull;
import net.ripe.ipresource.Asn;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObject;
import net.ripe.rpki.commons.crypto.cms.RpkiSignedObjectInfo;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;

public final class AspaCms
extends RpkiSignedObject {
    public static final ASN1ObjectIdentifier CONTENT_TYPE = new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.1.49");
    private final int version;
    @NonNull
    private final Asn customerAsn;
    @NonNull
    private final SortedSet<Asn> providerASSet;

    public AspaCms(RpkiSignedObjectInfo cmsObjectData, int version, Asn customerAsn, SortedSet<Asn> providerASSet) {
        super(cmsObjectData);
        Validate.isTrue((version == 1 ? 1 : 0) != 0, (String)"version must be 1", (Object[])new Object[0]);
        this.version = version;
        this.customerAsn = customerAsn;
        this.providerASSet = providerASSet;
    }

    public int getVersion() {
        return this.version;
    }

    @NonNull
    public Asn getCustomerAsn() {
        return this.customerAsn;
    }

    @NonNull
    public SortedSet<Asn> getProviderASSet() {
        return this.providerASSet;
    }

    public String toString() {
        return "AspaCms(version=" + this.getVersion() + ", customerAsn=" + this.getCustomerAsn() + ", providerASSet=" + this.getProviderASSet() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspaCms)) {
            return false;
        }
        AspaCms other = (AspaCms)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        Asn this$customerAsn = this.getCustomerAsn();
        Asn other$customerAsn = other.getCustomerAsn();
        if (this$customerAsn == null ? other$customerAsn != null : !this$customerAsn.equals(other$customerAsn)) {
            return false;
        }
        SortedSet<Asn> this$providerASSet = this.getProviderASSet();
        SortedSet<Asn> other$providerASSet = other.getProviderASSet();
        return !(this$providerASSet == null ? other$providerASSet != null : !this$providerASSet.equals(other$providerASSet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AspaCms;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getVersion();
        Asn $customerAsn = this.getCustomerAsn();
        result = result * 59 + ($customerAsn == null ? 43 : $customerAsn.hashCode());
        SortedSet<Asn> $providerASSet = this.getProviderASSet();
        result = result * 59 + ($providerASSet == null ? 43 : $providerASSet.hashCode());
        return result;
    }
}

