/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.rfc3779;

import java.io.Serializable;
import java.util.Objects;
import net.ripe.ipresource.IpResourceType;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DEROctetString;

public final class AddressFamily
implements Comparable<AddressFamily>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int BYTE_MASK = 255;
    private static final int AFI_MIN = 0;
    private static final int AFI_MAX = 65535;
    private static final int SAFI_MIN = 0;
    private static final int SAFI_MAX = 255;
    private static final int AFI_IPV4 = 1;
    private static final int AFI_IPV6 = 2;
    public static final AddressFamily IPV4 = new AddressFamily(1);
    public static final AddressFamily IPV6 = new AddressFamily(2);
    private static final int AFI_OCTET_COUNT_WITHOUT_SAFI = 2;
    private static final int AFI_OCTET_COUNT_WITH_SAFI = 3;
    private final int addressFamilyIdentifier;
    private final Integer subsequentAddressFamilyIdentifier;

    public AddressFamily(int addressFamilyIdentifier) {
        this(addressFamilyIdentifier, null);
    }

    public AddressFamily(int addressFamilyIdentifier, Integer subsequentAddressFamilyIdentifier) {
        Validate.isTrue((addressFamilyIdentifier >= 0 && addressFamilyIdentifier <= 65535 ? 1 : 0) != 0, (String)("addressFamilyIdentifier out of bounds: " + addressFamilyIdentifier), (Object[])new Object[0]);
        Validate.isTrue((subsequentAddressFamilyIdentifier == null || subsequentAddressFamilyIdentifier >= 0 && subsequentAddressFamilyIdentifier <= 255 ? 1 : 0) != 0, (String)("subsequentAddressFamilyIdentifier out of bounds: " + subsequentAddressFamilyIdentifier), (Object[])new Object[0]);
        this.addressFamilyIdentifier = addressFamilyIdentifier;
        this.subsequentAddressFamilyIdentifier = subsequentAddressFamilyIdentifier;
    }

    public AddressFamily withoutSubsequentAddressFamilyIdentifier() {
        return new AddressFamily(this.getAddressFamilyIdentifier());
    }

    public AddressFamily withSubsequentAddressFamilyIdentifier(Integer subsequentAddressFamilyIdentifier) {
        return new AddressFamily(this.getAddressFamilyIdentifier(), subsequentAddressFamilyIdentifier);
    }

    public boolean hasSubsequentAddressFamilyIdentifier() {
        return this.subsequentAddressFamilyIdentifier != null;
    }

    @Override
    public int compareTo(AddressFamily that) {
        int rc = this.getAddressFamilyIdentifier() - that.getAddressFamilyIdentifier();
        if (rc != 0) {
            return rc;
        }
        if (Objects.equals(this.getSubsequentAddressFamilyIdentifier(), that.getSubsequentAddressFamilyIdentifier())) {
            return 0;
        }
        if (this.getSubsequentAddressFamilyIdentifier() == null) {
            return -1;
        }
        if (that.getSubsequentAddressFamilyIdentifier() == null) {
            return 1;
        }
        return this.getSubsequentAddressFamilyIdentifier() - that.getSubsequentAddressFamilyIdentifier();
    }

    public DEROctetString toDer() {
        int length = this.hasSubsequentAddressFamilyIdentifier() ? 3 : 2;
        byte[] encoded = new byte[length];
        encoded[0] = (byte)(this.addressFamilyIdentifier >> 8);
        encoded[1] = (byte)this.addressFamilyIdentifier;
        if (this.hasSubsequentAddressFamilyIdentifier()) {
            encoded[2] = this.subsequentAddressFamilyIdentifier.byteValue();
        }
        return new DEROctetString(encoded);
    }

    public static AddressFamily fromDer(ASN1Encodable der) {
        AddressFamily addressFamily;
        Validate.isTrue((boolean)(der instanceof DEROctetString), (String)"DEROctetString expected", (Object[])new Object[0]);
        DEROctetString derOctetString = (DEROctetString)der;
        byte[] bytes = derOctetString.getOctets();
        Validate.isTrue((bytes.length == 2 || bytes.length == 3 ? 1 : 0) != 0, (String)"Byte array must consist of 2 or 3 elements", (Object[])new Object[0]);
        int thisAddressFamilyIdentifier = AddressFamily.unsignedByteToInt(bytes[0]) << 8 | AddressFamily.unsignedByteToInt(bytes[1]);
        if (bytes.length == 2) {
            addressFamily = new AddressFamily(thisAddressFamilyIdentifier);
        } else {
            int thisSafi = AddressFamily.unsignedByteToInt(bytes[2]);
            addressFamily = new AddressFamily(thisAddressFamilyIdentifier, thisSafi);
        }
        return addressFamily;
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static AddressFamily fromIpResourceType(IpResourceType type) {
        switch (type) {
            case IPv4: {
                return IPV4;
            }
            case IPv6: {
                return IPV6;
            }
        }
        throw new IllegalArgumentException("no address family for type: " + type);
    }

    public IpResourceType toIpResourceType() {
        switch (this.addressFamilyIdentifier) {
            case 1: {
                return IpResourceType.IPv4;
            }
            case 2: {
                return IpResourceType.IPv6;
            }
        }
        throw new IllegalStateException("no IP resource type for AFI: " + this.addressFamilyIdentifier);
    }

    public int getAddressFamilyIdentifier() {
        return this.addressFamilyIdentifier;
    }

    public Integer getSubsequentAddressFamilyIdentifier() {
        return this.subsequentAddressFamilyIdentifier;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddressFamily)) {
            return false;
        }
        AddressFamily other = (AddressFamily)o;
        if (this.getAddressFamilyIdentifier() != other.getAddressFamilyIdentifier()) {
            return false;
        }
        Integer this$subsequentAddressFamilyIdentifier = this.getSubsequentAddressFamilyIdentifier();
        Integer other$subsequentAddressFamilyIdentifier = other.getSubsequentAddressFamilyIdentifier();
        return !(this$subsequentAddressFamilyIdentifier == null ? other$subsequentAddressFamilyIdentifier != null : !((Object)this$subsequentAddressFamilyIdentifier).equals(other$subsequentAddressFamilyIdentifier));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAddressFamilyIdentifier();
        Integer $subsequentAddressFamilyIdentifier = this.getSubsequentAddressFamilyIdentifier();
        result = result * 59 + ($subsequentAddressFamilyIdentifier == null ? 43 : ((Object)$subsequentAddressFamilyIdentifier).hashCode());
        return result;
    }

    public String toString() {
        return "AddressFamily(addressFamilyIdentifier=" + this.getAddressFamilyIdentifier() + ", subsequentAddressFamilyIdentifier=" + this.getSubsequentAddressFamilyIdentifier() + ")";
    }
}

