/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.UnknownCertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCms;
import net.ripe.rpki.commons.crypto.cms.aspa.AspaCmsParser;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCmsParser;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCmsParser;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCmsParser;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509GenericCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import net.ripe.rpki.commons.validation.ValidationChecks;
import net.ripe.rpki.commons.validation.ValidationResult;

public final class CertificateRepositoryObjectFactory {
    private CertificateRepositoryObjectFactory() {
    }

    public static CertificateRepositoryObject createCertificateRepositoryObject(byte[] encoded, ValidationResult validationResult) {
        RepositoryObjectType objectType = RepositoryObjectType.parse(validationResult.getCurrentLocation().getName());
        ValidationChecks.knownObjectType(objectType, validationResult);
        switch (objectType) {
            case Manifest: {
                return CertificateRepositoryObjectFactory.parseManifest(encoded, validationResult);
            }
            case Roa: {
                return CertificateRepositoryObjectFactory.parseRoa(encoded, validationResult);
            }
            case Certificate: {
                return CertificateRepositoryObjectFactory.parseX509Certificate(encoded, validationResult);
            }
            case Crl: {
                return CertificateRepositoryObjectFactory.parseCrl(encoded, validationResult);
            }
            case Gbr: {
                return CertificateRepositoryObjectFactory.parseGbr(encoded, validationResult);
            }
            case Aspa: {
                return CertificateRepositoryObjectFactory.parseAspa(encoded, validationResult);
            }
            case Unknown: {
                return new UnknownCertificateRepositoryObject(encoded);
            }
        }
        throw new IllegalArgumentException("Unrecognized repository object type: " + objectType);
    }

    private static X509Crl parseCrl(byte[] encoded, ValidationResult validationResult) {
        return X509Crl.parseDerEncoded(encoded, validationResult);
    }

    private static X509GenericCertificate parseX509Certificate(byte[] encoded, ValidationResult validationResult) {
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        X509GenericCertificate cert = X509ResourceCertificateParser.parseCertificate(temp, encoded);
        validationResult.addAll(temp);
        return cert;
    }

    private static RoaCms parseRoa(byte[] encoded, ValidationResult validationResult) {
        RoaCmsParser parser = new RoaCmsParser();
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        parser.parse(temp, encoded);
        validationResult.addAll(temp);
        if (parser.isSuccess()) {
            return parser.getRoaCms();
        }
        return null;
    }

    private static ManifestCms parseManifest(byte[] encoded, ValidationResult validationResult) {
        ManifestCmsParser parser = new ManifestCmsParser();
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        parser.parse(temp, encoded);
        validationResult.addAll(temp);
        if (parser.isSuccess()) {
            return parser.getManifestCms();
        }
        return null;
    }

    private static GhostbustersCms parseGbr(byte[] encoded, ValidationResult validationResult) {
        GhostbustersCmsParser parser = new GhostbustersCmsParser();
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        parser.parse(temp, encoded);
        validationResult.addAll(temp);
        if (parser.isSuccess()) {
            return parser.getGhostbustersCms();
        }
        return null;
    }

    private static AspaCms parseAspa(byte[] encoded, ValidationResult validationResult) {
        AspaCmsParser parser = new AspaCmsParser();
        ValidationResult temp = ValidationResult.withLocation(validationResult.getCurrentLocation());
        parser.parse(temp, encoded);
        validationResult.addAll(temp);
        if (parser.isSuccess()) {
            return parser.getAspa();
        }
        return null;
    }
}

