/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.util;

import java.net.URI;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import net.ripe.rpki.commons.crypto.cms.GenericRpkiSignedObjectParser;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import net.ripe.rpki.commons.validation.ValidationResult;
import org.joda.time.DateTime;
import org.joda.time.Instant;

public final class SignedObjectUtil {
    public static Instant getFileCreationTime(URI uri, byte[] decoded) throws NoTimeParsedException {
        RepositoryObjectType objectType = RepositoryObjectType.parse(uri.toString());
        try {
            switch (objectType) {
                case Manifest: 
                case Aspa: 
                case Roa: 
                case Gbr: {
                    GenericRpkiSignedObjectParser signedObjectParser = new GenericRpkiSignedObjectParser();
                    signedObjectParser.parse(ValidationResult.withLocation(uri), decoded);
                    DateTime signingTime = signedObjectParser.getSigningTime();
                    if (signingTime == null) {
                        return signedObjectParser.getCertificate().getValidityPeriod().getNotValidBefore().toInstant();
                    }
                    return signingTime.toInstant();
                }
                case Certificate: {
                    X509ResourceCertificateParser x509CertificateParser = new X509ResourceCertificateParser();
                    x509CertificateParser.parse(ValidationResult.withLocation(uri), decoded);
                    X509Certificate cert = x509CertificateParser.getCertificate().getCertificate();
                    return Instant.ofEpochMilli((long)cert.getNotBefore().getTime());
                }
                case Crl: {
                    X509Crl x509Crl = X509Crl.parseDerEncoded(decoded, ValidationResult.withLocation(uri));
                    X509CRL crl = x509Crl.getCrl();
                    return Instant.ofEpochMilli((long)crl.getThisUpdate().getTime());
                }
            }
            throw new NoTimeParsedException(decoded, uri, "Could not determine file type");
        }
        catch (Exception e) {
            if (e instanceof NoTimeParsedException) {
                throw e;
            }
            throw new NoTimeParsedException(decoded, uri, "Could not parse object", e);
        }
    }

    private SignedObjectUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class NoTimeParsedException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private byte[] decoded;
        private URI uri;

        public NoTimeParsedException(byte[] decoded, URI uri, String message) {
            super(uri.toString() + ": " + message);
            this.decoded = decoded;
            this.uri = uri;
        }

        public NoTimeParsedException(byte[] decoded, URI uri, String message, Throwable cause) {
            super(uri.toString() + ": " + message, cause);
            this.decoded = decoded;
            this.uri = uri;
        }

        public byte[] getDecoded() {
            return this.decoded;
        }

        public URI getUri() {
            return this.uri;
        }
    }
}

