/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.net.URI;
import net.ripe.rpki.commons.crypto.x509cert.GenericRpkiCertificateBuilder;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateBuilder;
import org.apache.commons.lang3.Validate;

public class RpkiCaCertificateBuilder
extends GenericRpkiCertificateBuilder {
    private URI caRepositoryUri;
    private URI manifestUri;

    public void withCaRepositoryUri(URI caRepositoryUri) {
        this.validateIsRsyncUri(caRepositoryUri);
        this.caRepositoryUri = caRepositoryUri;
    }

    public void withManifestUri(URI manifestUri) {
        this.validateIsRsyncUri(manifestUri);
        this.manifestUri = manifestUri;
    }

    public X509ResourceCertificate build() {
        this.validateFields();
        X509ResourceCertificateBuilder builder = this.createGenericRpkiCertificateBuilder(6);
        builder.withCa(true);
        builder.withAuthorityKeyIdentifier(true);
        X509CertificateInformationAccessDescriptor[] descriptors = new X509CertificateInformationAccessDescriptor[]{new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_CA_REPOSITORY, this.caRepositoryUri), new X509CertificateInformationAccessDescriptor(X509CertificateInformationAccessDescriptor.ID_AD_RPKI_MANIFEST, this.manifestUri)};
        builder.withSubjectInformationAccess(descriptors);
        return builder.build();
    }

    @Override
    protected void validateFields() {
        super.validateFields();
        Validate.notNull((Object)this.caRepositoryUri, (String)"CA Repository URI is required", (Object[])new Object[0]);
        Validate.notNull((Object)this.manifestUri, (String)"Manifest URI is required", (Object[])new Object[0]);
    }
}

