/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.net.URI;
import java.security.cert.X509Certificate;
import net.ripe.rpki.commons.crypto.crl.CrlLocator;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateObject;
import net.ripe.rpki.commons.crypto.x509cert.X509GenericCertificate;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationOptions;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.commons.validation.objectvalidators.X509RouterCertificateValidator;

public class X509RouterCertificate
extends X509GenericCertificate
implements X509CertificateObject {
    private Boolean revoked;

    protected X509RouterCertificate(X509Certificate certificate) {
        super(certificate);
    }

    @Override
    public URI getCrlUri() {
        return this.findFirstRsyncCrlDistributionPoint();
    }

    @Override
    public URI getParentCertificateUri() {
        return this.findFirstAuthorityInformationAccessByMethod(X509CertificateInformationAccessDescriptor.ID_CA_CA_ISSUERS);
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, CrlLocator crlLocator, ValidationOptions options, ValidationResult result) {
        ValidationLocation savedCurrentLocation = result.getCurrentLocation();
        result.setLocation(new ValidationLocation(this.getCrlUri()));
        result.setLocation(savedCurrentLocation);
        X509Crl crl = crlLocator.getCrl(this.getCrlUri(), context, result);
        if (crl == null) {
            result.rejectIfFalse(false, "objects.crl.valid", this.getCrlUri().toString());
            return;
        }
        X509RouterCertificateValidator validator = new X509RouterCertificateValidator(options, result, context.getRouterCertificate(), crl);
        validator.validate(location, this);
        this.revoked = this.hasErrorInRevocationCheck(result.getFailures(new ValidationLocation(location)));
    }

    @Override
    public void validate(String location, CertificateRepositoryObjectValidationContext context, X509Crl crl, URI crlUri, ValidationOptions options, ValidationResult result) {
        if (!this.isRoot() && crl == null) {
            result.rejectIfFalse(false, "objects.crl.valid", crlUri.toString());
            return;
        }
        X509RouterCertificateValidator validator = new X509RouterCertificateValidator(options, result, context.getRouterCertificate(), crl);
        validator.validate(location, this);
        this.revoked = this.hasErrorInRevocationCheck(result.getFailures(new ValidationLocation(location)));
    }

    @Override
    public boolean isPastValidityTime() {
        return this.getValidityPeriod().isExpiredNow();
    }

    @Override
    public boolean isRevoked() {
        if (this.revoked == null) {
            throw new IllegalStateException("isRevoked() could only be called after validate()");
        }
        return this.revoked;
    }
}

