/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.crypto.x509cert;

import java.math.BigInteger;
import java.net.URI;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.EnumSet;
import javax.security.auth.x500.X500Principal;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateBuilderHelper;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.asn1.x509.PolicyInformation;

public class X509RouterCertificateBuilder {
    private X509CertificateBuilderHelper builderHelper = new X509CertificateBuilderHelper();
    private int[] asns;

    public X509RouterCertificateBuilder() {
        this.builderHelper.withPolicies(X509ResourceCertificate.POLICY_INFORMATION);
    }

    public X509RouterCertificateBuilder withSignatureProvider(String signatureProvider) {
        this.builderHelper.withSignatureProvider(signatureProvider);
        return this;
    }

    public X509RouterCertificateBuilder withSerial(BigInteger serial) {
        this.builderHelper.withSerial(serial);
        return this;
    }

    public X509RouterCertificateBuilder withSubjectDN(X500Principal subjectDN) {
        this.builderHelper.withSubjectDN(subjectDN);
        return this;
    }

    public X509RouterCertificateBuilder withIssuerDN(X500Principal issuerDN) {
        this.builderHelper.withIssuerDN(issuerDN);
        return this;
    }

    public X509RouterCertificateBuilder withValidityPeriod(ValidityPeriod validityPeriod) {
        this.builderHelper.withValidityPeriod(validityPeriod);
        return this;
    }

    public X509RouterCertificateBuilder withPublicKey(PublicKey publicKey) {
        this.builderHelper.withPublicKey(publicKey);
        return this;
    }

    public X509RouterCertificateBuilder withSigningKeyPair(KeyPair signingKey) {
        this.builderHelper.withSigningKeyPair(signingKey);
        return this;
    }

    public X509RouterCertificateBuilder withKeyUsage(int keyUsage) {
        this.builderHelper.withKeyUsage(keyUsage);
        return this;
    }

    public X509RouterCertificateBuilder withAsns(int[] asns) {
        this.asns = asns;
        if (asns != null) {
            IpResourceSet resources = new IpResourceSet();
            for (int asn : asns) {
                resources.add((IpResource)new Asn((long)asn));
            }
            this.builderHelper.withResources(resources);
        }
        return this;
    }

    public X509RouterCertificateBuilder withCa(boolean ca) {
        this.builderHelper.withCa(ca);
        return this;
    }

    public X509RouterCertificateBuilder withAuthorityKeyIdentifier(boolean add) {
        this.builderHelper.withAuthorityKeyIdentifier(add);
        return this;
    }

    public X509RouterCertificateBuilder withCrlDistributionPoints(URI ... uris) {
        this.builderHelper.withCrlDistributionPoints(uris);
        return this;
    }

    public X509RouterCertificateBuilder withAuthorityInformationAccess(X509CertificateInformationAccessDescriptor ... descriptors) {
        this.builderHelper.withAuthorityInformationAccess(descriptors);
        return this;
    }

    public X509RouterCertificateBuilder withSubjectInformationAccess(X509CertificateInformationAccessDescriptor ... descriptors) {
        this.builderHelper.withSubjectInformationAccess(descriptors);
        return this;
    }

    public X509RouterCertificateBuilder withPolicies(PolicyInformation ... policies) {
        this.builderHelper.withPolicies(policies);
        return this;
    }

    public X509RouterCertificate build() {
        Validate.notNull((Object)this.asns, (String)"no AS resources", (Object[])new Object[0]);
        Validate.isTrue((this.asns.length > 0 ? 1 : 0) != 0, (String)"empty AS resources", (Object[])new Object[0]);
        this.builderHelper.withRouter(true);
        return new X509RouterCertificate(this.builderHelper.generateCertificate());
    }

    public X509RouterCertificateBuilder withInheritedResourceTypes(EnumSet<IpResourceType> resourceTypes) {
        this.builderHelper.withInheritedResourceTypes(resourceTypes);
        return this;
    }
}

