/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.identity;

import java.io.IOException;
import java.io.StringReader;
import java.util.Base64;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.ripe.rpki.commons.provisioning.identity.IdentitySerializer;
import net.ripe.rpki.commons.provisioning.identity.PublisherRequest;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;
import net.ripe.rpki.commons.util.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PublisherRequestSerializer
extends IdentitySerializer<PublisherRequest> {
    private static final Base64.Encoder AUTHORIZATION_TOKEN_ENCODER = Base64.getEncoder();
    private static final Base64.Decoder AUTHORIZATION_TOKEN_DECODER = Base64.getDecoder();

    @Override
    public PublisherRequest deserialize(String xml) {
        StringReader characterStream = new StringReader(xml);
        try {
            Document doc = XML.newNamespaceAwareDocumentBuilder().parse(new InputSource(characterStream));
            Element root = this.getElement(doc, "publisher_request").orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("publisher_request element not found"));
            this.getAttributeValue(root, "version").filter(v -> "1".equals(v)).orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("version is not supported"));
            Optional<String> tag = this.getAttributeValue(root, "tag");
            String publisherHandle = this.getRequiredAttributeValue(root, "publisher_handle");
            ProvisioningIdentityCertificate publisherBpkiTa = this.getBpkiElementContent(doc, "publisher_bpki_ta").map(bpkiTa -> this.getProvisioningIdentityCertificate((String)bpkiTa)).orElseThrow(() -> new IdentitySerializer.IdentitySerializerException("publisher_bpki_ta element not found"));
            Optional<PublisherRequest.Referral> referral = this.getOptionalSingleChildElement(root, "referral").map(element -> new PublisherRequest.Referral(this.getRequiredAttributeValue((Element)element, "referrer"), AUTHORIZATION_TOKEN_DECODER.decode(this.getElementTextContent((Element)element))));
            PublisherRequest publisherRequest = new PublisherRequest(tag, publisherHandle, publisherBpkiTa, referral);
            characterStream.close();
            return publisherRequest;
        }
        catch (Throwable throwable) {
            try {
                try {
                    characterStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | IllegalArgumentException | ParserConfigurationException | SAXException e) {
                throw new IdentitySerializer.IdentitySerializerException("Failed to parse publisher request", e);
            }
        }
    }

    @Override
    public String serialize(PublisherRequest publisherRequest) {
        try {
            Document document = XML.newNamespaceAwareDocumentBuilder().newDocument();
            Element requestElement = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "publisher_request");
            requestElement.setAttribute("version", Integer.toString(publisherRequest.getVersion()));
            publisherRequest.getTag().ifPresent(tag -> requestElement.setAttribute("tag", (String)tag));
            requestElement.setAttribute("publisher_handle", publisherRequest.getPublisherHandle());
            Element bpkiTaElement = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "publisher_bpki_ta");
            bpkiTaElement.setTextContent(publisherRequest.getPublisherBpkiTa().getBase64String());
            Optional<Element> referralElement = publisherRequest.getReferral().map(referral -> {
                Element result = document.createElementNS("http://www.hactrn.net/uris/rpki/rpki-setup/", "referral");
                result.setAttribute("referrer", referral.getReferrer());
                result.setTextContent(AUTHORIZATION_TOKEN_ENCODER.encodeToString(referral.getAuthorizationToken()));
                return result;
            });
            requestElement.appendChild(bpkiTaElement);
            document.appendChild(requestElement);
            referralElement.ifPresent(document::appendChild);
            return this.serialize(document);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new IdentitySerializer.IdentitySerializerException(e);
        }
    }
}

