/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.identity;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import net.ripe.rpki.commons.provisioning.x509.ProvisioningIdentityCertificate;

public final class RepositoryResponse {
    public static final int VERSION = 1;
    private final Optional<String> tag;
    private final URI serviceUri;
    private final String publisherHandle;
    private final URI siaBase;
    private final Optional<URI> rrdpNotificationUri;
    private final ProvisioningIdentityCertificate repositoryBpkiTa;

    public RepositoryResponse(Optional<String> tag, URI serviceUri, String publisherHandle, URI siaBase, Optional<URI> rrdpNotificationUri, ProvisioningIdentityCertificate repositoryBpkiTa) {
        this.tag = Objects.requireNonNull(tag, "tag must not be null");
        this.serviceUri = Objects.requireNonNull(serviceUri, "serviceUri must not be null");
        this.publisherHandle = Objects.requireNonNull(publisherHandle, "publisherHandle must not be null");
        this.siaBase = Objects.requireNonNull(siaBase, "siaBase must not be null");
        this.rrdpNotificationUri = Objects.requireNonNull(rrdpNotificationUri, "rrdpNotificationUri must not be null");
        this.repositoryBpkiTa = Objects.requireNonNull(repositoryBpkiTa, "repositoryBpkiTa must not be null");
    }

    public int getVersion() {
        return 1;
    }

    public Optional<String> getTag() {
        return this.tag;
    }

    public URI getServiceUri() {
        return this.serviceUri;
    }

    public String getPublisherHandle() {
        return this.publisherHandle;
    }

    public URI getSiaBase() {
        return this.siaBase;
    }

    public Optional<URI> getRrdpNotificationUri() {
        return this.rrdpNotificationUri;
    }

    public ProvisioningIdentityCertificate getRepositoryBpkiTa() {
        return this.repositoryBpkiTa;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RepositoryResponse)) {
            return false;
        }
        RepositoryResponse other = (RepositoryResponse)o;
        Optional<String> this$tag = this.getTag();
        Optional<String> other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        URI this$serviceUri = this.getServiceUri();
        URI other$serviceUri = other.getServiceUri();
        if (this$serviceUri == null ? other$serviceUri != null : !((Object)this$serviceUri).equals(other$serviceUri)) {
            return false;
        }
        String this$publisherHandle = this.getPublisherHandle();
        String other$publisherHandle = other.getPublisherHandle();
        if (this$publisherHandle == null ? other$publisherHandle != null : !this$publisherHandle.equals(other$publisherHandle)) {
            return false;
        }
        URI this$siaBase = this.getSiaBase();
        URI other$siaBase = other.getSiaBase();
        if (this$siaBase == null ? other$siaBase != null : !((Object)this$siaBase).equals(other$siaBase)) {
            return false;
        }
        Optional<URI> this$rrdpNotificationUri = this.getRrdpNotificationUri();
        Optional<URI> other$rrdpNotificationUri = other.getRrdpNotificationUri();
        if (this$rrdpNotificationUri == null ? other$rrdpNotificationUri != null : !((Object)this$rrdpNotificationUri).equals(other$rrdpNotificationUri)) {
            return false;
        }
        ProvisioningIdentityCertificate this$repositoryBpkiTa = this.getRepositoryBpkiTa();
        ProvisioningIdentityCertificate other$repositoryBpkiTa = other.getRepositoryBpkiTa();
        return !(this$repositoryBpkiTa == null ? other$repositoryBpkiTa != null : !((Object)this$repositoryBpkiTa).equals(other$repositoryBpkiTa));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        URI $serviceUri = this.getServiceUri();
        result = result * 59 + ($serviceUri == null ? 43 : ((Object)$serviceUri).hashCode());
        String $publisherHandle = this.getPublisherHandle();
        result = result * 59 + ($publisherHandle == null ? 43 : $publisherHandle.hashCode());
        URI $siaBase = this.getSiaBase();
        result = result * 59 + ($siaBase == null ? 43 : ((Object)$siaBase).hashCode());
        Optional<URI> $rrdpNotificationUri = this.getRrdpNotificationUri();
        result = result * 59 + ($rrdpNotificationUri == null ? 43 : ((Object)$rrdpNotificationUri).hashCode());
        ProvisioningIdentityCertificate $repositoryBpkiTa = this.getRepositoryBpkiTa();
        result = result * 59 + ($repositoryBpkiTa == null ? 43 : ((Object)$repositoryBpkiTa).hashCode());
        return result;
    }

    public String toString() {
        return "RepositoryResponse(tag=" + this.getTag() + ", serviceUri=" + this.getServiceUri() + ", publisherHandle=" + this.getPublisherHandle() + ", siaBase=" + this.getSiaBase() + ", rrdpNotificationUri=" + this.getRrdpNotificationUri() + ", repositoryBpkiTa=" + this.getRepositoryBpkiTa() + ")";
    }
}

