/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.util.Base64;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.ripe.rpki.commons.crypto.x509cert.X509GenericCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.provisioning.payload.PayloadMessageType;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElement;
import net.ripe.rpki.commons.provisioning.payload.common.GenericClassElement;
import net.ripe.rpki.commons.provisioning.serialization.CertificateUrlListConverter;
import net.ripe.rpki.commons.provisioning.serialization.IpResourceSetProvisioningConverter;
import net.ripe.rpki.commons.util.XML;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.xml.DomXmlSerializer;
import net.ripe.rpki.commons.xml.DomXmlSerializerException;
import net.ripe.rpki.commons.xml.converters.DateTimeConverter;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractProvisioningPayloadXmlSerializer<T extends AbstractProvisioningPayload>
extends DomXmlSerializer<T> {
    private static final String XMLNS = "http://www.apnic.net/specs/rescerts/up-down/";
    private static final Base64.Decoder BASE64_DECODER = Base64.getMimeDecoder();
    protected static final IpResourceSetProvisioningConverter IP_RESOURCE_SET_PROVISIONING_CONVERTER = IpResourceSetProvisioningConverter.INSTANCE;
    protected static final CertificateUrlListConverter CERTIFICATE_URL_LIST_CONVERTER = CertificateUrlListConverter.INSTANCE;
    protected static final DateTimeConverter DATE_TIME_CONVERTER = new DateTimeConverter();
    private final PayloadMessageType type;

    protected AbstractProvisioningPayloadXmlSerializer(PayloadMessageType type) {
        super(XMLNS);
        this.type = type;
    }

    protected abstract T parseXmlPayload(Element var1) throws IOException;

    protected abstract Iterable<? extends Node> generateXmlPayload(Document var1, T var2) throws IOException;

    protected X509ResourceCertificate parseX509ResourceCertificate(String base64) {
        ValidationResult result = ValidationResult.withLocation("certificate.cer").withoutStoringPassingChecks();
        X509GenericCertificate certificate = X509ResourceCertificateParser.parseCertificate(result, BASE64_DECODER.decode(base64.trim()));
        if (result.hasFailureForCurrentLocation()) {
            throw new DomXmlSerializerException("resource certificate validation failed: " + result);
        }
        if (certificate instanceof X509ResourceCertificate) {
            return (X509ResourceCertificate)certificate;
        }
        throw new DomXmlSerializerException("certificate is not a resource certificate: " + certificate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T deserialize(String xml) {
        try (StringReader characterStream = new StringReader(xml);){
            PayloadMessageType deserialisedType;
            int version;
            Document doc = XML.newNamespaceAwareDocumentBuilder().parse(new InputSource(characterStream));
            Element message = this.getElement(doc, "message").orElseThrow(() -> new DomXmlSerializerException("message element not found"));
            String versionString = this.getRequiredAttributeValue(message, "version");
            try {
                version = Integer.parseUnsignedInt(versionString);
            }
            catch (NumberFormatException e) {
                throw new DomXmlSerializerException("version attribute is not a number: " + versionString, e);
            }
            if (!AbstractProvisioningPayload.SUPPORTED_VERSION.equals(version)) {
                throw new DomXmlSerializerException("version attribute is not '1': " + version);
            }
            String sender = this.getRequiredAttributeValue(message, "sender");
            String recipient = this.getRequiredAttributeValue(message, "recipient");
            String typeString = this.getRequiredAttributeValue(message, "type");
            try {
                deserialisedType = PayloadMessageType.valueOf(typeString);
            }
            catch (IllegalArgumentException e) {
                throw new DomXmlSerializerException("type is not supported: " + typeString, e);
            }
            if (deserialisedType != this.type) {
                throw new DomXmlSerializerException(String.format("type attribute is not '%s'", this.type.toString()));
            }
            T result = this.parseXmlPayload(message);
            ((AbstractProvisioningPayload)result).setSender(sender);
            ((AbstractProvisioningPayload)result).setRecipient(recipient);
            T t = result;
            return t;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new DomXmlSerializerException(e);
        }
    }

    @Override
    public String serialize(T payload) {
        try {
            Document document = XML.newNamespaceAwareDocumentBuilder().newDocument();
            Element message = document.createElementNS(this.xmlns, "message");
            message.setAttribute("version", String.valueOf(((AbstractProvisioningPayload)payload).getVersion()));
            message.setAttribute("sender", ((AbstractProvisioningPayload)payload).getSender());
            message.setAttribute("recipient", ((AbstractProvisioningPayload)payload).getRecipient());
            message.setAttribute("type", String.valueOf((Object)((AbstractProvisioningPayload)payload).getType()));
            for (Node node : this.generateXmlPayload(document, payload)) {
                message.appendChild(node);
            }
            document.appendChild(message);
            return this.serialize((T)document);
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            throw new DomXmlSerializerException(e);
        }
    }

    protected CertificateElement parseCertificateElementXml(Element certificate) {
        CertificateElement result = new CertificateElement();
        result.setIssuerCertificatePublicationLocation((List<URI>)CERTIFICATE_URL_LIST_CONVERTER.fromString(this.getRequiredAttributeValue(certificate, "cert_url")));
        result.setAllocatedAsn(this.getAttributeValue(certificate, "req_resource_set_as").map(IP_RESOURCE_SET_PROVISIONING_CONVERTER::fromString).orElse(null));
        result.setAllocatedIpv4(this.getAttributeValue(certificate, "req_resource_set_ipv4").map(IP_RESOURCE_SET_PROVISIONING_CONVERTER::fromString).orElse(null));
        result.setAllocatedIpv6(this.getAttributeValue(certificate, "req_resource_set_ipv6").map(IP_RESOURCE_SET_PROVISIONING_CONVERTER::fromString).orElse(null));
        result.setCertificate(this.parseX509ResourceCertificate(certificate.getTextContent()));
        return result;
    }

    protected Element generateCertificateElementXml(Document document, CertificateElement certificate) {
        Element result = document.createElementNS(this.xmlns, "certificate");
        result.setAttribute("cert_url", CERTIFICATE_URL_LIST_CONVERTER.toString(certificate.getIssuerCertificatePublicationUris()));
        if (certificate.getAllocatedAsn() != null) {
            result.setAttribute("req_resource_set_as", IP_RESOURCE_SET_PROVISIONING_CONVERTER.toString(certificate.getAllocatedAsn()));
        }
        if (certificate.getAllocatedIpv4() != null) {
            result.setAttribute("req_resource_set_ipv4", IP_RESOURCE_SET_PROVISIONING_CONVERTER.toString(certificate.getAllocatedIpv4()));
        }
        if (certificate.getAllocatedIpv6() != null) {
            result.setAttribute("req_resource_set_ipv6", IP_RESOURCE_SET_PROVISIONING_CONVERTER.toString(certificate.getAllocatedIpv6()));
        }
        result.setTextContent(certificate.getCertificate().getBase64String());
        return result;
    }

    protected <U extends GenericClassElement> U parseClassElementXml(Element element, Supplier<U> clazzSupplier) {
        GenericClassElement clazz = (GenericClassElement)clazzSupplier.get();
        clazz.setCertUris((List<URI>)CERTIFICATE_URL_LIST_CONVERTER.fromString(this.getRequiredAttributeValue(element, "cert_url")));
        clazz.setClassName(this.getRequiredAttributeValue(element, "class_name"));
        clazz.setResourceSetAs(IP_RESOURCE_SET_PROVISIONING_CONVERTER.fromString(this.getRequiredAttributeValue(element, "resource_set_as")));
        clazz.setResourceSetIpv4(IP_RESOURCE_SET_PROVISIONING_CONVERTER.fromString(this.getRequiredAttributeValue(element, "resource_set_ipv4")));
        clazz.setResourceSetIpv6(IP_RESOURCE_SET_PROVISIONING_CONVERTER.fromString(this.getRequiredAttributeValue(element, "resource_set_ipv6")));
        clazz.setValidityNotAfter((DateTime)DATE_TIME_CONVERTER.fromString(this.getRequiredAttributeValue(element, "resource_set_notafter")));
        clazz.setSiaHeadUri(this.getAttributeValue(element, "suggested_sia_head").orElse(null));
        List<CertificateElement> certificateElements = this.getChildElements(element, "certificate").stream().map(this::parseCertificateElementXml).collect(Collectors.toList());
        clazz.setCertificateElements(certificateElements);
        Element issuerElement = this.getSingleChildElement(element, "issuer");
        clazz.setIssuer(this.parseX509ResourceCertificate(issuerElement.getTextContent()));
        return (U)clazz;
    }

    protected Element generateClassElementXml(Document document, GenericClassElement classElement) {
        Element node = document.createElementNS(this.xmlns, "class");
        node.setAttribute("cert_url", CERTIFICATE_URL_LIST_CONVERTER.toString(classElement.getCertificateAuthorityUri()));
        node.setAttribute("class_name", classElement.getClassName());
        node.setAttribute("resource_set_as", IP_RESOURCE_SET_PROVISIONING_CONVERTER.toString(classElement.getResourceSetAsn()));
        node.setAttribute("resource_set_ipv4", IP_RESOURCE_SET_PROVISIONING_CONVERTER.toString(classElement.getResourceSetIpv4()));
        node.setAttribute("resource_set_ipv6", IP_RESOURCE_SET_PROVISIONING_CONVERTER.toString(classElement.getResourceSetIpv6()));
        node.setAttribute("resource_set_notafter", DATE_TIME_CONVERTER.toString(classElement.getValidityNotAfter()));
        if (classElement.getSiaHeadUri() != null) {
            node.setAttribute("suggested_sia_head", classElement.getSiaHeadUri());
        }
        classElement.getCertificateElements().stream().map(certificate -> this.generateCertificateElementXml(document, (CertificateElement)certificate)).forEachOrdered(node::appendChild);
        X509ResourceCertificate issuer = classElement.getIssuer();
        if (issuer != null) {
            Element elt = document.createElementNS(this.xmlns, "issuer");
            elt.setTextContent(issuer.getBase64String());
            node.appendChild(elt);
        }
        return node;
    }
}

