/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.common;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.provisioning.payload.common.CertificateElement;
import net.ripe.rpki.commons.util.EqualsSupport;
import org.joda.time.DateTime;

public class GenericClassElement
extends EqualsSupport {
    private String className;
    private List<URI> certificateAuthorityUri;
    private IpResourceSet resourceSetAs = new IpResourceSet();
    private IpResourceSet resourceSetIpv4 = new IpResourceSet();
    private IpResourceSet resourceSetIpv6 = new IpResourceSet();
    private List<CertificateElement> certificateElements = new ArrayList<CertificateElement>();
    private X509ResourceCertificate issuer;
    private DateTime validityNotAfter;
    private String siaHeadUri;

    public DateTime getValidityNotAfter() {
        return this.validityNotAfter;
    }

    public void setValidityNotAfter(DateTime validityNotAfter) {
        this.validityNotAfter = validityNotAfter;
    }

    public String getSiaHeadUri() {
        return this.siaHeadUri;
    }

    public void setSiaHeadUri(String siaHeadUri) {
        this.siaHeadUri = siaHeadUri;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public List<URI> getCertificateAuthorityUri() {
        return this.certificateAuthorityUri;
    }

    public void setCertUris(List<URI> certUris) {
        this.certificateAuthorityUri = certUris;
    }

    public IpResourceSet getResourceSetAsn() {
        return this.resourceSetAs;
    }

    public IpResourceSet getResourceSetIpv4() {
        return this.resourceSetIpv4;
    }

    public IpResourceSet getResourceSetIpv6() {
        return this.resourceSetIpv6;
    }

    public void setResourceSetAs(IpResourceSet resourceSetAs) {
        this.resourceSetAs = resourceSetAs;
    }

    public void setResourceSetIpv4(IpResourceSet resourceSetIpv4) {
        this.resourceSetIpv4 = resourceSetIpv4;
    }

    public void setResourceSetIpv6(IpResourceSet resourceSetIpv6) {
        this.resourceSetIpv6 = resourceSetIpv6;
    }

    public void setIpResourceSet(IpResourceSet ipResourceSet) {
        IpResourceSet asns = new IpResourceSet();
        IpResourceSet ipv4 = new IpResourceSet();
        IpResourceSet ipv6 = new IpResourceSet();
        for (IpResource resource : ipResourceSet) {
            switch (resource.getType()) {
                case ASN: {
                    asns.add(resource);
                    break;
                }
                case IPv4: {
                    ipv4.add(resource);
                    break;
                }
                case IPv6: {
                    ipv6.add(resource);
                }
            }
        }
        this.resourceSetAs = asns;
        this.resourceSetIpv4 = ipv4;
        this.resourceSetIpv6 = ipv6;
    }

    public X509ResourceCertificate getIssuer() {
        return this.issuer;
    }

    public void setIssuer(X509ResourceCertificate issuer) {
        this.issuer = issuer;
    }

    public List<CertificateElement> getCertificateElements() {
        return this.certificateElements;
    }

    public void setCertificateElements(List<CertificateElement> certificateElements) {
        this.certificateElements = certificateElements;
    }
}

