/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.provisioning.payload.revocation;

import java.security.PublicKey;
import net.ripe.rpki.commons.crypto.util.KeyPairUtil;
import net.ripe.rpki.commons.provisioning.payload.AbstractProvisioningPayload;
import net.ripe.rpki.commons.provisioning.payload.common.AbstractPayloadBuilder;
import org.apache.commons.lang3.Validate;

public abstract class AbstractCertificateRevocationPayloadBuilder<T extends AbstractProvisioningPayload>
extends AbstractPayloadBuilder<T> {
    private String className;
    private String publicKeyHash;

    public void withClassName(String className) {
        this.className = className;
    }

    public void withPublicKeyHash(String publicKeyHash) {
        this.publicKeyHash = publicKeyHash;
    }

    public void withPublicKey(PublicKey publicKey) {
        this.publicKeyHash = KeyPairUtil.getEncodedKeyIdentifier(publicKey);
    }

    protected void validateFields() {
        Validate.notNull((Object)this.className, (String)"Classname is required", (Object[])new Object[0]);
        Validate.notNull((Object)this.publicKeyHash, (String)"Public Key Hash is required", (Object[])new Object[0]);
    }

    protected String getClassName() {
        return this.className;
    }

    protected String getPublicKeyHash() {
        return this.publicKeyHash;
    }
}

