/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.rsync;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.ripe.rpki.commons.rsync.CommandExecutionException;
import net.ripe.rpki.commons.rsync.ProcessReader;

public class Command
extends Thread {
    public static final int NOT_EXECUTED = -1;
    public static final int COMMAND_FAILED = -2;
    private List<String> args;
    private Map<String, String> envp;
    private String execDir;
    private int exitStatus = -1;
    private boolean started;
    private Exception exception;
    private List<String> outputLines;
    private List<String> errorLines;

    public Command(String command) {
        this(command, null, null);
    }

    public Command(String command, Map<String, String> envp) {
        this(command, envp, null);
    }

    public Command(String command, Map<String, String> envp, String execdir) {
        this(Arrays.asList(command), envp, execdir);
    }

    public Command(List<String> args) {
        this(args, null, null);
    }

    public Command(List<String> args, Map<String, String> envp) {
        this(args, envp, null);
    }

    public Command(List<String> args, Map<String, String> envp, String execdir) {
        this.args = args;
        this.envp = envp;
        this.execDir = execdir;
    }

    public void execute() {
        this.started = true;
        try {
            this.exitStatus = this.runExternalCommand();
        }
        catch (CommandExecutionException e) {
            this.exitStatus = -2;
        }
    }

    private int runExternalCommand() {
        try {
            File workDir = this.execDir == null ? null : new File(this.execDir);
            ProcessBuilder pb = new ProcessBuilder(this.args);
            pb.directory(workDir);
            if (this.envp != null) {
                pb.environment().putAll(this.envp);
            }
            Process process = pb.start();
            InputStream processErrorStream = process.getErrorStream();
            InputStream processOutputSteam = process.getInputStream();
            ProcessReader errorReader = new ProcessReader(processErrorStream);
            errorReader.start();
            ProcessReader outputReader = new ProcessReader(processOutputSteam);
            outputReader.start();
            Command.yield();
            outputReader.join();
            errorReader.join();
            this.outputLines = outputReader.getLines();
            this.errorLines = errorReader.getLines();
            return process.waitFor();
        }
        catch (Exception e) {
            this.exception = e;
            throw new CommandExecutionException(e);
        }
    }

    public boolean isCompleted() {
        return this.exitStatus != -1;
    }

    public boolean wasStarted() {
        return this.started;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public String[] getOutputLines() {
        return this.outputLines == null ? null : this.outputLines.toArray(new String[this.outputLines.size()]);
    }

    public List<String> getOutputs() {
        return this.outputLines;
    }

    public String[] getErrorLines() {
        return this.errorLines == null ? null : this.errorLines.toArray(new String[this.errorLines.size()]);
    }

    public List<String> getErrors() {
        return this.errorLines;
    }

    public Exception getException() {
        return this.exception;
    }
}

