/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.ta.domain.response;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.ta.domain.response.RevocationResponse;
import net.ripe.rpki.commons.ta.domain.response.SigningResponse;
import net.ripe.rpki.commons.ta.domain.response.TaResponse;
import net.ripe.rpki.commons.util.EqualsSupport;
import org.apache.commons.lang3.Validate;

public class TrustAnchorResponse
extends EqualsSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Long requestCreationTimestamp;
    private List<TaResponse> taResponses;
    private final Map<URI, CertificateRepositoryObject> publishedObjects;

    public TrustAnchorResponse(Long requestCreationTimestamp, Map<URI, CertificateRepositoryObject> publishedObjects, List<TaResponse> taResponses) {
        Validate.notNull((Object)requestCreationTimestamp, (String)"requestCreationTimestamp is required", (Object[])new Object[0]);
        Validate.notEmpty(publishedObjects, (String)"publishedObjects is required", (Object[])new Object[0]);
        this.requestCreationTimestamp = requestCreationTimestamp;
        this.publishedObjects = new TreeMap<URI, CertificateRepositoryObject>(publishedObjects);
        this.taResponses = taResponses == null ? new ArrayList() : taResponses;
    }

    public Long getRequestCreationTimestamp() {
        return this.requestCreationTimestamp;
    }

    public Map<URI, CertificateRepositoryObject> getPublishedObjects() {
        return Collections.unmodifiableMap(this.publishedObjects);
    }

    public List<TaResponse> getTaResponses() {
        return this.taResponses;
    }

    public static Builder newBuilder(Long requestCreationTimestamp) {
        return new Builder(requestCreationTimestamp);
    }

    public boolean containsSigningOrRevocationResponse() {
        for (TaResponse taResponse : this.taResponses) {
            if (!(taResponse instanceof SigningResponse) && !(taResponse instanceof RevocationResponse)) continue;
            return true;
        }
        return false;
    }

    public static final class Builder {
        private Long requestCreationTimestamp;
        private Map<URI, CertificateRepositoryObject> publishedObjects = new TreeMap<URI, CertificateRepositoryObject>();
        private List<TaResponse> taResponses = new ArrayList<TaResponse>();

        private Builder(Long requestCreationTimestamp) {
            this.requestCreationTimestamp = requestCreationTimestamp;
        }

        public TrustAnchorResponse build() {
            return new TrustAnchorResponse(this.requestCreationTimestamp, this.publishedObjects, this.taResponses);
        }

        public Builder addTaResponse(TaResponse taResponse) {
            Validate.notNull((Object)taResponse, (String)"taResponse is required", (Object[])new Object[0]);
            this.taResponses.add(taResponse);
            return this;
        }

        public Builder addPublishedObjects(Map<URI, CertificateRepositoryObject> publishedObjects) {
            for (URI file : publishedObjects.keySet()) {
                this.addPublishedObject(file, publishedObjects.get(file));
            }
            return this;
        }

        public Builder addPublishedObject(URI file, CertificateRepositoryObject publishedObject) {
            Validate.notNull((Object)file, (String)"file is required", (Object[])new Object[0]);
            Validate.notNull((Object)publishedObject, (String)"publishedObject is required", (Object[])new Object[0]);
            Validate.isTrue((!this.publishedObjects.containsKey(file) ? 1 : 0) != 0, (String)"duplicate file name", (Object[])new Object[0]);
            this.publishedObjects.put(file, publishedObject);
            return this;
        }
    }
}

