/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.ta.serializers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificateParser;
import net.ripe.rpki.commons.ta.domain.response.ErrorResponse;
import net.ripe.rpki.commons.ta.domain.response.RevocationResponse;
import net.ripe.rpki.commons.ta.domain.response.SigningResponse;
import net.ripe.rpki.commons.ta.domain.response.TaResponse;
import net.ripe.rpki.commons.ta.domain.response.TrustAnchorResponse;
import net.ripe.rpki.commons.util.XML;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.xml.DomXmlSerializer;
import net.ripe.rpki.commons.xml.DomXmlSerializerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TrustAnchorResponseSerializer
extends DomXmlSerializer<TrustAnchorResponse> {
    private static final Base64.Decoder BASE64_DECODER = Base64.getMimeDecoder();
    private static final Base64.Encoder BASE64_ENCODER = Base64.getEncoder();
    public static final String CREATION_TIMESTAMP = "requestCreationTimestamp";
    public static final String TRUST_ANCHOR_RESPONSE = "TrustAnchorResponse";
    public static final String X_509_RESOURCE_CERTIFICATE = "X509ResourceCertificate";
    public static final String CRL = "CRL";
    public static final String MANIFEST = "Manifest";
    public static final String ROA = "Roa";
    public static final String ROA_PREFIX = "RoaPrefix";
    public static final String TA_RESPONSES = "taResponses";
    public static final String SIGNING_RESPONSE = "SigningResponse";
    public static final String REVOCATION_RESPONSE = "RevocationResponse";
    public static final String ERROR_RESPONSE = "ErrorResponse";
    public static final String PUBLISHED_OBJECTS = "publishedObjects";
    public static final String URI_ELEMENT = "uri";
    public static final String ENTRY_ELEMENT = "entry";
    public static final String REQUEST_ID = "requestId";
    public static final String RESOURCE_CLASS_NAME = "resourceClassName";
    public static final String ENCODED_PUBLIC_KEY = "encodedPublicKey";
    public static final String MESSAGE = "message";
    public static final String PUBLICATION_URI = "publicationUri";
    public static final String CERTIFICATE = "certificate";
    public static final String ENCODED = "encoded";

    public TrustAnchorResponseSerializer() {
        super("");
    }

    @Override
    public String serialize(TrustAnchorResponse trustAnchorResponse) {
        if (trustAnchorResponse == null) {
            return null;
        }
        try {
            Map<URI, CertificateRepositoryObject> publishedObjects;
            List<TaResponse> taResponses;
            Document doc = XML.newNamespaceAwareDocumentBuilder().newDocument();
            Element responseTrustAnchorResponseElement = this.addChild(doc, doc, TRUST_ANCHOR_RESPONSE);
            Long creationTimestamp = trustAnchorResponse.getRequestCreationTimestamp();
            if (creationTimestamp != null) {
                this.addChild(doc, responseTrustAnchorResponseElement, CREATION_TIMESTAMP).setTextContent(creationTimestamp.toString());
            }
            if ((taResponses = trustAnchorResponse.getTaResponses()) != null) {
                Element taRequestsElement = this.addChild(doc, responseTrustAnchorResponseElement, TA_RESPONSES);
                for (TaResponse taResponse : taResponses) {
                    if (taResponse instanceof SigningResponse) {
                        this.serializeSigningResponse(doc, taRequestsElement, (SigningResponse)taResponse);
                        continue;
                    }
                    if (taResponse instanceof RevocationResponse) {
                        this.serializeRevocationResponse(doc, taRequestsElement, (RevocationResponse)taResponse);
                        continue;
                    }
                    if (!(taResponse instanceof ErrorResponse)) continue;
                    this.serializeErrorResponse(doc, taRequestsElement, (ErrorResponse)taResponse);
                }
            }
            if ((publishedObjects = trustAnchorResponse.getPublishedObjects()) != null) {
                Element publishedObjectsElement = this.addChild(doc, responseTrustAnchorResponseElement, PUBLISHED_OBJECTS);
                for (Map.Entry<URI, CertificateRepositoryObject> e : publishedObjects.entrySet()) {
                    Element entryElement = this.addChild(doc, publishedObjectsElement, ENTRY_ELEMENT);
                    this.addChild(doc, entryElement, URI_ELEMENT).setTextContent(e.getKey().toString());
                    this.addEncodedObject(doc, entryElement, e.getValue());
                }
            }
            return this.serialize(doc);
        }
        catch (ParserConfigurationException | TransformerException e) {
            throw new DomXmlSerializerException(e);
        }
    }

    private void serializeSigningResponse(Document doc, Element taRequestsElement, SigningResponse taResponse) {
        Element signingResponseElement = this.addChild(doc, taRequestsElement, SIGNING_RESPONSE);
        this.addChild(doc, signingResponseElement, REQUEST_ID).setTextContent(taResponse.getRequestId().toString());
        this.addChild(doc, signingResponseElement, RESOURCE_CLASS_NAME).setTextContent(taResponse.getResourceClassName());
        this.addChild(doc, signingResponseElement, PUBLICATION_URI).setTextContent(taResponse.getPublicationUri().toString());
        this.addChild(doc, this.addChild(doc, signingResponseElement, CERTIFICATE), ENCODED).setTextContent(BASE64_ENCODER.encodeToString(taResponse.getCertificate().getEncoded()));
    }

    private void serializeRevocationResponse(Document doc, Element taRequestsElement, RevocationResponse taResponse) {
        Element revocationResponseElement = this.addChild(doc, taRequestsElement, REVOCATION_RESPONSE);
        this.addChild(doc, revocationResponseElement, REQUEST_ID).setTextContent(taResponse.getRequestId().toString());
        this.addChild(doc, revocationResponseElement, RESOURCE_CLASS_NAME).setTextContent(taResponse.getResourceClassName());
        this.addChild(doc, revocationResponseElement, ENCODED_PUBLIC_KEY).setTextContent(taResponse.getEncodedPublicKey());
    }

    private void serializeErrorResponse(Document doc, Element taRequestsElement, ErrorResponse taResponse) {
        Element errorResponseElement = this.addChild(doc, taRequestsElement, ERROR_RESPONSE);
        this.addChild(doc, errorResponseElement, REQUEST_ID).setTextContent(taResponse.getRequestId().toString());
        this.addChild(doc, errorResponseElement, MESSAGE).setTextContent(taResponse.getMessage());
    }

    private void addEncodedObject(Document doc, Element entryElement, CertificateRepositoryObject objects) {
        String tagName;
        if (objects instanceof X509ResourceCertificate) {
            tagName = X_509_RESOURCE_CERTIFICATE;
        } else if (objects instanceof X509Crl) {
            tagName = CRL;
        } else if (objects instanceof ManifestCms) {
            tagName = MANIFEST;
        } else if (objects instanceof RoaCms) {
            tagName = ROA;
        } else {
            throw new RuntimeException("Not implemented serialisation of '" + objects.getClass() + "'");
        }
        Element objectElement = this.addChild(doc, entryElement, tagName);
        String textContent = BASE64_ENCODER.encodeToString(objects.getEncoded());
        this.addChild(doc, objectElement, ENCODED).setTextContent(textContent);
    }

    @Override
    public TrustAnchorResponse deserialize(String xml) {
        TrustAnchorResponse trustAnchorResponse;
        StringReader characterStream = new StringReader(xml);
        try {
            long creationTimeStamp;
            Document doc = XML.newNamespaceAwareDocumentBuilder().parse(new InputSource(characterStream));
            Element taResponseElement = this.getElement(doc, TRUST_ANCHOR_RESPONSE).orElseThrow(() -> new DomXmlSerializerException("TrustAnchorResponse element not found"));
            Element creationTimestampElement = this.getSingleChildElement(taResponseElement, CREATION_TIMESTAMP);
            String creationTimeStampText = this.getElementTextContent(creationTimestampElement);
            try {
                creationTimeStamp = Long.parseLong(creationTimeStampText);
            }
            catch (NumberFormatException e) {
                throw new DomXmlSerializerException("creationTimestamp content is not a number: " + creationTimeStampText, e);
            }
            Element responseListElement = this.getSingleChildElement(taResponseElement, TA_RESPONSES);
            List<TaResponse> taResponses = this.getTaSigningResponses(responseListElement);
            taResponses.addAll(this.getTaRevocationResponses(responseListElement));
            taResponses.addAll(this.getTaErrorResponses(responseListElement));
            Map<URI, CertificateRepositoryObject> publishedObjects = this.getPublishedObjects(taResponseElement);
            trustAnchorResponse = new TrustAnchorResponse(creationTimeStamp, publishedObjects, taResponses);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)characterStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                throw new DomXmlSerializerException(e);
            }
        }
        ((Reader)characterStream).close();
        return trustAnchorResponse;
    }

    private Map<URI, CertificateRepositoryObject> getPublishedObjects(Element taResponseElement) {
        TreeMap<URI, CertificateRepositoryObject> publishedObjects = new TreeMap<URI, CertificateRepositoryObject>();
        List<Element> entryElements = this.getChildElements(this.getSingleChildElement(taResponseElement, PUBLISHED_OBJECTS), ENTRY_ELEMENT);
        for (Element entryElement : entryElements) {
            NodeList childNodes = entryElement.getChildNodes();
            String uri = null;
            CertificateRepositoryObject object = null;
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (URI_ELEMENT.equals(item.getLocalName())) {
                    uri = this.getElementTextContent((Element)item);
                }
                if (X_509_RESOURCE_CERTIFICATE.equals(item.getLocalName())) {
                    object = this.parseObject((Element)item, uri, "tmp.cer");
                    continue;
                }
                if (CRL.equals(item.getLocalName())) {
                    object = this.parseObject((Element)item, uri, "tmp.crl");
                    continue;
                }
                if (MANIFEST.equals(item.getLocalName())) {
                    object = this.parseObject((Element)item, uri, "tmp.mft");
                    continue;
                }
                if (!ROA.equals(item.getLocalName())) continue;
                object = this.parseObject((Element)item, uri, "tmp.roa");
            }
            if (uri == null) {
                throw new DomXmlSerializerException("<uri> is not found inside of an entry");
            }
            if (object == null) {
                throw new DomXmlSerializerException("Object is not found inside of an entry");
            }
            publishedObjects.put(URI.create(uri), object);
        }
        return publishedObjects;
    }

    private CertificateRepositoryObject parseObject(Element item, String uri, String name) {
        String parseName = uri != null ? uri : name;
        byte[] encoded = this.getBase64(item);
        return CertificateRepositoryObjectFactory.createCertificateRepositoryObject(encoded, ValidationResult.withLocation(parseName));
    }

    private byte[] getBase64(Element e) {
        String encodedContent = this.getElementTextContent(e);
        return BASE64_DECODER.decode(encodedContent);
    }

    private List<TaResponse> getTaSigningResponses(Element responseListElement) {
        ArrayList<TaResponse> responses = new ArrayList<TaResponse>();
        List<Element> responseElements = this.getChildElements(responseListElement, SIGNING_RESPONSE);
        for (Element signingResponseElement : responseElements) {
            String requestId = this.getElementTextContent(this.getSingleChildElement(signingResponseElement, REQUEST_ID));
            String resourceClassName = this.getElementTextContent(this.getSingleChildElement(signingResponseElement, RESOURCE_CLASS_NAME));
            String publicationUri = this.getElementTextContent(this.getSingleChildElement(signingResponseElement, PUBLICATION_URI));
            Element encodedCertificateElem = this.getSingleChildElement(this.getSingleChildElement(signingResponseElement, CERTIFICATE), ENCODED);
            byte[] encoded = BASE64_DECODER.decode(this.getElementTextContent(encodedCertificateElem));
            X509ResourceCertificateParser parser = new X509ResourceCertificateParser();
            parser.parse("request-" + requestId + ".cer", encoded);
            responses.add(new SigningResponse(UUID.fromString(requestId), resourceClassName, URI.create(publicationUri), parser.getCertificate()));
        }
        return responses;
    }

    private Collection<? extends TaResponse> getTaRevocationResponses(Element responseListElement) {
        ArrayList<RevocationResponse> responses = new ArrayList<RevocationResponse>();
        List<Element> responseElements = this.getChildElements(responseListElement, REVOCATION_RESPONSE);
        for (Element revocationResponseElement : responseElements) {
            String requestId = this.getElementTextContent(this.getSingleChildElement(revocationResponseElement, REQUEST_ID));
            String resourceClassName = this.getElementTextContent(this.getSingleChildElement(revocationResponseElement, RESOURCE_CLASS_NAME));
            String encodedPublicKey = this.getElementTextContent(this.getSingleChildElement(revocationResponseElement, ENCODED_PUBLIC_KEY));
            responses.add(new RevocationResponse(UUID.fromString(requestId), resourceClassName, encodedPublicKey));
        }
        return responses;
    }

    private Collection<? extends TaResponse> getTaErrorResponses(Element responseListElement) {
        ArrayList<ErrorResponse> responses = new ArrayList<ErrorResponse>();
        List<Element> responseElements = this.getChildElements(responseListElement, ERROR_RESPONSE);
        for (Element errorResponseElement : responseElements) {
            String requestId = this.getElementTextContent(this.getSingleChildElement(errorResponseElement, REQUEST_ID));
            String message = this.getElementTextContent(this.getSingleChildElement(errorResponseElement, MESSAGE));
            responses.add(new ErrorResponse(UUID.fromString(requestId), message));
        }
        return responses;
    }
}

