/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.util;

import net.ripe.rpki.commons.util.Specification;

public final class Specifications {
    private Specifications() {
    }

    public static <T> Specification<T> alwaysTrue() {
        return new AlwaysTrueSpecification();
    }

    public static <T> Specification<T> alwaysFalse() {
        return new AlwaysFalseSpecification();
    }

    private static final class AlwaysTrueSpecification<T>
    implements Specification<T> {
        private AlwaysTrueSpecification() {
        }

        @Override
        public boolean isSatisfiedBy(T candidate) {
            return true;
        }

        public int hashCode() {
            return Boolean.TRUE.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof AlwaysTrueSpecification;
        }
    }

    private static final class AlwaysFalseSpecification<T>
    implements Specification<T> {
        private AlwaysFalseSpecification() {
        }

        @Override
        public boolean isSatisfiedBy(T candidate) {
            return false;
        }

        public int hashCode() {
            return Boolean.FALSE.hashCode();
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof AlwaysFalseSpecification;
        }
    }
}

