/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import org.joda.time.Duration;

public class ValidationOptions {
    private boolean strictManifestCRLValidityChecks;
    private Duration crlMaxStalePeriod;
    private Duration manifestMaxStalePeriod;
    private boolean allowOverclaimParentChild = false;

    private ValidationOptions(Boolean strictManifestCRLValidityChecks, Duration crlMaxStalePeriod, Duration manifestMaxStalePeriod) {
        this.strictManifestCRLValidityChecks = strictManifestCRLValidityChecks;
        this.crlMaxStalePeriod = crlMaxStalePeriod;
        this.manifestMaxStalePeriod = manifestMaxStalePeriod;
    }

    public static ValidationOptions strictValidation() {
        return new ValidationOptions(true, Duration.ZERO, Duration.ZERO);
    }

    public static ValidationOptions backCompatibleRipeNccValidator() {
        return new ValidationOptions(false, Duration.ZERO, Duration.ZERO);
    }

    public static ValidationOptions paranoidTestValidations() {
        return new ValidationOptions(true, Duration.standardHours((long)-7L), Duration.standardHours((long)-7L));
    }

    public static ValidationOptions withStaleConfigurations(Duration maxCrlStalePeriod, Duration maxMftStalePeriod) {
        return new ValidationOptions(true, maxCrlStalePeriod, maxMftStalePeriod);
    }

    public Duration getCrlMaxStalePeriod() {
        return this.crlMaxStalePeriod;
    }

    public Duration getManifestMaxStalePeriod() {
        return this.manifestMaxStalePeriod;
    }

    public boolean isAllowOverclaimParentChild() {
        return this.allowOverclaimParentChild;
    }

    public void setAllowOverclaimParentChild(boolean allowOverclaimParentChild) {
        this.allowOverclaimParentChild = allowOverclaimParentChild;
    }

    public boolean isStrictManifestCRLValidityChecks() {
        return this.strictManifestCRLValidityChecks;
    }

    public void setStrictManifestCRLValidityChecks(boolean strictManifestCRLValidityChecks) {
        this.strictManifestCRLValidityChecks = strictManifestCRLValidityChecks;
    }
}

