/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationMetric;
import net.ripe.rpki.commons.validation.ValidationStatus;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.joda.time.DateTimeUtils;

public final class ValidationResult
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String[] EMPTY_PARAM = new String[0];
    private Map<ValidationLocation, ResultsPerLocation> results = new TreeMap<ValidationLocation, ResultsPerLocation>();
    private ValidationLocation currentLocation;
    private Map<ValidationLocation, List<ValidationMetric>> metrics = new TreeMap<ValidationLocation, List<ValidationMetric>>();
    private boolean storingPassingChecks = true;

    private ValidationResult(ValidationLocation location) {
        this.setLocation(location);
    }

    public static ValidationResult withLocation(URI uri) {
        return new ValidationResult(new ValidationLocation(uri));
    }

    public static ValidationResult withLocation(String name) {
        return new ValidationResult(new ValidationLocation(name));
    }

    public static ValidationResult withLocation(ValidationLocation location) {
        return new ValidationResult(location);
    }

    public ValidationResult withoutStoringPassingChecks() {
        if (this.storingPassingChecks) {
            this.storingPassingChecks = false;
            for (ResultsPerLocation entry : this.results.values()) {
                entry.passed.clear();
            }
        }
        return this;
    }

    public boolean isStoringPassingChecks() {
        return this.storingPassingChecks;
    }

    public ValidationResult setLocation(ValidationLocation location) {
        this.currentLocation = location;
        return this;
    }

    private ResultsPerLocation getCurrentResults() {
        return this.results.computeIfAbsent(this.currentLocation, x -> new ResultsPerLocation());
    }

    public ValidationResult pass(String key) {
        return this.pass(key, EMPTY_PARAM);
    }

    public ValidationResult pass(String key, String ... param) {
        if (this.storingPassingChecks) {
            this.getCurrentResults().passed.add(new ValidationCheck(ValidationStatus.PASSED, key, param));
        }
        return this;
    }

    public ValidationResult warn(String key) {
        return this.warn(key, EMPTY_PARAM);
    }

    public ValidationResult warn(String key, String ... param) {
        this.getCurrentResults().warning.add(new ValidationCheck(ValidationStatus.WARNING, key, param));
        return this;
    }

    public ValidationResult error(String key) {
        return this.error(key, EMPTY_PARAM);
    }

    public ValidationResult error(String key, String ... param) {
        this.getCurrentResults().error.add(new ValidationCheck(ValidationStatus.ERROR, key, param));
        return this;
    }

    public boolean warnIfFalse(boolean condition, String key) {
        return this.warnIfFalse(condition, key, EMPTY_PARAM);
    }

    public boolean warnIfFalse(boolean condition, String key, String ... param) {
        Validate.notNull((Object)key, (String)"key is required", (Object[])new Object[0]);
        if (condition) {
            this.pass(key, param);
        } else {
            this.warn(key, param);
        }
        return condition;
    }

    public boolean warnIfTrue(boolean condition, String key) {
        return this.warnIfTrue(condition, key, EMPTY_PARAM);
    }

    public boolean warnIfTrue(boolean condition, String key, String ... param) {
        return this.warnIfFalse(!condition, key, param);
    }

    public boolean warnIfNull(Object object, String key) {
        return this.warnIfNull(object, key, EMPTY_PARAM);
    }

    public boolean warnIfNull(Object object, String key, String ... param) {
        return this.warnIfTrue(object == null, key, param);
    }

    public boolean warnIfNotNull(Object object, String key) {
        return this.warnIfNotNull(object, key, EMPTY_PARAM);
    }

    public boolean warnIfNotNull(Object object, String key, String ... param) {
        return this.warnIfTrue(object != null, key, param);
    }

    public ValidationResult rejectForLocation(ValidationLocation location, String key) {
        return this.rejectForLocation(location, key, EMPTY_PARAM);
    }

    public ValidationResult rejectForLocation(ValidationLocation location, String key, String ... param) {
        ResultsPerLocation resultsPerLocation = this.results.computeIfAbsent(location, x -> new ResultsPerLocation());
        resultsPerLocation.error.add(new ValidationCheck(ValidationStatus.ERROR, key, param));
        return this;
    }

    public ValidationResult warnForLocation(ValidationLocation location, String key) {
        return this.warnForLocation(location, key, EMPTY_PARAM);
    }

    public ValidationResult warnForLocation(ValidationLocation location, String key, String ... param) {
        ResultsPerLocation resultsPerLocation = this.results.computeIfAbsent(location, x -> new ResultsPerLocation());
        resultsPerLocation.warning.add(new ValidationCheck(ValidationStatus.WARNING, key, param));
        return this;
    }

    public boolean rejectIfFalse(boolean condition, String key) {
        return this.rejectIfFalse(condition, key, EMPTY_PARAM);
    }

    public boolean rejectIfFalse(boolean condition, String key, String ... param) {
        Validate.notNull((Object)key, (String)"key is required", (Object[])new Object[0]);
        if (condition) {
            this.pass(key, param);
        } else {
            this.error(key, param);
        }
        return condition;
    }

    public boolean rejectIfTrue(boolean condition, String key) {
        return this.rejectIfTrue(condition, key, EMPTY_PARAM);
    }

    public boolean rejectIfTrue(boolean condition, String key, String ... param) {
        return this.rejectIfFalse(!condition, key, param);
    }

    public boolean rejectIfNull(Object object, String key) {
        return this.rejectIfNull(object, key, EMPTY_PARAM);
    }

    public boolean rejectIfNull(Object object, String key, String ... param) {
        return this.rejectIfTrue(object == null, key, param);
    }

    public boolean rejectIfNotNull(Object object, String key) {
        return this.rejectIfNotNull(object, key, EMPTY_PARAM);
    }

    public boolean rejectIfNotNull(Object object, String key, String ... param) {
        return this.rejectIfTrue(object != null, key, param);
    }

    public ValidationResult addMetric(String name, String value) {
        if (!this.metrics.containsKey(this.currentLocation)) {
            this.metrics.put(this.currentLocation, new ArrayList());
        }
        this.metrics.get(this.currentLocation).add(new ValidationMetric(name, value, DateTimeUtils.currentTimeMillis()));
        return this;
    }

    public Set<ValidationLocation> getValidatedLocations() {
        return this.results.keySet();
    }

    public ValidationLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public boolean hasFailures() {
        for (ResultsPerLocation checks : this.results.values()) {
            if (checks.error.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasWarnings() {
        for (ResultsPerLocation checks : this.results.values()) {
            if (checks.warning.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNoFailuresOrWarnings() {
        return !this.hasFailures() && !this.hasWarnings();
    }

    public Set<ValidationCheck> getFailuresForCurrentLocation() {
        return new HashSet<ValidationCheck>(this.getFailures(this.currentLocation));
    }

    public List<ValidationCheck> getFailuresForAllLocations() {
        ArrayList<ValidationCheck> failures = new ArrayList<ValidationCheck>();
        for (ResultsPerLocation checks : this.results.values()) {
            failures.addAll(checks.error);
        }
        return failures;
    }

    public List<ValidationCheck> getFailures(ValidationLocation location) {
        ResultsPerLocation checks = this.results.get(location);
        return checks == null ? Collections.emptyList() : checks.error;
    }

    public List<ValidationCheck> getWarnings(ValidationLocation location) {
        ResultsPerLocation checks = this.results.get(location);
        return checks == null ? Collections.emptyList() : checks.warning;
    }

    public boolean hasFailureForCurrentLocation() {
        return this.hasFailureForLocation(this.currentLocation);
    }

    public boolean hasFailureForLocation(ValidationLocation location) {
        ResultsPerLocation checks = this.results.get(location);
        return checks != null && !checks.error.isEmpty();
    }

    public List<ValidationCheck> getWarnings() {
        ArrayList<ValidationCheck> warnings = new ArrayList<ValidationCheck>();
        for (ResultsPerLocation checks : this.results.values()) {
            warnings.addAll(checks.warning);
        }
        return warnings;
    }

    public List<ValidationCheck> getAllValidationChecksForCurrentLocation() {
        return this.getAllValidationChecksForLocation(this.currentLocation);
    }

    public List<ValidationCheck> getAllValidationChecksForLocation(ValidationLocation location) {
        ArrayList<ValidationCheck> allChecks = new ArrayList<ValidationCheck>();
        ResultsPerLocation resultsPerLocation = this.results.get(location);
        if (resultsPerLocation != null) {
            allChecks.addAll(resultsPerLocation.error);
            allChecks.addAll(resultsPerLocation.warning);
            allChecks.addAll(resultsPerLocation.passed);
        }
        return allChecks;
    }

    public ValidationCheck getResultForCurrentLocation(String checkKey) {
        return this.getResult(this.currentLocation, checkKey);
    }

    public ValidationCheck getResult(ValidationLocation location, String checkKey) {
        List<ValidationCheck> allChecks = this.getAllValidationChecksForLocation(location);
        for (ValidationCheck check : allChecks) {
            if (!check.getKey().equals(checkKey)) continue;
            return check;
        }
        return null;
    }

    public List<ValidationMetric> getMetrics(ValidationLocation location) {
        if (this.metrics.containsKey(location)) {
            return Collections.unmodifiableList(this.metrics.get(location));
        }
        return Collections.emptyList();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public ValidationResult addAll(ValidationResult that) {
        for (Map.Entry<ValidationLocation, ResultsPerLocation> resultsByLocation : that.results.entrySet()) {
            ResultsPerLocation thatResults = resultsByLocation.getValue();
            if (thatResults.error.isEmpty() && thatResults.warning.isEmpty() && (thatResults.passed.isEmpty() || !this.storingPassingChecks)) continue;
            ResultsPerLocation thisResults = this.results.computeIfAbsent(resultsByLocation.getKey(), x -> new ResultsPerLocation());
            thisResults.error.addAll(thatResults.error);
            thisResults.warning.addAll(thatResults.warning);
            if (!this.storingPassingChecks) continue;
            thisResults.passed.addAll(thatResults.passed);
        }
        return this;
    }

    private static final class ResultsPerLocation
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final List<ValidationCheck> error = new ArrayList<ValidationCheck>();
        final List<ValidationCheck> warning = new ArrayList<ValidationCheck>();
        final List<ValidationCheck> passed = new ArrayList<ValidationCheck>(20);

        private ResultsPerLocation() {
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("error", this.error).append("warning", this.warning).append("passed", this.passed).toString();
        }
    }
}

