/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.commons.validation.objectvalidators;

import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateObject;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class CertificateRepositoryObjectValidationContext {
    private final List<String> subjectChain;
    private final URI location;
    private final X509CertificateObject certificate;
    private final IpResourceSet resources;
    private IpResourceSet overclaiming = new IpResourceSet();

    public CertificateRepositoryObjectValidationContext(URI location, X509ResourceCertificate certificate) {
        this(location, certificate, certificate.getResources(), Lists.newArrayList((Object[])new String[]{certificate.getSubject().getName()}));
    }

    public CertificateRepositoryObjectValidationContext(URI location, X509ResourceCertificate certificate, IpResourceSet resources, List<String> subjectChain) {
        this.location = location;
        this.certificate = certificate;
        this.resources = resources;
        this.subjectChain = subjectChain;
    }

    public URI getLocation() {
        return this.location;
    }

    public X509ResourceCertificate getCertificate() {
        if (this.certificate instanceof X509ResourceCertificate) {
            return (X509ResourceCertificate)this.certificate;
        }
        throw new IllegalStateException("The certificate in the context is not of the type " + X509ResourceCertificate.class);
    }

    public X509RouterCertificate getRouterCertificate() {
        if (this.certificate instanceof X509RouterCertificate) {
            return (X509RouterCertificate)this.certificate;
        }
        throw new IllegalStateException("The certificate in the context is not of the type " + X509RouterCertificate.class);
    }

    public X509CertificateObject getUntypedCertificate() {
        return this.certificate;
    }

    public List<String> getSubjectChain() {
        return this.subjectChain;
    }

    public URI getManifestURI() {
        return this.getCertificate().getManifestUri();
    }

    public URI getRepositoryURI() {
        return this.getCertificate().getRepositoryUri();
    }

    public URI getRpkiNotifyURI() {
        return this.getCertificate().getRrdpNotifyUri();
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.getCertificate().getSubjectKeyIdentifier();
    }

    public void addOverclaiming(IpResourceSet overclaiming) {
        this.overclaiming.addAll((Iterable)overclaiming);
    }

    public CertificateRepositoryObjectValidationContext createChildContext(URI childLocation, X509ResourceCertificate childCertificate) {
        IpResourceSet effectiveResources = childCertificate.deriveResources(this.resources);
        this.removeOverclaimingResources(effectiveResources);
        ArrayList childSubjects = Lists.newArrayList(this.subjectChain);
        childSubjects.add(childCertificate.getSubject().getName());
        return new CertificateRepositoryObjectValidationContext(childLocation, childCertificate, effectiveResources, childSubjects);
    }

    public IpResourceSet getResources() {
        IpResourceSet result = new IpResourceSet(this.resources);
        this.removeOverclaimingResources(result);
        return result;
    }

    private void removeOverclaimingResources(IpResourceSet resources) {
        if (this.overclaiming.isEmpty() || resources.isEmpty()) {
            return;
        }
        resources.removeAll((Iterable)this.overclaiming);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.location).append((Object)this.certificate).append((Object)this.resources).append((Object)this.overclaiming).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateRepositoryObjectValidationContext that = (CertificateRepositoryObjectValidationContext)obj;
        return new EqualsBuilder().append((Object)this.getLocation(), (Object)that.getLocation()).append((Object)this.getCertificate(), (Object)that.getCertificate()).append((Object)this.resources, (Object)that.resources).append((Object)this.overclaiming, (Object)that.overclaiming).isEquals();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

