/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.templating.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.management.ManagedApplication;
import net.roboconf.dm.management.Manager;
import net.roboconf.dm.management.events.IDmListener;
import net.roboconf.dm.templating.internal.templates.TemplateEntry;
import net.roboconf.dm.templating.internal.templates.TemplateUtils;
import net.roboconf.dm.templating.internal.templates.TemplateWatcher;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class TemplatingManager
implements IDmListener,
Pojo {
    InstanceManager __IM;
    public static final String ID = "DM's Templating";
    private boolean __FwatcherLock;
    private final Object watcherLock;
    private boolean __FgenerationLock;
    private final Object generationLock;
    private boolean __FpollInterval;
    private long pollInterval;
    private boolean __Fdm;
    Manager dm;
    private boolean __Flogger;
    private final Logger logger;
    private boolean __FtemplatesDIR;
    File templatesDIR;
    private boolean __FoutputDIR;
    File outputDIR;
    private boolean __FtemplateWatcher;
    TemplateWatcher templateWatcher;
    boolean __MsetPollInterval$long;
    boolean __MsetTemplatesDirectory$java_lang_String;
    boolean __MsetOutputDirectory$java_lang_String;
    boolean __MbindManager$net_roboconf_dm_management_Manager;
    boolean __MunbindManager$net_roboconf_dm_management_Manager;
    boolean __Mstart;
    boolean __Mstop;
    boolean __MgetId;
    boolean __Mapplication$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType;
    boolean __MapplicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType;
    boolean __Minstance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType;
    boolean __Mraw$java_lang_String$java_lang_Object__;
    boolean __MenableNotifications;
    boolean __MdisableNotifications;
    boolean __MprocessNewTemplates$java_util_Collection;
    boolean __MresetWatcher;
    boolean __MstopWatcher;
    boolean __Mgenerate$net_roboconf_core_model_beans_Application;
    boolean __Mgenerate$net_roboconf_core_model_beans_Application$java_util_Collection;

    Object __getwatcherLock() {
        if (!this.__FwatcherLock) {
            return this.watcherLock;
        }
        return this.__IM.onGet((Object)this, "watcherLock");
    }

    void __setwatcherLock(Object object) {
        if (!this.__FwatcherLock) {
            this.watcherLock = object;
            return;
        }
        this.__IM.onSet((Object)this, "watcherLock", object);
    }

    Object __getgenerationLock() {
        if (!this.__FgenerationLock) {
            return this.generationLock;
        }
        return this.__IM.onGet((Object)this, "generationLock");
    }

    void __setgenerationLock(Object object) {
        if (!this.__FgenerationLock) {
            this.generationLock = object;
            return;
        }
        this.__IM.onSet((Object)this, "generationLock", object);
    }

    long __getpollInterval() {
        if (!this.__FpollInterval) {
            return this.pollInterval;
        }
        Object object = this.__IM.onGet((Object)this, "pollInterval");
        Long l = (Long)object;
        return l;
    }

    void __setpollInterval(long l) {
        if (!this.__FpollInterval) {
            this.pollInterval = l;
            return;
        }
        Long l2 = new Long(l);
        this.__IM.onSet((Object)this, "pollInterval", (Object)l2);
    }

    Manager __getdm() {
        if (!this.__Fdm) {
            return this.dm;
        }
        return (Manager)this.__IM.onGet((Object)this, "dm");
    }

    void __setdm(Manager manager) {
        if (!this.__Fdm) {
            this.dm = manager;
            return;
        }
        this.__IM.onSet((Object)this, "dm", (Object)manager);
    }

    Logger __getlogger() {
        if (!this.__Flogger) {
            return this.logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "logger");
    }

    void __setlogger(Logger logger) {
        if (!this.__Flogger) {
            this.logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "logger", (Object)logger);
    }

    File __gettemplatesDIR() {
        if (!this.__FtemplatesDIR) {
            return this.templatesDIR;
        }
        return (File)this.__IM.onGet((Object)this, "templatesDIR");
    }

    void __settemplatesDIR(File file) {
        if (!this.__FtemplatesDIR) {
            this.templatesDIR = file;
            return;
        }
        this.__IM.onSet((Object)this, "templatesDIR", (Object)file);
    }

    File __getoutputDIR() {
        if (!this.__FoutputDIR) {
            return this.outputDIR;
        }
        return (File)this.__IM.onGet((Object)this, "outputDIR");
    }

    void __setoutputDIR(File file) {
        if (!this.__FoutputDIR) {
            this.outputDIR = file;
            return;
        }
        this.__IM.onSet((Object)this, "outputDIR", (Object)file);
    }

    TemplateWatcher __gettemplateWatcher() {
        if (!this.__FtemplateWatcher) {
            return this.templateWatcher;
        }
        return (TemplateWatcher)((Object)this.__IM.onGet((Object)this, "templateWatcher"));
    }

    void __settemplateWatcher(TemplateWatcher templateWatcher) {
        if (!this.__FtemplateWatcher) {
            this.templateWatcher = templateWatcher;
            return;
        }
        this.__IM.onSet((Object)this, "templateWatcher", (Object)templateWatcher);
    }

    public TemplatingManager() {
        this(null);
    }

    private TemplatingManager(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setwatcherLock(new Object());
        this.__setgenerationLock(new Object());
        this.__setlogger(Logger.getLogger(this.getClass().getName()));
    }

    public void setPollInterval(long pollInterval) {
        if (!this.__MsetPollInterval$long) {
            this.__M_setPollInterval(pollInterval);
            return;
        }
        try {
            Object[] objectArray = new Object[1];
            objectArray[0] = new Long(pollInterval);
            this.__IM.onEntry((Object)this, "setPollInterval$long", objectArray);
            this.__M_setPollInterval(pollInterval);
            this.__IM.onExit((Object)this, "setPollInterval$long", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setPollInterval$long", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_setPollInterval(long pollInterval) {
        this.__setpollInterval(pollInterval);
        this.__getlogger().fine("Template watcher poll interval set to " + pollInterval);
        Object object = this.__getwatcherLock();
        synchronized (object) {
            if (this.__gettemplateWatcher() != null) {
                this.resetWatcher();
            }
        }
    }

    public void setTemplatesDirectory(String templatesDirectory) {
        if (!this.__MsetTemplatesDirectory$java_lang_String) {
            this.__M_setTemplatesDirectory(templatesDirectory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTemplatesDirectory$java_lang_String", new Object[]{templatesDirectory});
            this.__M_setTemplatesDirectory(templatesDirectory);
            this.__IM.onExit((Object)this, "setTemplatesDirectory$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTemplatesDirectory$java_lang_String", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_setTemplatesDirectory(String templatesDirectory) {
        this.__getlogger().fine("Templates directory is now... " + templatesDirectory);
        this.__settemplatesDIR(Utils.isEmptyOrWhitespaces((String)templatesDirectory) ? null : new File(templatesDirectory));
        Object object = this.__getwatcherLock();
        synchronized (object) {
            if (this.__gettemplateWatcher() != null) {
                this.resetWatcher();
            }
        }
    }

    public void setOutputDirectory(String outputDirectory) {
        if (!this.__MsetOutputDirectory$java_lang_String) {
            this.__M_setOutputDirectory(outputDirectory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setOutputDirectory$java_lang_String", new Object[]{outputDirectory});
            this.__M_setOutputDirectory(outputDirectory);
            this.__IM.onExit((Object)this, "setOutputDirectory$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setOutputDirectory$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_setOutputDirectory(String outputDirectory) {
        this.__getlogger().fine("Output directory is now... " + outputDirectory);
        this.__setoutputDIR(Utils.isEmptyOrWhitespaces((String)outputDirectory) ? null : new File(outputDirectory));
        if (this.__getoutputDIR() != null && this.__getdm() != null) {
            for (ManagedApplication ma : this.__getdm().applicationMngr().getManagedApplications()) {
                this.application(ma.getApplication(), EventType.CHANGED);
            }
        }
    }

    public void bindManager(Manager dm) {
        if (!this.__MbindManager$net_roboconf_dm_management_Manager) {
            this.__M_bindManager(dm);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindManager$net_roboconf_dm_management_Manager", new Object[]{dm});
            this.__M_bindManager(dm);
            this.__IM.onExit((Object)this, "bindManager$net_roboconf_dm_management_Manager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindManager$net_roboconf_dm_management_Manager", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_bindManager(Manager dm) {
        Object object = this.__getgenerationLock();
        synchronized (object) {
            this.__getlogger().fine("The DM is now available in the templating manager.");
            this.__setdm(dm);
        }
    }

    public void unbindManager(Manager dm) {
        if (!this.__MunbindManager$net_roboconf_dm_management_Manager) {
            this.__M_unbindManager(dm);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindManager$net_roboconf_dm_management_Manager", new Object[]{dm});
            this.__M_unbindManager(dm);
            this.__IM.onExit((Object)this, "unbindManager$net_roboconf_dm_management_Manager", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindManager$net_roboconf_dm_management_Manager", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_unbindManager(Manager dm) {
        Object object = this.__getgenerationLock();
        synchronized (object) {
            this.__getlogger().fine("The DM is NOT available anymore in the templating manager.");
            this.__setdm(null);
        }
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_start() {
        Object object = this.__getwatcherLock();
        synchronized (object) {
            this.__getlogger().config("The templating manager is starting...");
            this.resetWatcher();
        }
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_stop() {
        Object object = this.__getwatcherLock();
        synchronized (object) {
            this.__getlogger().config("The templating manager is stopping...");
            this.stopWatcher();
        }
    }

    public String getId() {
        String string;
        if (!this.__MgetId) {
            return this.__M_getId();
        }
        try {
            this.__IM.onEntry((Object)this, "getId", new Object[0]);
            string = this.__M_getId();
            this.__IM.onExit((Object)this, "getId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getId() {
        return ID;
    }

    public void application(Application application, EventType eventType) {
        if (!this.__Mapplication$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType) {
            this.__M_application(application, eventType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "application$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", new Object[]{application, eventType});
            this.__M_application(application, eventType);
            this.__IM.onExit((Object)this, "application$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "application$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_application(Application application, EventType eventType) {
        if (this.__getoutputDIR() == null) {
            this.__getlogger().warning("Generation from templates is skipped. Invalid output directory.");
        } else if (eventType == EventType.DELETED) {
            Object object = this.__getgenerationLock();
            synchronized (object) {
                TemplateUtils.deleteGeneratedFiles(application, this.__getoutputDIR());
            }
        } else {
            this.generate(application);
        }
    }

    public void applicationTemplate(ApplicationTemplate tpl, EventType eventType) {
        if (!this.__MapplicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType) {
            this.__M_applicationTemplate(tpl, eventType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "applicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType", new Object[]{tpl, eventType});
            this.__M_applicationTemplate(tpl, eventType);
            this.__IM.onExit((Object)this, "applicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "applicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType", throwable);
            throw throwable;
        }
    }

    private void __M_applicationTemplate(ApplicationTemplate tpl, EventType eventType) {
    }

    public void instance(Instance instance, Application application, EventType eventType) {
        if (!this.__Minstance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType) {
            this.__M_instance(instance, application, eventType);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "instance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", new Object[]{instance, application, eventType});
            this.__M_instance(instance, application, eventType);
            this.__IM.onExit((Object)this, "instance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "instance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType", throwable);
            throw throwable;
        }
    }

    private void __M_instance(Instance instance, Application application, EventType eventType) {
        this.application(application, EventType.CHANGED);
    }

    public void raw(String message, Object ... data) {
        if (!this.__Mraw$java_lang_String$java_lang_Object__) {
            this.__M_raw(message, data);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "raw$java_lang_String$java_lang_Object__", new Object[]{message, data});
            this.__M_raw(message, data);
            this.__IM.onExit((Object)this, "raw$java_lang_String$java_lang_Object__", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "raw$java_lang_String$java_lang_Object__", throwable);
            throw throwable;
        }
    }

    private void __M_raw(String message, Object[] data) {
    }

    public void enableNotifications() {
        if (!this.__MenableNotifications) {
            this.__M_enableNotifications();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "enableNotifications", new Object[0]);
            this.__M_enableNotifications();
            this.__IM.onExit((Object)this, "enableNotifications", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "enableNotifications", throwable);
            throw throwable;
        }
    }

    private void __M_enableNotifications() {
    }

    public void disableNotifications() {
        if (!this.__MdisableNotifications) {
            this.__M_disableNotifications();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "disableNotifications", new Object[0]);
            this.__M_disableNotifications();
            this.__IM.onExit((Object)this, "disableNotifications", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "disableNotifications", throwable);
            throw throwable;
        }
    }

    private void __M_disableNotifications() {
    }

    public void processNewTemplates(Collection<TemplateEntry> newTemplates) {
        if (!this.__MprocessNewTemplates$java_util_Collection) {
            this.__M_processNewTemplates(newTemplates);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "processNewTemplates$java_util_Collection", new Object[]{newTemplates});
            this.__M_processNewTemplates(newTemplates);
            this.__IM.onExit((Object)this, "processNewTemplates$java_util_Collection", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "processNewTemplates$java_util_Collection", throwable);
            throw throwable;
        }
    }

    private void __M_processNewTemplates(Collection<TemplateEntry> newTemplates) {
        if (this.__getdm() != null) {
            for (ManagedApplication ma : this.__getdm().applicationMngr().getManagedApplications()) {
                Collection<TemplateEntry> filteredTemplates = TemplateUtils.findTemplatesForApplication(ma.getName(), newTemplates);
                this.generate(ma.getApplication(), filteredTemplates);
            }
        }
    }

    private void resetWatcher() {
        if (!this.__MresetWatcher) {
            this.__M_resetWatcher();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "resetWatcher", new Object[0]);
            this.__M_resetWatcher();
            this.__IM.onExit((Object)this, "resetWatcher", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "resetWatcher", throwable);
            throw throwable;
        }
    }

    private void __M_resetWatcher() {
        this.stopWatcher();
        if (this.__gettemplatesDIR() == null) {
            this.__getlogger().warning("The templates directory was not specified. DM templating is temporarily disabled.");
        } else if (this.__getoutputDIR() == null) {
            this.__getlogger().warning("The templates directory was not specified. DM templating is temporarily disabled.");
        } else {
            this.__settemplateWatcher(new TemplateWatcher(this, this.__gettemplatesDIR(), this.__getpollInterval()));
            this.__gettemplateWatcher().start();
        }
    }

    private void stopWatcher() {
        if (!this.__MstopWatcher) {
            this.__M_stopWatcher();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stopWatcher", new Object[0]);
            this.__M_stopWatcher();
            this.__IM.onExit((Object)this, "stopWatcher", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stopWatcher", throwable);
            throw throwable;
        }
    }

    private void __M_stopWatcher() {
        if (this.__gettemplateWatcher() != null) {
            try {
                this.__gettemplateWatcher().stop();
            }
            finally {
                this.__settemplateWatcher(null);
            }
        }
    }

    void generate(Application application) {
        if (!this.__Mgenerate$net_roboconf_core_model_beans_Application) {
            this.__M_generate(application);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "generate$net_roboconf_core_model_beans_Application", new Object[]{application});
            this.__M_generate(application);
            this.__IM.onExit((Object)this, "generate$net_roboconf_core_model_beans_Application", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generate$net_roboconf_core_model_beans_Application", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_generate(Application application) {
        List<TemplateEntry> templates = Collections.emptyList();
        Object object = this.__getwatcherLock();
        synchronized (object) {
            if (this.__gettemplateWatcher() != null) {
                templates = this.__gettemplateWatcher().findTemplatesForApplication(application.getName());
            }
        }
        this.generate(application, templates);
    }

    void generate(Application application, Collection<TemplateEntry> templates) {
        if (!this.__Mgenerate$net_roboconf_core_model_beans_Application$java_util_Collection) {
            this.__M_generate(application, templates);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "generate$net_roboconf_core_model_beans_Application$java_util_Collection", new Object[]{application, templates});
            this.__M_generate(application, templates);
            this.__IM.onExit((Object)this, "generate$net_roboconf_core_model_beans_Application$java_util_Collection", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "generate$net_roboconf_core_model_beans_Application$java_util_Collection", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __M_generate(Application application, Collection<TemplateEntry> templates) {
        try {
            Object object = this.__getgenerationLock();
            synchronized (object) {
                TemplateUtils.generate(application, this.__getoutputDIR(), templates, this.__getlogger());
            }
        }
        catch (IOException e) {
            this.__getlogger().warning("An error occurred while generating files from templates for application " + application);
            Utils.logException((Logger)this.__getlogger(), (Throwable)e);
        }
        catch (Throwable e) {
            this.__getlogger().warning("An unexpected error occurred while generating files from templates for application " + application);
            Utils.logException((Logger)this.__getlogger(), (Throwable)new UndeclaredThrowableException(e));
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("dm")) {
                this.__Fdm = true;
            }
            if (set.contains("generationLock")) {
                this.__FgenerationLock = true;
            }
            if (set.contains("logger")) {
                this.__Flogger = true;
            }
            if (set.contains("outputDIR")) {
                this.__FoutputDIR = true;
            }
            if (set.contains("pollInterval")) {
                this.__FpollInterval = true;
            }
            if (set.contains("templateWatcher")) {
                this.__FtemplateWatcher = true;
            }
            if (set.contains("templatesDIR")) {
                this.__FtemplatesDIR = true;
            }
            if (set.contains("watcherLock")) {
                this.__FwatcherLock = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setPollInterval$long")) {
                this.__MsetPollInterval$long = true;
            }
            if (set.contains("setTemplatesDirectory$java_lang_String")) {
                this.__MsetTemplatesDirectory$java_lang_String = true;
            }
            if (set.contains("setOutputDirectory$java_lang_String")) {
                this.__MsetOutputDirectory$java_lang_String = true;
            }
            if (set.contains("bindManager$net_roboconf_dm_management_Manager")) {
                this.__MbindManager$net_roboconf_dm_management_Manager = true;
            }
            if (set.contains("unbindManager$net_roboconf_dm_management_Manager")) {
                this.__MunbindManager$net_roboconf_dm_management_Manager = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getId")) {
                this.__MgetId = true;
            }
            if (set.contains("application$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType")) {
                this.__Mapplication$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType = true;
            }
            if (set.contains("applicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType")) {
                this.__MapplicationTemplate$net_roboconf_core_model_beans_ApplicationTemplate$net_roboconf_core_model_runtime_EventType = true;
            }
            if (set.contains("instance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType")) {
                this.__Minstance$net_roboconf_core_model_beans_Instance$net_roboconf_core_model_beans_Application$net_roboconf_core_model_runtime_EventType = true;
            }
            if (set.contains("raw$java_lang_String$java_lang_Object__")) {
                this.__Mraw$java_lang_String$java_lang_Object__ = true;
            }
            if (set.contains("enableNotifications")) {
                this.__MenableNotifications = true;
            }
            if (set.contains("disableNotifications")) {
                this.__MdisableNotifications = true;
            }
            if (set.contains("processNewTemplates$java_util_Collection")) {
                this.__MprocessNewTemplates$java_util_Collection = true;
            }
            if (set.contains("resetWatcher")) {
                this.__MresetWatcher = true;
            }
            if (set.contains("stopWatcher")) {
                this.__MstopWatcher = true;
            }
            if (set.contains("generate$net_roboconf_core_model_beans_Application")) {
                this.__Mgenerate$net_roboconf_core_model_beans_Application = true;
            }
            if (set.contains("generate$net_roboconf_core_model_beans_Application$java_util_Collection")) {
                this.__Mgenerate$net_roboconf_core_model_beans_Application$java_util_Collection = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

