/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.templating.internal.contexts;

import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.dm.templating.internal.contexts.ApplicationContextBean;
import net.roboconf.dm.templating.internal.contexts.ImportContextBean;
import net.roboconf.dm.templating.internal.contexts.InstanceContextBean;
import net.roboconf.dm.templating.internal.contexts.VariableContextBean;

public final class ContextUtils {
    private ContextUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static ApplicationContextBean toContext(Application app) {
        InstanceContextBean instanceContext;
        ApplicationContextBean context = new ApplicationContextBean();
        context.lastModified = new Date();
        context.name = app.getName();
        context.description = app.getDescription();
        for (Component component : ComponentHelpers.findAllComponents((AbstractApplication)app)) {
            context.components.add(component.getName());
        }
        LinkedHashMap<String, InstanceContextBean> instancesByPath = new LinkedHashMap<String, InstanceContextBean>();
        List allInstances = InstanceHelpers.getAllInstances((AbstractApplication)app);
        for (Instance instance : allInstances) {
            String path;
            instanceContext = new InstanceContextBean();
            instanceContext.path = path = InstanceHelpers.computeInstancePath((Instance)instance);
            instanceContext.name = instance.getName();
            instanceContext.status = instance.getStatus();
            instanceContext.statusIsStable = instance.getStatus().isStable();
            instanceContext.component = instance.getComponent().getName();
            instanceContext.types.addAll(ContextUtils.findExtendedTypes(instance.getComponent()));
            instanceContext.ip = (String)instance.data.get("ip.address");
            instanceContext.installer = ComponentHelpers.findComponentInstaller((Component)instance.getComponent());
            for (Map.Entry exportEntry : InstanceHelpers.findAllExportedVariables((Instance)instance).entrySet()) {
                VariableContextBean variableContextBean = new VariableContextBean();
                variableContextBean.name = (String)exportEntry.getKey();
                variableContextBean.value = (String)exportEntry.getValue();
                instanceContext.exports.add(variableContextBean);
            }
            for (Map.Entry dataEntry : instance.data.entrySet()) {
                VariableContextBean variableContextBean = new VariableContextBean();
                variableContextBean.name = (String)dataEntry.getKey();
                variableContextBean.value = (String)dataEntry.getValue();
                instanceContext.data.add(variableContextBean);
            }
            instancesByPath.put(path, instanceContext);
            context.instances.add(instanceContext);
            for (String typeName : instanceContext.types) {
                void var10_15;
                Set<InstanceContextBean> set = context.instancesByType.get(typeName);
                if (set == null) {
                    LinkedHashSet linkedHashSet = new LinkedHashSet();
                    context.instancesByType.put(typeName, linkedHashSet);
                }
                var10_15.add(instanceContext);
            }
        }
        for (Instance instance : allInstances) {
            Collection children;
            instanceContext = (InstanceContextBean)instancesByPath.get(InstanceHelpers.computeInstancePath((Instance)instance));
            Instance parent = instance.getParent();
            if (parent != null) {
                instanceContext.parent = (InstanceContextBean)instancesByPath.get(InstanceHelpers.computeInstancePath((Instance)parent));
            }
            if (!(children = instance.getChildren()).isEmpty()) {
                for (Instance instance2 : children) {
                    instanceContext.children.add((InstanceContextBean)instancesByPath.get(InstanceHelpers.computeInstancePath((Instance)instance2)));
                }
            }
            for (Map.Entry entry : instance.getImports().entrySet()) {
                for (Import importedVariable : (Collection)entry.getValue()) {
                    ImportContextBean importContext = new ImportContextBean();
                    importContext.component = importedVariable.getComponentName();
                    importContext.instance = (InstanceContextBean)instancesByPath.get(importedVariable.getInstancePath());
                    for (Map.Entry entry2 : importedVariable.getExportedVars().entrySet()) {
                        VariableContextBean variable = new VariableContextBean();
                        variable.name = (String)entry2.getKey();
                        variable.value = (String)entry2.getValue();
                        importContext.variables.add(variable);
                    }
                    instanceContext.imports.add(importContext);
                }
            }
        }
        return context;
    }

    private static Set<String> findExtendedTypes(Component baseComponent) {
        LinkedList types = new LinkedList();
        types.addAll(ComponentHelpers.findAllExtendedComponents((Component)baseComponent));
        types.addAll(ComponentHelpers.findAllFacets((Component)baseComponent));
        LinkedHashSet<String> typeNames = new LinkedHashSet<String>();
        for (AbstractType type : types) {
            typeNames.add(type.getName());
        }
        return typeNames;
    }
}

