/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.templating.internal.helpers;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.templating.internal.contexts.ApplicationContextBean;
import net.roboconf.dm.templating.internal.contexts.InstanceContextBean;
import net.roboconf.dm.templating.internal.helpers.InstanceFilter;

public class AllHelper
implements Helper<Object> {
    public static final String NAME = "all";
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public CharSequence apply(Object computedContext, Options options) throws IOException {
        Object context = options.context.model();
        String componentPath = null;
        if (computedContext instanceof String) {
            componentPath = (String)computedContext;
        }
        if (Utils.isEmptyOrWhitespaces(componentPath)) {
            componentPath = "*";
        }
        String result = "";
        if (context instanceof ApplicationContextBean) {
            result = this.safeApply(((ApplicationContextBean)context).getInstances(), options, componentPath);
        } else if (context instanceof InstanceContextBean) {
            result = this.safeApply(AllHelper.descendantInstances((InstanceContextBean)context), options, componentPath);
        } else {
            this.logger.warning("An unexpected context was received: " + (context == null ? null : context.getClass()));
        }
        return result;
    }

    private String safeApply(Collection<InstanceContextBean> instances, Options options, String componentPath) throws IOException {
        String installerName = (String)options.hash.get("installer");
        InstanceFilter filter = InstanceFilter.createFilter(componentPath, installerName);
        Collection<InstanceContextBean> selectedInstances = filter.apply(instances);
        StringBuilder buffer = new StringBuilder();
        Context parent = options.context;
        int index = 0;
        int last = selectedInstances.size() - 1;
        for (InstanceContextBean instance : selectedInstances) {
            Context current = Context.newBuilder((Context)parent, (Object)instance).combine("@index", (Object)index).combine("@first", (Object)(index == 0 ? "first" : "")).combine("@last", (Object)(index == last ? "last" : "")).combine("@odd", (Object)(index % 2 == 0 ? "" : "odd")).combine("@even", (Object)(index % 2 == 0 ? "even" : "")).build();
            ++index;
            buffer.append(options.fn((Object)current));
        }
        return buffer.toString();
    }

    private static Collection<InstanceContextBean> descendantInstances(InstanceContextBean instance) {
        ArrayList<InstanceContextBean> result = new ArrayList<InstanceContextBean>();
        for (InstanceContextBean child : instance.getChildren()) {
            result.add(child);
            result.addAll(AllHelper.descendantInstances(child));
        }
        return result;
    }
}

