/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.templating.internal.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.templating.internal.contexts.InstanceContextBean;

public final class InstanceFilter {
    public static final String JOKER = "*";
    public static final String PATH_SEPARATOR = "/";
    public static final String ALTERNATIVE = "|";
    private final String path;
    private final Node rootNode;
    private final String installerName;

    private InstanceFilter(String path, Node rootNode, String installerName) {
        this.path = path;
        this.rootNode = rootNode;
        this.installerName = installerName;
    }

    public static InstanceFilter createFilter(String path, String installerName) {
        List types = Utils.splitNicely((String)path, (String)ALTERNATIVE);
        OrNode rootNode = new OrNode();
        for (String type : types) {
            Node node = InstanceFilter.buildNodeForPath(type);
            rootNode.delegates.add(node);
        }
        return new InstanceFilter(path, rootNode, installerName);
    }

    public Collection<InstanceContextBean> apply(Collection<InstanceContextBean> instances) {
        ArrayList<InstanceContextBean> result = new ArrayList<InstanceContextBean>();
        for (InstanceContextBean instance : instances) {
            boolean installerMatches = this.installerName == null || this.installerName.equalsIgnoreCase(instance.getInstaller());
            if (!installerMatches || !this.rootNode.isMatching(instance)) continue;
            result.add(instance);
        }
        result.trimToSize();
        return Collections.unmodifiableCollection(result);
    }

    public String getPath() {
        return this.path;
    }

    private static Node buildNodeForPath(String path) {
        String[] elements = path.split(PATH_SEPARATOR, -1);
        int last = elements.length - 1;
        Node rootNode = null;
        AndNode parentNode = null;
        for (int i = last; i >= 0; --i) {
            String element = elements[i];
            if (element.isEmpty()) {
                Logger logger = Logger.getLogger(InstanceFilter.class.getName());
                logger.warning("An invalid component path was found in templates. Wrong part is: '" + path + "'.");
                rootNode = null;
                break;
            }
            AndNode currentNode = new AndNode();
            if (!JOKER.equals(element)) {
                currentNode.delegates.add(new TypeNode(element));
            }
            if (i == 1 && elements[0].isEmpty()) {
                currentNode.delegates.add(new RootInstanceNode());
                i = 0;
            }
            if (rootNode == null) {
                rootNode = currentNode;
            } else {
                parentNode.delegates.add(new ParentInstanceNode(currentNode));
            }
            parentNode = currentNode;
        }
        return rootNode != null ? rootNode : new ErrorNode();
    }

    private static class RootInstanceNode
    extends Node {
        private RootInstanceNode() {
        }

        @Override
        boolean isMatching(InstanceContextBean instance) {
            return instance.getParent() == null;
        }
    }

    private static class ParentInstanceNode
    extends Node {
        final Node parentInstanceNode;

        ParentInstanceNode(Node parentInstanceNode) {
            this.parentInstanceNode = parentInstanceNode;
        }

        @Override
        boolean isMatching(InstanceContextBean instance) {
            return instance.getParent() != null && this.parentInstanceNode.isMatching(instance.getParent());
        }
    }

    private static class TypeNode
    extends Node {
        final String typeName;

        TypeNode(String typeName) {
            this.typeName = typeName;
        }

        @Override
        boolean isMatching(InstanceContextBean instance) {
            boolean matching = instance.getTypes().contains(this.typeName);
            if (!matching && this.typeName.contains(InstanceFilter.JOKER)) {
                String pattern = this.typeName.replace(InstanceFilter.JOKER, ".*");
                for (String type : instance.getTypes()) {
                    if (!type.matches(pattern)) continue;
                    matching = true;
                    break;
                }
            }
            return matching;
        }
    }

    private static class OrNode
    extends Node {
        final LinkedList<Node> delegates = new LinkedList();

        private OrNode() {
        }

        @Override
        boolean isMatching(InstanceContextBean instance) {
            boolean matching = false;
            Iterator it = this.delegates.iterator();
            while (it.hasNext() && !matching) {
                matching = ((Node)it.next()).isMatching(instance);
            }
            return matching;
        }
    }

    private static class AndNode
    extends Node {
        final LinkedList<Node> delegates = new LinkedList();

        private AndNode() {
        }

        @Override
        boolean isMatching(InstanceContextBean instance) {
            boolean matching = true;
            Iterator it = this.delegates.iterator();
            while (it.hasNext() && matching) {
                matching = ((Node)it.next()).isMatching(instance);
            }
            return matching;
        }
    }

    private static class ErrorNode
    extends Node {
        private ErrorNode() {
        }

        @Override
        boolean isMatching(InstanceContextBean instance) {
            return false;
        }
    }

    private static abstract class Node {
        private Node() {
        }

        abstract boolean isMatching(InstanceContextBean var1);
    }
}

