/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.templating.internal.templates;

import com.github.jknack.handlebars.Context;
import com.github.jknack.handlebars.ValueResolver;
import com.github.jknack.handlebars.context.JavaBeanValueResolver;
import com.github.jknack.handlebars.context.MapValueResolver;
import com.github.jknack.handlebars.context.MethodValueResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.templating.internal.contexts.ApplicationContextBean;
import net.roboconf.dm.templating.internal.contexts.ContextUtils;
import net.roboconf.dm.templating.internal.resolvers.ComponentPathResolver;
import net.roboconf.dm.templating.internal.templates.TemplateEntry;

public final class TemplateUtils {
    private TemplateUtils() {
    }

    public static String findApplicationName(File templateDir, File templateFile) {
        String appName;
        File parentDir = templateFile.getParentFile();
        if (templateDir.equals(parentDir)) {
            appName = null;
        } else if (templateDir.equals(parentDir.getParentFile())) {
            appName = parentDir.getName();
        } else {
            throw new IllegalArgumentException("Not a template file: " + templateFile);
        }
        return appName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(Application app, File outputDirectory, Collection<TemplateEntry> templates, Logger logger) throws IOException {
        ApplicationContextBean appCtx = ContextUtils.toContext(app);
        Context wrappingCtx = Context.newBuilder((Object)appCtx).resolver(new ValueResolver[]{MapValueResolver.INSTANCE, JavaBeanValueResolver.INSTANCE, MethodValueResolver.INSTANCE, new ComponentPathResolver()}).build();
        try {
            for (TemplateEntry template : templates) {
                File target;
                logger.fine("Processing template " + template.getTemplateFile() + " to application " + app + ".");
                String targetFilePath = template.getTargetFilePath();
                if (!Utils.isEmptyOrWhitespaces((String)targetFilePath)) {
                    target = new File(targetFilePath.replace("${app}", app.getName()));
                } else {
                    String filename = template.getTemplateFile().getName().replaceFirst("\\.tpl$", "");
                    target = new File(outputDirectory, app.getName() + "/" + filename);
                }
                Utils.createDirectory((File)target.getParentFile());
                String output = template.getTemplate().apply(wrappingCtx);
                Utils.writeStringInto((String)output, (File)target);
                logger.fine("Template " + template.getTemplateFile() + " was processed with application " + app + ". Output is in " + target);
            }
        }
        finally {
            wrappingCtx.destroy();
        }
    }

    public static void deleteGeneratedFiles(Application app, File outputDirectory) {
        File target = new File(outputDirectory, app.getName());
        Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{target});
    }

    public static Collection<TemplateEntry> findTemplatesForApplication(String appName, Collection<TemplateEntry> templates) {
        ArrayList<TemplateEntry> result = new ArrayList<TemplateEntry>();
        for (TemplateEntry te : templates) {
            if (te.getAppName() != null && !te.getAppName().equals(appName)) continue;
            result.add(te);
        }
        return result;
    }
}

