/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.dm.templating.internal.templates;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.HandlebarsException;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.io.StringTemplateSource;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.templating.internal.TemplatingManager;
import net.roboconf.dm.templating.internal.helpers.AllHelper;
import net.roboconf.dm.templating.internal.helpers.IsKeyHelper;
import net.roboconf.dm.templating.internal.templates.TemplateEntry;
import net.roboconf.dm.templating.internal.templates.TemplateUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.CanReadFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class TemplateWatcher
extends FileAlterationListenerAdaptor {
    private static final ThreadFactory THREAD_FACTORY = new WatcherThreadFactory();
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private final AtomicBoolean alreadyStarted = new AtomicBoolean(false);
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Handlebars handlebars = new Handlebars();
    private final Map<File, TemplateEntry> fileToTemplate = new HashMap<File, TemplateEntry>();
    private final TemplatingManager manager;
    private final File templateDir;
    private final FileAlterationMonitor monitor;

    public TemplateWatcher(TemplatingManager manager, File templateDir, long pollInterval) {
        this.templateDir = templateDir;
        this.handlebars.registerHelper("all", (Helper)new AllHelper());
        this.handlebars.registerHelper("is-key", (Helper)new IsKeyHelper());
        this.handlebars.prettyPrint(true);
        IOFileFilter fileFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.suffixFileFilter((String)".tpl"), CanReadFileFilter.CAN_READ, new TemplateFileFilter(templateDir)}), FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.directoryFileFilter(), CanReadFileFilter.CAN_READ, new TemplateSubDirectoryFileFilter(templateDir)})});
        FileAlterationObserver observer = new FileAlterationObserver(this.templateDir, (FileFilter)fileFilter);
        observer.addListener((FileAlterationListener)this);
        this.monitor = new FileAlterationMonitor(pollInterval, new FileAlterationObserver[]{observer});
        this.monitor.setThreadFactory(THREAD_FACTORY);
        this.manager = manager;
        this.logger.fine("Template watcher is watching " + this.templateDir + " with an interval of " + pollInterval + " ms.");
    }

    public void start() {
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            this.logger.warning("Cannot start template watcher");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            this.logger.warning("Cannot stop template watcher");
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
    }

    public Collection<TemplateEntry> findTemplatesForApplication(String appName) {
        ArrayList<TemplateEntry> result = new ArrayList<TemplateEntry>();
        this.lock.readLock().lock();
        try {
            result.addAll(TemplateUtils.findTemplatesForApplication(appName, this.fileToTemplate.values()));
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public void onStart(FileAlterationObserver observer) {
        if (this.alreadyStarted.getAndSet(true)) {
            return;
        }
        this.logger.fine("Initial provisioning of templates...");
        Collection templateFiles = FileUtils.listFiles((File)this.templateDir, (IOFileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".tpl"), CanReadFileFilter.CAN_READ}), (IOFileFilter)new TemplateDirectoryFileFilter(this.templateDir));
        this.process(templateFiles);
    }

    public void onFileCreate(File file) {
        this.logger.fine("Template file " + file + " has just been created. Generating files...");
        this.process(Collections.singletonList(file));
    }

    public void onFileChange(File file) {
        this.logger.fine("Template file " + file + " changed. Updating the generated files...");
        this.process(Collections.singletonList(file));
    }

    public void onFileDelete(File file) {
        this.logger.fine("Template file " + file + " was deleted. Generated files won't be removed automatically.");
        this.lock.writeLock().lock();
        try {
            this.fileToTemplate.remove(file);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public TemplateEntry compileTemplate(File templateFile) {
        TemplateEntry templateEntry = null;
        try {
            String templateFileContent = Utils.readFileContent((File)templateFile);
            Matcher m = Pattern.compile("\\{\\{!\\s*roboconf-output:(.*)\\}\\}").matcher(templateFileContent.trim());
            String targetFilePath = null;
            if (m.find()) {
                targetFilePath = m.group(1).trim();
            }
            Template template = this.handlebars.compile((TemplateSource)new StringTemplateSource(templateFile.toString(), templateFileContent));
            templateEntry = new TemplateEntry(templateFile, targetFilePath, template, TemplateUtils.findApplicationName(this.templateDir, templateFile));
        }
        catch (HandlebarsException | IOException | IllegalArgumentException e) {
            this.logger.warning("Cannot compile template " + templateFile);
            Utils.logException((Logger)this.logger, (Throwable)e);
        }
        return templateEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(Collection<File> templateFiles) {
        ArrayList<TemplateEntry> templateEntries = new ArrayList<TemplateEntry>();
        for (File f : templateFiles) {
            TemplateEntry templateEntry = this.compileTemplate(f);
            if (templateEntry == null) continue;
            templateEntries.add(templateEntry);
        }
        this.lock.writeLock().lock();
        try {
            for (TemplateEntry te : templateEntries) {
                this.fileToTemplate.put(te.getTemplateFile(), te);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.manager.processNewTemplates(templateEntries);
    }

    private static final class WatcherThreadFactory
    implements ThreadFactory {
        private WatcherThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Roboconf's Templates Watcher");
        }
    }

    static class TemplateFileFilter
    extends AbstractFileFilter {
        private final File rootTemplateDir;

        TemplateFileFilter(File rootTemplateDir) {
            this.rootTemplateDir = rootTemplateDir;
        }

        public boolean accept(File file) {
            File parentDir = file.getParentFile();
            return this.rootTemplateDir.equals(parentDir) || this.rootTemplateDir.equals(parentDir.getParentFile());
        }
    }

    static class TemplateSubDirectoryFileFilter
    extends AbstractFileFilter {
        private final File rootTemplateDir;

        TemplateSubDirectoryFileFilter(File rootTemplateDir) {
            this.rootTemplateDir = rootTemplateDir;
        }

        public boolean accept(File file) {
            return this.rootTemplateDir.equals(file.getParentFile());
        }
    }

    static class TemplateDirectoryFileFilter
    extends AbstractFileFilter {
        final File rootTemplateDir;

        TemplateDirectoryFileFilter(File rootTemplateDir) {
            this.rootTemplateDir = rootTemplateDir;
        }

        public boolean accept(File file) {
            return this.rootTemplateDir.equals(file) || this.rootTemplateDir.equals(file.getParentFile());
        }
    }
}

